/*
 * Decompiled with CFR 0.152.
 */
package ganymedes01.aobd.recipes;

import cpw.mods.fml.common.registry.GameRegistry;
import cpw.mods.fml.relauncher.Side;
import cpw.mods.fml.relauncher.SideOnly;
import ganymedes01.aobd.items.AOBDGlassBottle;
import ganymedes01.aobd.lib.CompatType;
import ganymedes01.aobd.ore.Ore;
import ganymedes01.aobd.ore.OreFinder;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import net.minecraft.client.renderer.texture.TextureMap;
import net.minecraft.init.Items;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.item.crafting.FurnaceRecipes;
import net.minecraft.util.IIcon;
import net.minecraft.util.StatCollector;
import net.minecraftforge.fluids.Fluid;
import net.minecraftforge.fluids.FluidContainerRegistry;
import net.minecraftforge.fluids.FluidRegistry;
import net.minecraftforge.fluids.FluidStack;
import net.minecraftforge.oredict.OreDictionary;

public abstract class RecipesModule {
    @SideOnly(value=Side.CLIENT)
    private static IIcon still;
    @SideOnly(value=Side.CLIENT)
    private static IIcon flow;
    private final CompatType type;
    private final List<String> blacklist;
    private static final Map<String, ItemStack> cache;

    public RecipesModule(CompatType type, String ... blacklist) {
        this.type = type;
        this.blacklist = blacklist != null && blacklist.length > 0 ? Arrays.asList(blacklist) : Collections.emptyList();
    }

    public final void init() {
        this.preInit();
        for (Ore ore : Ore.ores) {
            if (!this.isOreEnabled(ore)) continue;
            this.initOre(ore);
        }
    }

    protected boolean isOreEnabled(Ore ore) {
        return ore.isCompatEnabled(this.type) && !this.blacklist.contains(ore.name().toLowerCase());
    }

    protected void preInit() {
    }

    protected abstract void initOre(Ore var1);

    protected void postInit() {
    }

    public static ItemStack getOreStack(String prefix, Ore ore) {
        return RecipesModule.getOreStack(prefix, ore, 1, false);
    }

    public static ItemStack getOreStack(String prefix, Ore ore, int size) {
        return RecipesModule.getOreStack(prefix, ore, size, false);
    }

    public static ItemStack getOreStackExtra(String prefix, Ore ore) {
        return RecipesModule.getOreStack(prefix, ore, 1, true);
    }

    public static ItemStack getOreStackExtra(String prefix, Ore ore, int size) {
        return RecipesModule.getOreStack(prefix, ore, size, true);
    }

    private static ItemStack getOreStack(String prefix, Ore ore, int size, boolean extra) {
        if (extra) {
            try {
                return RecipesModule.getOreStack(prefix + ore.extra(), size);
            }
            catch (NullPointerException e) {
                return RecipesModule.getOreStack(prefix, ore, size);
            }
        }
        return RecipesModule.getOreStack(prefix + ore.name(), size);
    }

    protected static ItemStack getOreStack(String name) {
        return RecipesModule.getOreStack(name, 1);
    }

    protected static ItemStack getOreStack(String name, int size) {
        try {
            if (OreFinder.itemMap.containsKey(name)) {
                return new ItemStack(OreFinder.itemMap.get(name), size);
            }
            ItemStack stack = ItemStack.func_77944_b((ItemStack)cache.get(name));
            if (stack != null) {
                stack.field_77994_a = size;
                return stack;
            }
            stack = ItemStack.func_77944_b((ItemStack)((ItemStack)OreDictionary.getOres((String)name).get(0)));
            cache.put(name, stack.func_77946_l());
            stack.field_77994_a = size;
            return stack;
        }
        catch (Exception e) {
            throw new NullPointerException("Ore dictionary item not found: " + name);
        }
    }

    public static void clearCache() {
        cache.clear();
    }

    protected void addSmeltingNoDupes(ItemStack input, ItemStack output, float xp) {
        for (ItemStack stack : FurnaceRecipes.func_77602_a().func_77599_b().keySet()) {
            if (!this.areStacksTheSame(stack, input)) continue;
            return;
        }
        GameRegistry.addSmelting((ItemStack)input, (ItemStack)output, (float)xp);
    }

    protected boolean areStacksTheSame(ItemStack stack1, ItemStack stack2) {
        return stack1.func_77973_b() == stack2.func_77973_b() && stack1.func_77960_j() == stack2.func_77960_j();
    }

    public List<String> blacklist() {
        return Collections.unmodifiableList(this.blacklist);
    }

    public CompatType type() {
        return this.type;
    }

    protected Fluid getFluid(Ore ore) {
        String fluidName = ore.name().toLowerCase();
        if ("yellorium".equals(fluidName)) {
            fluidName = "aobdyellorium";
        }
        if (!FluidRegistry.isFluidRegistered((String)fluidName)) {
            FluidRegistry.registerFluid((Fluid)new MoltenMetal(ore, fluidName));
            Fluid fluid = FluidRegistry.getFluid((String)fluidName);
            AOBDGlassBottle bottle = new AOBDGlassBottle(fluid);
            GameRegistry.registerItem((Item)bottle, (String)("bottle_" + fluidName));
            FluidContainerRegistry.registerFluidContainer((FluidStack)new FluidStack(fluid, 1000), (ItemStack)new ItemStack((Item)bottle), (ItemStack)new ItemStack(Items.field_151069_bo));
        }
        return FluidRegistry.getFluid((String)fluidName);
    }

    @SideOnly(value=Side.CLIENT)
    public static void registerMoltenMetalIcons(TextureMap map) {
        still = map.func_94245_a("aobd:fluid_still");
        flow = map.func_94245_a("aobd:fluid_flow");
    }

    static {
        cache = new HashMap<String, ItemStack>();
    }

    protected static class MoltenMetal
    extends Fluid {
        private final Ore ore;

        public MoltenMetal(Ore ore, String name) {
            super(name);
            this.ore = ore;
        }

        public IIcon getStillIcon() {
            return still;
        }

        public IIcon getFlowingIcon() {
            return flow;
        }

        public int getColor() {
            return this.ore.colour();
        }

        public String getUnlocalizedName() {
            return "fluid.aobd." + this.unlocalizedName;
        }

        public String getLocalizedName(FluidStack stack) {
            String fullName = "fluid.aobd.molten" + this.ore.name() + ".name";
            String shortName = "fluid.aobd.moltenMetal.name";
            return StatCollector.func_94522_b((String)fullName) ? StatCollector.func_74838_a((String)fullName) : String.format(StatCollector.func_74838_a((String)shortName), this.ore.translatedName());
        }
    }
}

