/*
 * Decompiled with CFR 0.152.
 */
package extrabiomes.subblocks;

import extrabiomes.subblocks.SubBlock;
import java.util.LinkedList;
import java.util.List;
import net.minecraft.block.Block;
import net.minecraft.init.Blocks;
import net.minecraft.world.World;

public class SubBlockWaterPlant
extends SubBlock {
    private int maxHeight;
    private List<Block> groundBlocks;

    public SubBlockWaterPlant(String name) {
        this(name, 1);
    }

    public SubBlockWaterPlant(String name, int height) {
        super(name);
        this.maxHeight = height;
        this.groundBlocks = new LinkedList<Block>();
        this.groundBlocks.add(Blocks.field_150346_d);
    }

    @Override
    public boolean canPlaceBlockAt(World world, int x, int y, int z) {
        Block top = world.func_147439_a(x, y + 1, z);
        if (!(this.maxHeight > 1 && top.equals(this.parent) && this.metaData == world.func_72805_g(x, y + 1, z) || top.equals(Blocks.field_150355_j))) {
            return false;
        }
        for (int offset = 1; this.maxHeight >= offset; ++offset) {
            Block base = world.func_147439_a(x, y - offset, z);
            if (this.groundBlocks.isEmpty() || this.groundBlocks.contains(base)) {
                return true;
            }
            if (base.equals(this.parent) && this.metaData == world.func_72805_g(x, y - offset, z)) continue;
            return false;
        }
        return false;
    }

    @Override
    public void onNeighborBlockChange(World world, int x, int y, int z, Block neighbor, Block block) {
        if (!neighbor.equals(this.parent) && !this.canBlockStay(world, x, y, z)) {
            world.func_147449_b(x, y, z, Blocks.field_150355_j);
            block.func_149697_b(world, x, y, z, world.func_72805_g(x, y, z), 0);
        }
    }

    public SubBlockWaterPlant addPlaceableBlock(Block newBlock) {
        this.groundBlocks.add(newBlock);
        return this;
    }

    public SubBlockWaterPlant removePlaceableBlock(Block newBlock) {
        this.groundBlocks.remove(newBlock);
        return this;
    }
}

