/*
 * Decompiled with CFR 0.152.
 */
package extrabiomes.proxy;

import com.google.common.base.Optional;
import com.google.common.base.Preconditions;
import cpw.mods.fml.client.registry.ISimpleBlockRenderingHandler;
import cpw.mods.fml.common.FMLLog;
import cpw.mods.fml.common.IFuelHandler;
import cpw.mods.fml.common.IWorldGenerator;
import cpw.mods.fml.common.Loader;
import cpw.mods.fml.common.eventhandler.Event;
import cpw.mods.fml.common.registry.EntityRegistry;
import cpw.mods.fml.common.registry.GameRegistry;
import extrabiomes.helpers.LogHelper;
import java.util.ArrayList;
import java.util.Collection;
import net.minecraft.block.Block;
import net.minecraft.init.Blocks;
import net.minecraft.item.Item;
import net.minecraft.item.ItemBlock;
import net.minecraft.item.ItemStack;
import net.minecraft.item.crafting.CraftingManager;
import net.minecraft.item.crafting.FurnaceRecipes;
import net.minecraft.item.crafting.IRecipe;
import net.minecraft.world.World;
import net.minecraft.world.WorldType;
import net.minecraft.world.biome.BiomeGenBase;
import net.minecraftforge.common.ForgeHooks;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.oredict.OreDictionary;
import org.apache.logging.log4j.Logger;

public class CommonProxy {
    public void addBiome(Collection<WorldType> worldTypes, BiomeGenBase biome) {
    }

    public void addGrassPlant(Block block, int metadata, int weight, BiomeGenBase biome) {
        if (biome != null) {
            biome.addFlower(block, metadata, weight);
        }
    }

    public void addGrassPlant(Block block, int metadata, int weight) {
        for (BiomeGenBase biome : BiomeGenBase.func_150565_n()) {
            this.addGrassPlant(block, metadata, weight, biome);
        }
    }

    public void addRecipe(IRecipe recipe) {
        CraftingManager.func_77594_a().func_77592_b().add(0, recipe);
    }

    public void addSmelting(Item item, int metadata, ItemStack itemstack, float experience) {
        FurnaceRecipes.func_77602_a().func_151394_a(new ItemStack(item, 1, metadata), itemstack, experience);
    }

    public void addSmelting(ItemStack input, ItemStack output, float experience) {
        FurnaceRecipes.func_77602_a().func_151394_a(input, output, experience);
    }

    public int findGlobalUniqueEntityId() {
        return EntityRegistry.findGlobalUniqueEntityId();
    }

    public Logger getFMLLogger() {
        return FMLLog.getLogger();
    }

    public Optional<ItemStack> getGrassSeed(World world) {
        return Optional.fromNullable((Object)ForgeHooks.getGrassSeed((World)world));
    }

    public ArrayList<ItemStack> getOres(String name) {
        return OreDictionary.getOres((String)name);
    }

    public boolean isModLoaded(String modID) {
        return Loader.isModLoaded((String)modID);
    }

    public boolean postEventToBus(Event event) {
        return MinecraftForge.EVENT_BUS.post(event);
    }

    public void registerBlock(Block block, String uniqueName) {
        GameRegistry.registerBlock((Block)block, ItemBlock.class, (String)uniqueName);
    }

    public void registerBlock(Block block, Class<? extends ItemBlock> itemclass, String uniqueName) {
        GameRegistry.registerBlock((Block)block, itemclass, (String)uniqueName);
    }

    public int registerBlockHandler(ISimpleBlockRenderingHandler handler) {
        return 0;
    }

    public void registerEntity(Class entityClass, String entityName, Object mod, int entityID, int trackingRange, int updateFrequency, boolean sendsVelocityUpdates) {
        EntityRegistry.registerModEntity((Class)entityClass, (String)entityName, (int)entityID, (Object)mod, (int)trackingRange, (int)updateFrequency, (boolean)sendsVelocityUpdates);
    }

    public void registerEntityID(Class entityClass, String entityName, int entityID) {
        EntityRegistry.registerGlobalEntityID((Class)entityClass, (String)entityName, (int)entityID);
    }

    public void registerEventHandler(Object target) {
        MinecraftForge.EVENT_BUS.register(target);
    }

    public void registerFuelHandler(IFuelHandler fuelHandler) {
        GameRegistry.registerFuelHandler((IFuelHandler)((IFuelHandler)Preconditions.checkNotNull((Object)fuelHandler)));
    }

    public void registerItem(Item item, String name) {
        GameRegistry.registerItem((Item)item, (String)name, (String)"ExtrabiomesXL");
    }

    @Deprecated
    public void registerOre(int id, Block ore) {
        OreDictionary.registerOre((int)id, (ItemStack)new ItemStack(ore));
    }

    @Deprecated
    public void registerOre(int id, Item ore) {
        OreDictionary.registerOre((int)id, (ItemStack)new ItemStack(ore));
    }

    @Deprecated
    public void registerOre(int id, ItemStack ore) {
        OreDictionary.registerOre((int)id, (ItemStack)ore);
    }

    public void registerOre(String name, Block ore) {
        OreDictionary.registerOre((String)name, (ItemStack)new ItemStack(ore));
    }

    public void registerOre(String name, Item ore) {
        OreDictionary.registerOre((String)name, (ItemStack)new ItemStack(ore));
    }

    public void registerOre(String name, ItemStack ore) {
        OreDictionary.registerOre((String)name, (ItemStack)ore);
    }

    public void registerOreInAllSubblocks(String name, Block ore) {
        OreDictionary.registerOre((String)name, (ItemStack)new ItemStack(ore, 1, Short.MAX_VALUE));
    }

    public void registerRenderInformation() {
    }

    public void registerScarecrowRendering() {
    }

    public void registerWorldGenerator(IWorldGenerator worldGenerator) {
        GameRegistry.registerWorldGenerator((IWorldGenerator)worldGenerator, (int)50);
    }

    public void removeBiome(BiomeGenBase biome) {
        if (biome != null) {
            LogHelper.severe("REMOVING BIOMES NOT IMPLEMENTED IN DEV BUILD, TODO!", new Object[0]);
        } else {
            LogHelper.warning("Request to remove null biome", new Object[0]);
        }
    }

    public void setBlockHarvestLevel(Block block, String toolClass, int harvestLevel) {
        block.setHarvestLevel(toolClass, harvestLevel);
    }

    public void setFireInfo(Block block, int encouragement, int flammability) {
        Blocks.field_150480_ab.setFireInfo(block, encouragement, flammability);
    }
}

