/*
 * Decompiled with CFR 0.152.
 */
package extrabiomes.module.summa.worldgen;

import extrabiomes.helpers.LogHelper;
import extrabiomes.lib.Element;
import extrabiomes.module.summa.TreeSoilRegistry;
import extrabiomes.module.summa.worldgen.WorldGenNewTreeBase;
import java.util.LinkedList;
import java.util.Random;
import net.minecraft.block.Block;
import net.minecraft.init.Blocks;
import net.minecraft.item.ItemStack;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;

public class WorldGenSakuraBlossomTree
extends WorldGenNewTreeBase {
    private static long lastSeed = 1234L;
    private static final int BASE_HEIGHT = 8;
    private static final int BASE_HEIGHT_VARIANCE = 4;
    private static final double TRUNK_HEIGHT_PERCENT = 0.3;
    private static final int BRANCHES_BASE_NUMBER = 2;
    private static final int BRANCHES_EXTRA = 4;
    private static final int CANOPY_WIDTH = 8;
    private static final int CANOPY_WIDTH_VARIANCE = 4;
    static int last = 0;

    public WorldGenSakuraBlossomTree(boolean par1) {
        super(par1);
    }

    public boolean func_76484_a(World world, Random rand, int x, int y, int z) {
        lastSeed = rand.nextLong();
        if (!this.checkTree(world, new Random(lastSeed), x, y, z)) {
            return false;
        }
        return this.generateTree(world, new Random(lastSeed), x, y, z);
    }

    public boolean generate(World world, long seed, int x, int y, int z) {
        lastSeed = seed;
        if (!this.checkTree(world, new Random(lastSeed), x, y, z)) {
            return false;
        }
        return this.generateTree(world, new Random(seed), x, y, z);
    }

    private boolean checkTree(World world, Random rand, int x, int y, int z) {
        int height = rand.nextInt(4) + 8;
        double radius = (double)(8 + rand.nextInt(4)) / 2.0;
        int chunkCheck = (int)Math.ceil(radius) + 5;
        if (!TreeSoilRegistry.isValidSoil(world.func_147439_a(x, y - 1, z))) {
            return false;
        }
        if (y >= 256 - height - 4) {
            return false;
        }
        if (y < 1 || y + height + 4 > 256) {
            return false;
        }
        if (!world.func_72904_c(x - chunkCheck, y - chunkCheck, z - chunkCheck, x + chunkCheck, y + chunkCheck, z + chunkCheck)) {
            return false;
        }
        if (!this.check1x1Trunk(x, y, z, (int)((double)height * 0.3), TreeBlock.TRUNK.get(), world)) {
            return false;
        }
        return this.checkBranches(world, rand, x, y + (int)((double)height * 0.3), z, height - (int)((double)height * 0.3) - 2, radius);
    }

    private boolean generateTree(World world, Random rand, int x, int y, int z) {
        int height = rand.nextInt(4) + 8;
        double radius = (double)(8 + rand.nextInt(4)) / 2.0;
        int chunkCheck = (int)Math.ceil(radius) + 1;
        if (!TreeSoilRegistry.isValidSoil(world.func_147439_a(x, y - 1, z))) {
            return false;
        }
        if (y >= 256 - height - 4) {
            return false;
        }
        if (y < 1 || y + height + 4 > 256) {
            return false;
        }
        if (!world.func_72904_c(x - chunkCheck, y - chunkCheck, z - chunkCheck, x + chunkCheck, y + chunkCheck, z + chunkCheck)) {
            return false;
        }
        if (this.place1x1Trunk(x, y, z, (int)((double)height * 0.3), TreeBlock.TRUNK.get(), world)) {
            this.generateBranches(world, rand, x, y + (int)((double)height * 0.3), z, height - (int)((double)height * 0.3) - 2, radius);
            return true;
        }
        return false;
    }

    public boolean checkBranches(World world, Random rand, int x, int y, int z, int height, double radius) {
        int branchCount = 2 + rand.nextInt(4);
        double curAngle = 0.0;
        double[] average = new double[]{0.0, 0.0, 0.0};
        int[] start = new int[]{x, y, z};
        LinkedList<int[]> branches = new LinkedList<int[]>();
        for (int i = 0; i < branchCount; ++i) {
            double angle = (double)(rand.nextInt(50) + 35) / 90.0;
            double thisHeight = (double)(height + 1) * Math.sin(angle) / 1.3;
            double thisRadius = radius * Math.cos(angle);
            int x1 = (int)(thisRadius * Math.cos(curAngle += (double)(rand.nextInt(360 / branchCount) + 360 / branchCount) / 90.0));
            int z1 = (int)(thisRadius * Math.sin(curAngle));
            average[0] = average[0] + (double)x1;
            average[1] = average[1] + thisHeight;
            average[2] = average[2] + (double)z1;
            int[] node = new int[]{x1 + x, (int)thisHeight + y, z1 + z};
            branches.add(node);
            if (this.checkBlockLine(start, node, TreeBlock.TRUNK.get(), world)) continue;
            return false;
        }
        for (int[] cluster : branches) {
            if (this.checkLeafCluster(world, cluster[0], cluster[1], cluster[2], 2, 2)) continue;
            return false;
        }
        average[0] = average[0] / (double)branchCount;
        average[1] = (double)branchCount / average[1] + 2.3;
        average[2] = average[2] / (double)branchCount;
        return this.checkCanopy(world, average[0] + (double)x, y, average[2] + (double)z, radius, height);
    }

    public void generateBranches(World world, Random rand, int x, int y, int z, int height, double radius) {
        int branchCount = 2 + rand.nextInt(4);
        double curAngle = 0.0;
        double[] average = new double[]{0.0, 0.0, 0.0};
        int[] start = new int[]{x, y, z};
        LinkedList<int[]> branches = new LinkedList<int[]>();
        for (int i = 0; i < branchCount; ++i) {
            double angle = (double)(rand.nextInt(50) + 35) / 90.0;
            double thisHeight = (double)(height + 1) * Math.sin(angle) / 1.3;
            double thisRadius = radius * Math.cos(angle);
            int x1 = (int)(thisRadius * Math.cos(curAngle += (double)(rand.nextInt(360 / branchCount) + 360 / branchCount) / 90.0));
            int z1 = (int)(thisRadius * Math.sin(curAngle));
            average[0] = average[0] + (double)x1;
            average[1] = average[1] + thisHeight;
            average[2] = average[2] + (double)z1;
            int[] node = new int[]{x1 + x, (int)thisHeight + y, z1 + z};
            branches.add(node);
            this.placeThinBlockLine(start, node, TreeBlock.TRUNK.get(), world);
        }
        for (int[] cluster : branches) {
            this.generateLeafCluster(world, cluster[0], cluster[1], cluster[2], 2, 2, TreeBlock.LEAVES.get());
        }
        average[0] = average[0] / (double)branchCount;
        average[1] = (double)branchCount / average[1] + 2.3;
        average[2] = average[2] / (double)branchCount;
        this.generateCanopy(world, rand, average[0] + (double)x, y, average[2] + (double)z, radius, height, TreeBlock.LEAVES.get());
        this.generateVerticalCone(world, x, y, z, height - 1, 0.75, 2.0, TreeBlock.LEAVES.get());
    }

    public boolean checkCanopy(World world, double x, double y, double z, double radius, int height) {
        int layers = height + 2;
        int y1 = (int)y;
        int layer = 0;
        while (layer < layers) {
            if (!this.checkCanopyLayer(world, x, y1, z, radius * Math.cos((double)layer / ((double)height / 1.3)))) {
                return false;
            }
            ++layer;
            ++y1;
        }
        return true;
    }

    public void generateCanopy(World world, Random rand, double x, double y, double z, double radius, int height, ItemStack leaves) {
        int layers = height + 2;
        int y1 = (int)y;
        int layer = 0;
        while (layer < layers) {
            if (layer < 2) {
                this.generateCanopyLayer(world, rand, x, y1, z, radius * Math.cos((double)layer / ((double)height / 1.3)), 2 + layer * 5, leaves);
            } else {
                this.generateCanopyLayer(world, rand, x, y1, z, radius * Math.cos((double)layer / ((double)height / 1.3)), 1000, leaves);
            }
            ++layer;
            ++y1;
        }
    }

    public void generateVerticalCone(World world, int x, int y, int z, int height, double r1, double r2, ItemStack leaves) {
        double ratio = (r2 - r1) / (double)(height - 1);
        for (int offset = 0; offset < height; ++offset) {
            this.placeLeavesCircle(x, y + offset, z, ratio * (double)offset + r1, leaves, world);
        }
    }

    public boolean checkCanopyLayer(World world, double x, double y, double z, double radius) {
        double minDist = radius - 3.0 > 0.0 ? (radius - 3.0) * (radius - 3.0) : -1.0;
        double maxDist = radius * radius;
        int z1 = (int)(-radius);
        while ((double)z1 < radius + 1.0) {
            int x1 = (int)(-radius);
            while ((double)x1 < radius + 1.0) {
                Block block;
                try {
                    block = world.func_147439_a((int)((double)x1 + x), (int)y, (int)((double)z1 + z));
                }
                catch (Exception e) {
                    LogHelper.info("Sakura tree tried to generate in an ungenerated chunk.", new Object[0]);
                    return false;
                }
                if ((double)(x1 * x1 + z1 * z1) <= maxDist && (double)(x1 * x1 + z1 * z1) >= minDist && block != null && !block.isReplaceable((IBlockAccess)world, (int)((double)x1 + x), (int)y, (int)((double)z1 + z))) {
                    return false;
                }
                ++x1;
            }
            ++z1;
        }
        return true;
    }

    public void generateCanopyLayer(World world, Random rand, double x, double y, double z, double radius, int skipChance, ItemStack leaves) {
        double minDist = radius - 3.0 > 0.0 ? (radius - 3.0) * (radius - 3.0) : -1.0;
        double maxDist = radius * radius;
        int z1 = (int)(-radius);
        while ((double)z1 < radius + 1.0) {
            int x1 = (int)(-radius);
            while ((double)x1 < radius + 1.0) {
                Block block = world.func_147439_a((int)((double)x1 + x), (int)y, (int)((double)z1 + z));
                if ((double)(x1 * x1 + z1 * z1) <= maxDist && (double)(x1 * x1 + z1 * z1) >= minDist && (block == null || block.canBeReplacedByLeaves((IBlockAccess)world, (int)((double)x1 + x), (int)y, (int)((double)z1 + z))) && rand.nextInt(skipChance) != 0) {
                    this.setLeafBlock(world, (int)((double)x1 + x), (int)y, (int)((double)z1 + z), leaves);
                }
                ++x1;
            }
            ++z1;
        }
    }

    public static long getLastSeed() {
        return lastSeed;
    }

    private static enum TreeBlock {
        LEAVES(new ItemStack((Block)Blocks.field_150362_t, 1, 1)),
        TRUNK(new ItemStack(Blocks.field_150364_r, 1, 1));

        private ItemStack stack;
        private static boolean loadedCustomBlocks;

        private static void loadCustomBlocks() {
            if (Element.LEAVES_SAKURA_BLOSSOM.isPresent()) {
                TreeBlock.LEAVES.stack = Element.LEAVES_SAKURA_BLOSSOM.get();
            }
            if (Element.LOG_SAKURA_BLOSSOM.isPresent()) {
                TreeBlock.TRUNK.stack = Element.LOG_SAKURA_BLOSSOM.get();
            }
            loadedCustomBlocks = true;
        }

        private TreeBlock(ItemStack stack) {
            this.stack = stack;
        }

        public ItemStack get() {
            if (!loadedCustomBlocks) {
                TreeBlock.loadCustomBlocks();
            }
            return this.stack;
        }

        static {
            loadedCustomBlocks = false;
        }
    }
}

