/*
 * Decompiled with CFR 0.152.
 */
package extrabiomes.module.summa.worldgen;

import cpw.mods.fml.common.IWorldGenerator;
import extrabiomes.lib.BiomeSettings;
import extrabiomes.module.summa.worldgen.WorldGenOasis;
import java.util.Random;
import net.minecraft.block.Block;
import net.minecraft.init.Blocks;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;
import net.minecraft.world.biome.BiomeGenBase;
import net.minecraft.world.chunk.IChunkProvider;
import net.minecraft.world.gen.feature.WorldGenMinable;
import net.minecraft.world.gen.feature.WorldGenerator;

public class MountainRidgeGenerator
implements IWorldGenerator {
    private static final WorldGenerator oasisGen = new WorldGenOasis();
    private static final WorldGenerator silverfishGen = new WorldGenMinable(Blocks.field_150418_aU, 8);

    public void generate(Random random, int chunkX, int chunkZ, World world, IChunkProvider chunkGenerator, IChunkProvider chunkProvider) {
        BiomeGenBase biome = world.func_72807_a(chunkX <<= 4, chunkZ <<= 4);
        if (BiomeSettings.MOUNTAINRIDGE.getBiome().isPresent() && biome == BiomeSettings.MOUNTAINRIDGE.getBiome().get()) {
            this.trimPondsInGrass(random, chunkX, chunkZ, world);
            this.generateEmeraldOre(random, chunkX, chunkZ, world);
        }
    }

    private void generateEmeraldOre(Random rand, int x, int z, World world) {
        int z1;
        int y1;
        int x1;
        int i;
        int veins = 3 + rand.nextInt(6);
        for (i = 0; i < veins; ++i) {
            x1 = x + rand.nextInt(16);
            Block block = world.func_147439_a(x1, y1 = rand.nextInt(28) + 4, z1 = z + rand.nextInt(16));
            if (block.isAir((IBlockAccess)world, x1, y1, z1) || !block.isReplaceableOreGen(world, x1, y1, z1, Blocks.field_150348_b)) continue;
            world.func_147449_b(x1, y1, z1, Blocks.field_150412_bA);
        }
        for (i = 0; i < 7; ++i) {
            x1 = x + rand.nextInt(16);
            y1 = rand.nextInt(64);
            z1 = z + rand.nextInt(16);
            silverfishGen.func_76484_a(world, rand, x1, y1, z1);
        }
    }

    private void trimPondsInGrass(Random rand, int x, int z, World world) {
        for (int i = 0; i < 1000; ++i) {
            int x1 = x + rand.nextInt(16) + 8;
            int z1 = z + rand.nextInt(16) + 8;
            int y1 = world.func_72825_h(x1, z1);
            oasisGen.func_76484_a(world, rand, x1, y1, z1);
        }
    }
}

