/*
 * Decompiled with CFR 0.152.
 */
package extrabiomes.module.amica.newdawn;

import extrabiomes.lib.BiomeSettings;
import extrabiomes.module.amica.newdawn.NewDawnPluginImpl;
import extrabiomes.module.amica.newdawn.NewDawnSettings;
import two.newdawn.API.ChunkInformation;
import two.newdawn.API.NewDawnBiome;
import two.newdawn.API.NewDawnBiomeSelector;
import two.newdawn.API.noise.NoiseStretch;
import two.newdawn.API.noise.SimplexNoise;

public class EBXLNormalSelector
extends NewDawnBiomeSelector {
    protected static final NewDawnBiome biomeAutumnWoods = NewDawnPluginImpl.getBiomeIfEnabled(BiomeSettings.AUTUMNWOODS);
    protected static final NewDawnBiome biomeBirchForest = NewDawnPluginImpl.getBiomeIfEnabled(BiomeSettings.BIRCHFOREST);
    protected static final NewDawnBiome biomeForestedHills = NewDawnPluginImpl.getBiomeIfEnabled(BiomeSettings.FORESTEDHILLS);
    protected static final NewDawnBiome biomeMeadow = NewDawnPluginImpl.getBiomeIfEnabled(BiomeSettings.MEADOW);
    protected static final NewDawnBiome biomeMountainTaiga = NewDawnPluginImpl.getBiomeIfEnabled(BiomeSettings.MOUNTAINTAIGA);
    protected static final NewDawnBiome biomePineForest = NewDawnPluginImpl.getBiomeIfEnabled(BiomeSettings.PINEFOREST);
    protected static final NewDawnBiome biomeShrubland = NewDawnPluginImpl.getBiomeIfEnabled(BiomeSettings.SHRUBLAND);
    protected static final NewDawnBiome biomeSnowForest = NewDawnPluginImpl.getBiomeIfEnabled(BiomeSettings.SNOWYFOREST);
    protected static final NewDawnBiome biomeWoodlands = NewDawnPluginImpl.getBiomeIfEnabled(BiomeSettings.WOODLANDS);
    protected NoiseStretch stretchAutumn;
    protected NoiseStretch stretchBirch;
    protected NoiseStretch stretchForest;
    protected NoiseStretch stretchSnowy;
    protected NoiseStretch stretchMeadow;

    public EBXLNormalSelector(SimplexNoise worldNoise, int priority) {
        super(worldNoise, priority);
        this.stretchForest = NewDawnPluginImpl.getFuzzyStretch(NewDawnSettings.FOREST.getStretchSize(), worldNoise);
        this.stretchAutumn = NewDawnPluginImpl.getFuzzyStretch(NewDawnSettings.AUTUMN.getStretchSize(), worldNoise);
        this.stretchSnowy = NewDawnPluginImpl.getFuzzyStretch(NewDawnSettings.SNOWY.getStretchSize(), worldNoise);
        this.stretchBirch = NewDawnPluginImpl.getFuzzyStretch(NewDawnSettings.BIRCH.getStretchSize(), worldNoise);
        this.stretchMeadow = NewDawnPluginImpl.getFuzzyStretch(NewDawnSettings.MEADOW.getStretchSize(), worldNoise);
    }

    public NewDawnBiome selectBiome(int blockX, int blockZ, ChunkInformation chunkInfo) {
        if (chunkInfo.isBelowGroundLevel(blockX, blockZ) || !chunkInfo.isHumidityMedium(blockX, blockZ)) {
            return null;
        }
        boolean isForest = chunkInfo.isWoodland(blockX, blockZ);
        boolean isCold = chunkInfo.isTemperatureFreezing(blockX, blockZ);
        boolean isCool = chunkInfo.isTemperatureFreezing(blockX, blockZ, -0.25f);
        if (isForest) {
            if (isCold) {
                double snowNoise = this.stretchSnowy.getNoise((double)blockX, (double)blockZ);
                if (snowNoise > 0.0) {
                    if (chunkInfo.isMountain(blockX, blockZ)) {
                        return biomeMountainTaiga;
                    }
                    if (snowNoise > 0.5) {
                        return biomeSnowForest;
                    }
                    return biomePineForest;
                }
            } else if (isCool) {
                if (this.stretchAutumn.getNoise((double)blockX, (double)blockZ) > 0.0) {
                    return biomeAutumnWoods;
                }
            } else {
                if (chunkInfo.getAverageHeight() < 100 && this.stretchBirch.getNoise((double)blockX, (double)blockZ) > 0.0) {
                    return biomeBirchForest;
                }
                if (this.stretchForest.getNoise((double)blockX, (double)blockZ) > 0.0) {
                    if (chunkInfo.getAverageHeight() > 100) {
                        return biomeForestedHills;
                    }
                    return biomeWoodlands;
                }
            }
        } else {
            double noise = this.stretchMeadow.getNoise((double)blockX, (double)blockZ);
            if (noise > 0.6) {
                return biomeShrubland;
            }
            if (noise > 0.0) {
                return biomeMeadow;
            }
        }
        return null;
    }
}

