/*
 * Decompiled with CFR 0.152.
 */
package extrabiomes.lib;

import extrabiomes.utility.EnhancedConfiguration;
import java.util.Locale;
import net.minecraft.item.Item;
import net.minecraftforge.common.config.Property;

public enum BlockSettings {
    REDROCK,
    CRACKEDSAND,
    QUICKSAND,
    FLOWER,
    CATTAIL,
    GRASS,
    LEAFPILE,
    FLOWER2,
    FLOWER3,
    GLORIOSA,
    WATERPLANT,
    SPANISH_MOSS(false),
    SAPLING,
    NEWSAPLING,
    STRAWBERRY,
    AUTUMNLEAVES,
    GREENLEAVES,
    NEWLEAVES,
    MORELEAVES,
    QUARTERLOG0(false),
    QUARTERLOG1(false),
    QUARTERLOG2(false),
    QUARTERLOG3(false),
    CUSTOMLOG,
    NEWLOG,
    KNEELOG,
    RAINBOWKNEELOG,
    RAINBOWQUARTERLOG,
    NEWQUARTERLOG,
    FIRQUARTERLOG,
    REDWOODQUARTERLOG,
    OAKQUARTERLOG,
    MINILOG,
    PLANKS,
    WOODSLAB,
    DOUBLEWOODSLAB,
    NEWWOODSLAB,
    NEWDOUBLEWOODSLAB,
    REDROCKSLAB,
    REDCOBBLESTAIRS,
    REDROCKBRICKSTAIRS,
    REDWOODSTAIRS,
    FIRSTAIRS,
    ACACIASTAIRS,
    DOUBLEREDROCKSLAB,
    CYPRESSSTAIRS,
    JAPANESEMAPLESTAIRS,
    RAINBOWEUCALYPTUSSTAIRS,
    AUTUMNSTAIRS,
    BALDCYPRESSSTAIRS,
    SAKURABLOSSOMSTAIRS,
    WALL,
    REDWOODDOOR,
    FIRDOOR,
    ACACIADOOR,
    CYPRESSDOOR,
    JAPANESEMAPLEDOOR,
    RAINBOWEUCALYPTUSDOOR,
    AUTUMNDOOR,
    BALDCYPRESSDOOR,
    SAKURABLOSSOMDOOR,
    SAKURABLOSSOMGATE;

    private boolean enabled;
    private Item item;
    private static boolean clearedQuarterLogs;
    private static boolean clearedWoodSlabs;

    private BlockSettings() {
        this.enabled = true;
    }

    private BlockSettings(boolean enabled) {
        this.enabled = enabled;
    }

    public boolean getEnabled() {
        return this.enabled;
    }

    public Item getItem() {
        return this.item;
    }

    public void setItem(Item item) {
        this.item = item;
    }

    private String enabledKey() {
        return this.toString() + ".enabled";
    }

    private boolean isQuarterLog() {
        return this == QUARTERLOG0 || this == QUARTERLOG1 || this == QUARTERLOG2 || this == QUARTERLOG3;
    }

    public void load(EnhancedConfiguration configuration, boolean update) {
        switch (this) {
            case CRACKEDSAND: 
            case QUICKSAND: {
                Property property = configuration.get("block", this.enabledKey(), true);
                this.enabled = property.getBoolean();
                break;
            }
        }
    }

    public String toString() {
        return super.toString().toLowerCase(Locale.ENGLISH);
    }

    static {
        clearedQuarterLogs = false;
        clearedWoodSlabs = false;
    }
}

