/*
 * Decompiled with CFR 0.152.
 */
package extrabiomes.items;

import cpw.mods.fml.relauncher.Side;
import cpw.mods.fml.relauncher.SideOnly;
import extrabiomes.Extrabiomes;
import java.util.List;
import net.minecraft.client.renderer.texture.IIconRegister;
import net.minecraft.creativetab.CreativeTabs;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.Item;
import net.minecraft.item.ItemFood;
import net.minecraft.item.ItemStack;
import net.minecraft.util.IIcon;
import net.minecraft.util.MathHelper;
import net.minecraft.world.World;

public class ItemCustomFood
extends ItemFood {
    public static final int DEFAULT_HUNGER = 2;
    public static final float DEFAULT_SATURATION = 0.6f;
    private final int NUM_FOODS;

    public ItemCustomFood() {
        super(2, 0.6f, false);
        this.func_77656_e(0);
        this.func_77627_a(true);
        this.func_77655_b("extrabiomes.food");
        this.func_77637_a(Extrabiomes.tabsEBXL);
        this.NUM_FOODS = FoodType.values().length;
    }

    @SideOnly(value=Side.CLIENT)
    public void func_94581_a(IIconRegister iconRegister) {
        for (FoodType type : FoodType.values()) {
            String IIconPath = Extrabiomes.TEXTURE_PATH + type.texture;
            type.IIcon = iconRegister.func_94245_a(IIconPath);
        }
    }

    public int func_77647_b(int meta) {
        return MathHelper.func_76125_a((int)meta, (int)0, (int)this.NUM_FOODS);
    }

    public IIcon func_77617_a(int meta) {
        return this.getFoodType((int)meta).IIcon;
    }

    public FoodType getFoodType(int meta) {
        return FoodType.values()[this.func_77647_b(meta)];
    }

    public String func_77667_c(ItemStack itemStack) {
        FoodType type = this.getFoodType(itemStack.func_77960_j());
        return super.func_77658_a() + "." + type.name().toLowerCase();
    }

    @SideOnly(value=Side.CLIENT)
    public void func_150895_a(Item item, CreativeTabs tabs, List list) {
        for (FoodType type : FoodType.values()) {
            list.add(new ItemStack(item, 1, type.meta));
        }
    }

    public int func_150905_g(ItemStack itemStack) {
        FoodType type = this.getFoodType(itemStack.func_77960_j());
        return type.hunger;
    }

    public float func_150906_h(ItemStack itemStack) {
        FoodType type = this.getFoodType(itemStack.func_77960_j());
        return type.saturation;
    }

    public ItemStack func_77659_a(ItemStack itemStack, World world, EntityPlayer player) {
        FoodType type = this.getFoodType(itemStack.func_77960_j());
        if (player.func_71043_e(type.alwaysEdible)) {
            player.func_71008_a(itemStack, this.func_77626_a(itemStack));
        }
        return itemStack;
    }

    public static enum FoodType {
        CHOCOLATE(0, 3, Float.valueOf(0.5f), "chocolate"),
        CHOCOLATE_STRAWBERRY(1, 7, Float.valueOf(1.0f), "ch_strawberry");

        public final int meta;
        public final int hunger;
        public final float saturation;
        public IIcon IIcon;
        public final String texture;
        public boolean alwaysEdible = false;

        private FoodType(int meta, Integer hunger, Float saturation, String texture) {
            this.meta = meta;
            this.hunger = hunger == null ? 2 : hunger;
            this.saturation = saturation == null ? 0.6f : saturation.floatValue();
            this.texture = texture;
        }

        private FoodType(int meta, Integer hunger, Float saturation, String texture, boolean alwaysEdible) {
            this(meta, hunger, saturation, texture);
            this.alwaysEdible = alwaysEdible;
        }
    }
}

