/*
 * Decompiled with CFR 0.152.
 */
package extrabiomes.items;

import cpw.mods.fml.relauncher.Side;
import cpw.mods.fml.relauncher.SideOnly;
import extrabiomes.Extrabiomes;
import java.util.List;
import net.minecraft.client.renderer.texture.IIconRegister;
import net.minecraft.creativetab.CreativeTabs;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.Item;
import net.minecraft.item.ItemFood;
import net.minecraft.item.ItemStack;
import net.minecraft.util.IIcon;
import net.minecraft.util.MathHelper;
import net.minecraft.world.World;

public class ItemCustomCrop
extends ItemFood {
    public static final int DEFAULT_HUNGER = 2;
    public static final float DEFAULT_SATURATION = 0.6f;
    private final int NUM_CROPS;

    public ItemCustomCrop() {
        super(2, 0.6f, false);
        this.func_77656_e(0);
        this.func_77627_a(true);
        this.func_77655_b("extrabiomes.crop");
        this.func_77637_a(Extrabiomes.tabsEBXL);
        this.NUM_CROPS = CropType.values().length;
    }

    @SideOnly(value=Side.CLIENT)
    public void func_94581_a(IIconRegister iconRegister) {
        for (CropType type : CropType.values()) {
            String IIconPath = Extrabiomes.TEXTURE_PATH + type.name().toLowerCase();
            type.IIcon = iconRegister.func_94245_a(IIconPath);
        }
    }

    public int func_77647_b(int meta) {
        return MathHelper.func_76125_a((int)meta, (int)0, (int)this.NUM_CROPS);
    }

    public IIcon func_77617_a(int meta) {
        return this.getCropType((int)meta).IIcon;
    }

    public CropType getCropType(int meta) {
        return CropType.values()[this.func_77647_b(meta)];
    }

    public String func_77667_c(ItemStack itemStack) {
        CropType crop = this.getCropType(itemStack.func_77960_j());
        return super.func_77658_a() + "." + crop.name().toLowerCase();
    }

    @SideOnly(value=Side.CLIENT)
    public void func_150895_a(Item item, CreativeTabs tabs, List list) {
        for (CropType type : CropType.values()) {
            list.add(new ItemStack(item, 1, type.meta));
        }
    }

    public int func_150905_g(ItemStack itemStack) {
        CropType type = this.getCropType(itemStack.func_77960_j());
        return type.hunger;
    }

    public float func_150906_h(ItemStack itemStack) {
        CropType type = this.getCropType(itemStack.func_77960_j());
        return type.saturation;
    }

    public ItemStack func_77659_a(ItemStack itemStack, World world, EntityPlayer player) {
        CropType crop = this.getCropType(itemStack.func_77960_j());
        if (crop.edible != CropType.Edible.NO && player.func_71043_e(crop.edible == CropType.Edible.ALWAYS)) {
            player.func_71008_a(itemStack, this.func_77626_a(itemStack));
        }
        return itemStack;
    }

    public static enum CropType {
        STRAWBERRY(0, null, null);

        public final int meta;
        public final int hunger;
        public final float saturation;
        public IIcon IIcon;
        public Edible edible = Edible.YES;

        private CropType(int meta, Integer hunger, Float saturation) {
            this.meta = meta;
            this.hunger = hunger == null ? 2 : hunger;
            this.saturation = saturation == null ? 0.6f : saturation.floatValue();
        }

        private CropType(int meta, Integer hunger, Float saturation, Edible edible) {
            this(meta, hunger, saturation);
            this.edible = edible;
        }

        public static enum Edible {
            ALWAYS,
            YES,
            NO;

        }
    }
}

