/*
 * Decompiled with CFR 0.152.
 */
package extrabiomes.helpers;

import com.google.common.base.Optional;
import org.apache.logging.log4j.Level;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public enum LogHelper {
    INSTANCE;

    private Optional<Logger> logger = Optional.absent();

    public static void fine(String format, Object ... args) {
        INSTANCE.log(Level.DEBUG, format, args);
    }

    public static void finer(String format, Object ... args) {
        INSTANCE.log(Level.DEBUG, format, args);
    }

    public static void finest(String format, Object ... data) {
        INSTANCE.log(Level.DEBUG, format, data);
    }

    public static void info(String format, Object ... args) {
        INSTANCE.log(Level.INFO, format, args);
    }

    public static void log(Level level, Throwable exception, String format, Object ... args) {
        INSTANCE.getLogger().log(level, String.format(format, args), exception);
    }

    public static void severe(String format, Object ... args) {
        INSTANCE.log(Level.FATAL, format, args);
    }

    public static void warning(String format, Object ... args) {
        INSTANCE.log(Level.WARN, format, args);
    }

    private Logger getLogger() {
        if (!this.logger.isPresent()) {
            this.init();
        }
        return (Logger)this.logger.get();
    }

    private void init() {
        if (this.logger.isPresent()) {
            return;
        }
        this.logger = Optional.of((Object)LogManager.getLogger((String)"ExtrabiomesXL"));
    }

    private void log(Level level, String format, Object ... data) {
        this.getLogger().log(level, String.format(format, data));
    }
}

