/*
 * Decompiled with CFR 0.152.
 */
package extrabiomes.handlers;

import com.google.common.base.Optional;
import cpw.mods.fml.common.registry.GameRegistry;
import extrabiomes.Extrabiomes;
import extrabiomes.api.Stuff;
import extrabiomes.blocks.BlockCropBasic;
import extrabiomes.blocks.BlockCropRegrow;
import extrabiomes.handlers.CropBonemealEventHandler;
import extrabiomes.helpers.LogHelper;
import extrabiomes.items.ItemCustomCrop;
import extrabiomes.items.ItemCustomSeed;
import extrabiomes.lib.BlockSettings;
import extrabiomes.lib.Element;
import extrabiomes.lib.ItemSettings;
import extrabiomes.module.summa.worldgen.FlowerGenerator;
import extrabiomes.proxy.CommonProxy;
import net.minecraft.block.Block;
import net.minecraft.init.Blocks;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraftforge.oredict.OreDictionary;
import org.apache.commons.lang3.StringUtils;

public class CropHandler {
    public static void createCrops() {
        if (ItemSettings.CROP.getEnabled()) {
            CropHandler.createCropItems();
            CropHandler.createBasicCrops();
            CropHandler.createRegrowCrops();
            if (ItemSettings.SEED.getEnabled()) {
                CropHandler.createSeedItems();
            }
            CropHandler.registerWildCrops();
        }
    }

    private static void registerWildCrops() {
        Element[] crops = new Element[]{Element.PLANT_STRAWBERRY};
        FlowerGenerator generator = FlowerGenerator.getInstance();
        for (Element crop : crops) {
            generator.registerCrop(crop);
        }
    }

    private static void createCropItems() {
        ItemCustomCrop item = new ItemCustomCrop();
        Stuff.crop = Optional.of((Object)((Object)item));
        GameRegistry.registerItem((Item)item, (String)"extrabiomes.crop", (String)"ExtrabiomesXL");
        for (ItemCustomCrop.CropType type : ItemCustomCrop.CropType.values()) {
            Element element;
            try {
                element = Element.valueOf("CROP_" + type.name());
            }
            catch (Exception e) {
                LogHelper.warning("Missing element for crop " + (Object)((Object)type), new Object[0]);
                continue;
            }
            ItemStack crop_item = new ItemStack((Item)item, 1, type.meta);
            element.set(crop_item);
            OreDictionary.registerOre((String)("crop" + StringUtils.capitalize((String)type.name().toLowerCase())), (ItemStack)crop_item);
        }
    }

    private static void createSeedItems() {
        ItemCustomSeed item = new ItemCustomSeed();
        Stuff.seed = Optional.of((Object)((Object)item));
        GameRegistry.registerItem((Item)item, (String)"extrabiomes.seed", (String)"ExtrabiomesXL");
        for (ItemCustomSeed.SeedType type : ItemCustomSeed.SeedType.values()) {
            Element plant_element;
            Element seed_element;
            try {
                seed_element = Element.valueOf("SEED_" + type.name());
                plant_element = Element.valueOf("PLANT_" + type.name());
            }
            catch (Exception e) {
                LogHelper.warning("Missing element for seed " + (Object)((Object)type), new Object[0]);
                continue;
            }
            ItemStack seed_item = new ItemStack((Item)item, 1, type.meta);
            seed_element.set(seed_item);
            if (plant_element != null && plant_element.isPresent()) {
                ItemStack plant_stack = plant_element.get();
                Block block = Block.func_149634_a((Item)plant_stack.func_77973_b());
                if (block == Blocks.field_150350_a) {
                    LogHelper.severe("Unable to get plant back from element for " + (Object)((Object)type), new Object[0]);
                    continue;
                }
                if (block instanceof BlockCropBasic) {
                    type.cropType = (BlockCropBasic)block;
                    ((BlockCropBasic)block).setSeedItem(seed_item);
                    continue;
                }
                LogHelper.severe("Unable to set seed item for " + (Object)((Object)type), new Object[0]);
                continue;
            }
            LogHelper.severe("Missing plant element for " + (Object)((Object)type), new Object[0]);
        }
    }

    private static void createBasicCrops() {
        for (BlockCropBasic.CropType cropType : BlockCropBasic.CropType.values()) {
        }
    }

    private static void createRegrowCrops() {
        CommonProxy proxy = Extrabiomes.proxy;
        for (BlockCropRegrow.CropType type : BlockCropRegrow.CropType.values()) {
            Element crop_element;
            Element plant_element;
            String name = type.name();
            try {
                BlockSettings plant_settings = BlockSettings.valueOf(name);
                if (!plant_settings.getEnabled()) continue;
                plant_element = Element.valueOf("PLANT_" + name);
                crop_element = Element.valueOf("CROP_" + name);
            }
            catch (Exception e) {
                LogHelper.warning("Missing settings or elements for plant " + type, new Object[0]);
                continue;
            }
            BlockCropRegrow block = new BlockCropRegrow(type);
            block.setCropItem(crop_element.get().func_77973_b());
            block.func_149663_c("extrabiomes.crop." + name.toLowerCase());
            proxy.registerEventHandler(new CropBonemealEventHandler(block));
            proxy.registerBlock((Block)block, block.func_149739_a());
            ItemStack plant_stack = new ItemStack((Block)block);
            plant_element.set(plant_stack);
        }
    }
}

