/*
 * Decompiled with CFR 0.152.
 */
package extrabiomes.handlers;

import com.google.common.base.Optional;
import extrabiomes.helpers.LogHelper;
import extrabiomes.lib.BiomeSettings;
import extrabiomes.lib.BlockSettings;
import extrabiomes.lib.DecorationSettings;
import extrabiomes.lib.GeneralSettings;
import extrabiomes.lib.ItemSettings;
import extrabiomes.lib.ModuleControlSettings;
import extrabiomes.lib.SaplingSettings;
import extrabiomes.module.amica.newdawn.NewDawnSettings;
import extrabiomes.utility.EnhancedConfiguration;
import java.io.File;
import net.minecraftforge.common.config.Property;

public abstract class ConfigurationHandler {
    public static void init(File configFile) {
        ConfigurationHandler.init(configFile, false);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static EnhancedConfiguration init(File configFile, boolean upgradeOverride) {
        block13: {
            if (upgradeOverride) {
                LogHelper.info("Overriding upgrade preference", new Object[0]);
            }
            Optional optionalConfig = Optional.absent();
            try {
                optionalConfig = Optional.of((Object)((Object)new EnhancedConfiguration(configFile)));
                EnhancedConfiguration configuration = (EnhancedConfiguration)((Object)optionalConfig.get());
                Property configVersion = configuration.hasKey("version", "configFileVersoin") ? configuration.get("version", "configFileVersoin", "") : configuration.get("version", "configFileVersion", "");
                configVersion.comment = "To help ebxl in updating the config file in the future.";
                boolean isNewVersion = !configVersion.getString().equals("3.16");
                configVersion.set("3.16");
                Property upgradeProp = configuration.get("version", "upgrade", upgradeOverride);
                upgradeProp.comment = "Should new (game changing) features be automatically enabled?";
                boolean autoUpgrade = upgradeProp.getBoolean(false);
                for (BiomeSettings biomeSettings : BiomeSettings.values()) {
                    biomeSettings.load(configuration);
                }
                for (Enum enum_ : DecorationSettings.values()) {
                    ((DecorationSettings)enum_).load(configuration);
                }
                for (Enum enum_ : BlockSettings.values()) {
                    ((BlockSettings)enum_).load(configuration, upgradeOverride);
                }
                for (Enum enum_ : ItemSettings.values()) {
                    ((ItemSettings)enum_).load(configuration, upgradeOverride);
                }
                configuration.addCustomCategoryComment("saplingreplanting", "Settings to configure the chance that saplings will replant themselves up despawning on valid soil.");
                for (Enum enum_ : SaplingSettings.values()) {
                    ((SaplingSettings)enum_).load(configuration);
                }
                for (Enum enum_ : ModuleControlSettings.values()) {
                    ((ModuleControlSettings)enum_).load(configuration);
                }
                configuration.addCustomCategoryComment("newdawn", "New Dawn biome size hints.");
                for (Enum enum_ : NewDawnSettings.values()) {
                    ((NewDawnSettings)enum_).load(configuration);
                }
                Property bigTreeSaplingDropRateProperty = configuration.get("general", "Relative sapling drops", GeneralSettings.bigTreeSaplingDropModifier);
                bigTreeSaplingDropRateProperty.comment = "Setting relative sapling drops to true will decrease the amount of saplings dropped by decaying fir and redwood leaf blocks to a more reasonable amount.";
                GeneralSettings.bigTreeSaplingDropModifier = bigTreeSaplingDropRateProperty.getBoolean(false);
                Property consoleCommandsDisabled = configuration.get("general", "DisableConsoleCommands", GeneralSettings.consoleCommandsDisabled);
                consoleCommandsDisabled.comment = "Set to false to enable console commands.";
                GeneralSettings.consoleCommandsDisabled = consoleCommandsDisabled.getBoolean(true);
                Property useLegacyRedwoods = configuration.get("general", "UseLegacyRedwoods", autoUpgrade ? true : GeneralSettings.useLegacyRedwoods);
                useLegacyRedwoods.comment = "Set to true to enable old redwood tree generation.";
                GeneralSettings.useLegacyRedwoods = useLegacyRedwoods.getBoolean(false);
                Property property = configuration.get("general", "UseMC18Doors", GeneralSettings.useMC18Doors);
                property.comment = "Allow EbXL doors to stack like in MC 1.8 and be crafted in stacks of 3.";
                GeneralSettings.useMC18Doors = property.getBoolean(true);
            }
            catch (Exception e) {
                LogHelper.severe("%s had had a problem loading its configuration", "ExtrabiomesXL");
            }
            finally {
                if (!optionalConfig.isPresent()) break block13;
                EnhancedConfiguration config = (EnhancedConfiguration)((Object)optionalConfig.get());
                config.save();
                return config;
            }
        }
        return null;
    }
}

