/*
 * Decompiled with CFR 0.152.
 */
package extrabiomes.blocks;

import cpw.mods.fml.common.eventhandler.SubscribeEvent;
import cpw.mods.fml.common.registry.LanguageRegistry;
import cpw.mods.fml.relauncher.Side;
import cpw.mods.fml.relauncher.SideOnly;
import extrabiomes.Extrabiomes;
import extrabiomes.helpers.ToolTipStringFormatter;
import extrabiomes.lib.Element;
import extrabiomes.lib.GeneralSettings;
import extrabiomes.lib.SaplingSettings;
import extrabiomes.module.summa.TreeSoilRegistry;
import extrabiomes.module.summa.worldgen.WorldGenAcacia;
import extrabiomes.module.summa.worldgen.WorldGenAutumnTree;
import extrabiomes.module.summa.worldgen.WorldGenBigAutumnTree;
import extrabiomes.module.summa.worldgen.WorldGenCypressTree;
import extrabiomes.module.summa.worldgen.WorldGenFirTree;
import extrabiomes.module.summa.worldgen.WorldGenFirTreeHuge;
import extrabiomes.module.summa.worldgen.WorldGenNewRedwood;
import extrabiomes.module.summa.worldgen.WorldGenRedwood;
import java.util.List;
import java.util.Random;
import net.minecraft.block.Block;
import net.minecraft.block.BlockFlower;
import net.minecraft.client.renderer.texture.IIconRegister;
import net.minecraft.creativetab.CreativeTabs;
import net.minecraft.entity.item.EntityItem;
import net.minecraft.init.Blocks;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.util.IIcon;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;
import net.minecraft.world.gen.feature.WorldGenAbstractTree;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.event.entity.EntityJoinWorldEvent;
import net.minecraftforge.event.entity.item.ItemExpireEvent;

public class BlockCustomSapling
extends BlockFlower {
    Block sapling;
    static int saplingLifespan = 5000;
    private IIcon[] textures = new IIcon[]{null, null, null, null, null, null, null, null};
    private static final int METADATA_BITMASK = 7;
    private static final int METADATA_MARKBIT = 8;
    private static Block forestrySoil;

    private static boolean isEnoughLightToGrow(World world, int x, int y, int z) {
        return world.func_72957_l(x, y, z) >= 9;
    }

    private static boolean isMarkedMetadata(int metadata) {
        return (metadata & 8) != 0;
    }

    private static int markedMetadata(int metadata) {
        return metadata | 8;
    }

    public static void setForestrySoil(Block soil) {
        forestrySoil = soil;
    }

    private static int unmarkedMetadata(int metadata) {
        return metadata & 7;
    }

    public BlockCustomSapling(int index) {
        super(0);
        float var3 = 0.4f;
        this.func_149676_a(0.099999994f, 0.0f, 0.099999994f, 0.9f, 0.8f, 0.9f);
        this.sapling = this;
        MinecraftForge.EVENT_BUS.register((Object)this);
    }

    @SideOnly(value=Side.CLIENT)
    public void func_149651_a(IIconRegister IIconRegistry) {
        this.textures[0] = IIconRegistry.func_94245_a(Extrabiomes.TEXTURE_PATH + "saplingbrownautumn");
        this.textures[1] = IIconRegistry.func_94245_a(Extrabiomes.TEXTURE_PATH + "saplingorangeautumn");
        this.textures[2] = IIconRegistry.func_94245_a(Extrabiomes.TEXTURE_PATH + "saplingredautumn");
        this.textures[3] = IIconRegistry.func_94245_a(Extrabiomes.TEXTURE_PATH + "saplingyellowautumn");
        this.textures[4] = IIconRegistry.func_94245_a(Extrabiomes.TEXTURE_PATH + "saplingfir");
        this.textures[5] = IIconRegistry.func_94245_a(Extrabiomes.TEXTURE_PATH + "saplingredwood");
        this.textures[6] = IIconRegistry.func_94245_a(Extrabiomes.TEXTURE_PATH + "saplingacacia");
        this.textures[7] = IIconRegistry.func_94245_a(Extrabiomes.TEXTURE_PATH + "saplingcypress");
    }

    private void attemptGrowTree(World world, int x, int y, int z, Random rand) {
        if (BlockCustomSapling.isEnoughLightToGrow(world, x, y + 1, z) && rand.nextInt(7) == 0) {
            int metadata = world.func_72805_g(x, y, z);
            if (!BlockCustomSapling.isMarkedMetadata(metadata)) {
                world.func_72921_c(x, y, z, BlockCustomSapling.markedMetadata(metadata), 3);
            } else {
                this.growTree(world, x, y, z, rand);
            }
        }
    }

    protected boolean func_149854_a(Block block) {
        return TreeSoilRegistry.isValidSoil(block);
    }

    public int func_149692_a(int metadata) {
        return BlockCustomSapling.unmarkedMetadata(metadata);
    }

    public IIcon func_149691_a(int side, int metadata) {
        metadata = BlockCustomSapling.unmarkedMetadata(metadata);
        return this.textures[metadata];
    }

    public void markOrGrowMarked(World world, int x, int y, int z, Random rand) {
        int marked = world.func_72805_g(x, y, z);
        if ((marked & 8) == 0) {
            world.func_72921_c(x, y, z, marked | 8, 4);
        } else {
            this.growTree(world, x, y, z, rand);
        }
    }

    @SideOnly(value=Side.CLIENT)
    public void func_149666_a(Item id, CreativeTabs tab, List itemList) {
        for (BlockType blockType : BlockType.values()) {
            itemList.add(new ItemStack((Block)this, 1, blockType.metadata()));
        }
    }

    public void growTree(World world, int x, int y, int z, Random rand) {
        boolean isForestryFarmed;
        int metadata = BlockCustomSapling.unmarkedMetadata(world.func_72805_g(x, y, z));
        WorldGenAbstractTree tree = null;
        int x1 = 0;
        int z1 = 0;
        boolean isHuge = false;
        int offset = 0;
        boolean bl = isForestryFarmed = world.func_147439_a(x, y - 1, z) == forestrySoil;
        if (metadata == BlockType.UMBER.metadata()) {
            if (rand.nextInt(3) != 0) {
                tree = new WorldGenBigAutumnTree(true, WorldGenAutumnTree.AutumnTreeType.BROWN);
                WorldGenBigAutumnTree.setTrunkBlock(Block.func_149634_a((Item)Element.LOG_AUTUMN.get().func_77973_b()), Element.LOG_AUTUMN.get().func_77960_j());
            } else {
                tree = new WorldGenAutumnTree(true, WorldGenAutumnTree.AutumnTreeType.BROWN);
                WorldGenAutumnTree.setTrunkBlock(Block.func_149634_a((Item)Element.LOG_AUTUMN.get().func_77973_b()), Element.LOG_AUTUMN.get().func_77960_j());
            }
        } else if (metadata == BlockType.GOLDENROD.metadata()) {
            if (rand.nextInt(3) != 0) {
                tree = new WorldGenBigAutumnTree(true, WorldGenAutumnTree.AutumnTreeType.ORANGE);
                WorldGenBigAutumnTree.setTrunkBlock(Block.func_149634_a((Item)Element.LOG_AUTUMN.get().func_77973_b()), Element.LOG_AUTUMN.get().func_77960_j());
            } else {
                tree = new WorldGenAutumnTree(true, WorldGenAutumnTree.AutumnTreeType.ORANGE);
                WorldGenAutumnTree.setTrunkBlock(Block.func_149634_a((Item)Element.LOG_AUTUMN.get().func_77973_b()), Element.LOG_AUTUMN.get().func_77960_j());
            }
        } else if (metadata == BlockType.VERMILLION.metadata()) {
            if (rand.nextInt(3) != 0) {
                tree = new WorldGenBigAutumnTree(true, WorldGenAutumnTree.AutumnTreeType.PURPLE);
                WorldGenBigAutumnTree.setTrunkBlock(Block.func_149634_a((Item)Element.LOG_AUTUMN.get().func_77973_b()), Element.LOG_AUTUMN.get().func_77960_j());
            } else {
                tree = new WorldGenAutumnTree(true, WorldGenAutumnTree.AutumnTreeType.PURPLE);
                WorldGenAutumnTree.setTrunkBlock(Block.func_149634_a((Item)Element.LOG_AUTUMN.get().func_77973_b()), Element.LOG_AUTUMN.get().func_77960_j());
            }
        } else if (metadata == BlockType.CITRINE.metadata()) {
            if (rand.nextInt(3) != 0) {
                tree = new WorldGenBigAutumnTree(true, WorldGenAutumnTree.AutumnTreeType.YELLOW);
                WorldGenBigAutumnTree.setTrunkBlock(Block.func_149634_a((Item)Element.LOG_AUTUMN.get().func_77973_b()), Element.LOG_AUTUMN.get().func_77960_j());
            } else {
                tree = new WorldGenAutumnTree(true, WorldGenAutumnTree.AutumnTreeType.YELLOW);
                WorldGenAutumnTree.setTrunkBlock(Block.func_149634_a((Item)Element.LOG_AUTUMN.get().func_77973_b()), Element.LOG_AUTUMN.get().func_77960_j());
            }
        } else if (metadata == BlockType.ACACIA.metadata()) {
            tree = new WorldGenAcacia(true);
        } else if (metadata == BlockType.CYPRESS.metadata()) {
            tree = new WorldGenCypressTree(true);
        } else {
            for (x1 = 0; x1 >= -1; --x1) {
                for (z1 = 0; z1 >= -1; --z1) {
                    if (!this.isSameSapling(world, x + x1, y, z + z1, metadata) || !this.isSameSapling(world, x + x1 + 1, y, z + z1, metadata) || !this.isSameSapling(world, x + x1, y, z + z1 + 1, metadata) || !this.isSameSapling(world, x + x1 + 1, y, z + z1 + 1, metadata)) continue;
                    if (metadata == BlockType.FIR.metadata()) {
                        tree = new WorldGenFirTreeHuge(true);
                        offset = 1;
                    } else {
                        tree = GeneralSettings.useLegacyRedwoods ? new WorldGenRedwood(true) : new WorldGenNewRedwood(true);
                        offset = 0;
                    }
                    isHuge = true;
                    break;
                }
                if (tree != null) break;
            }
            if (tree == null && metadata == BlockType.FIR.metadata()) {
                z1 = 0;
                x1 = 0;
                tree = new WorldGenFirTree(true);
            }
        }
        if (tree != null) {
            if (isHuge) {
                world.func_147449_b(x + x1, y, z + z1, Blocks.field_150350_a);
                world.func_147449_b(x + x1 + 1, y, z + z1, Blocks.field_150350_a);
                world.func_147449_b(x + x1, y, z + z1 + 1, Blocks.field_150350_a);
                world.func_147449_b(x + x1 + 1, y, z + z1 + 1, Blocks.field_150350_a);
            } else {
                world.func_147449_b(x, y, z, Blocks.field_150350_a);
            }
            if (!tree.func_76484_a(world, rand, x + x1 + offset, y, z + z1 + offset)) {
                if (isHuge) {
                    world.func_147465_d(x + x1, y, z + z1, (Block)this, metadata, 3);
                    world.func_147465_d(x + x1 + 1, y, z + z1, (Block)this, metadata, 3);
                    world.func_147465_d(x + x1, y, z + z1 + 1, (Block)this, metadata, 3);
                    world.func_147465_d(x + x1 + 1, y, z + z1 + 1, (Block)this, metadata, 3);
                } else {
                    world.func_147465_d(x, y, z, (Block)this, metadata, 3);
                }
            } else if (isForestryFarmed) {
                if (isHuge) {
                    world.func_147449_b(x + x1, y - 1, z + z1, (Block)Blocks.field_150354_m);
                    world.func_147449_b(x + x1 + 1, y - 1, z + z1, (Block)Blocks.field_150354_m);
                    world.func_147449_b(x + x1, y - 1, z + z1 + 1, (Block)Blocks.field_150354_m);
                    world.func_147449_b(x + x1 + 1, y - 1, z + z1 + 1, (Block)Blocks.field_150354_m);
                } else {
                    world.func_147449_b(x, y - 1, z, (Block)Blocks.field_150354_m);
                }
            }
        }
    }

    public boolean isSameSapling(World world, int x, int y, int z, int metadata) {
        return world.func_147439_a(x, y, z) == this && BlockCustomSapling.unmarkedMetadata(world.func_72805_g(x, y, z)) == metadata;
    }

    public void func_149674_a(World world, int x, int y, int z, Random rand) {
        if (!world.field_72995_K) {
            super.func_149674_a(world, x, y, z, rand);
            this.attemptGrowTree(world, x, y, z, rand);
        }
    }

    public static int getSaplingLifespan() {
        return saplingLifespan;
    }

    public static void setSaplingLifespan(int life) {
        saplingLifespan = life > 0 ? life : 0;
    }

    @SubscribeEvent
    public void itemExpiring(ItemExpireEvent event) {
        if (event.entityItem.func_92059_d().func_77973_b().equals(Item.func_150898_a((Block)this.sapling))) {
            int metadata = BlockCustomSapling.unmarkedMetadata(event.entityItem.func_92059_d().func_77960_j());
            int posX = (int)Math.floor(event.entityItem.field_70142_S);
            int posY = (int)Math.floor(event.entityItem.field_70137_T);
            int posZ = (int)Math.floor(event.entityItem.field_70136_U);
            double chance = event.entityItem.field_70170_p.field_73012_v.nextDouble() * 100.0;
            if (this.func_149854_a(event.entityItem.field_70170_p.func_147439_a(posX, posY - 1, posZ))) {
                double ratio;
                double d = ratio = !GeneralSettings.bigTreeSaplingDropModifier ? 1.0 : 4.0;
                if (event.entityItem.field_70170_p.func_147437_c(posX, posY, posZ) && metadata == BlockType.ACACIA.metadata() && chance <= SaplingSettings.ACACIA.chance()) {
                    event.entityItem.field_70170_p.func_147465_d(posX, posY, posZ, this.sapling, metadata, 2);
                } else if (event.entityItem.field_70170_p.func_147437_c(posX, posY, posZ) && metadata == BlockType.UMBER.metadata() && chance <= SaplingSettings.UMBER.chance()) {
                    event.entityItem.field_70170_p.func_147465_d(posX, posY, posZ, this.sapling, metadata, 2);
                } else if (event.entityItem.field_70170_p.func_147437_c(posX, posY, posZ) && metadata == BlockType.CYPRESS.metadata() && chance <= SaplingSettings.CYPRESS.chance()) {
                    event.entityItem.field_70170_p.func_147465_d(posX, posY, posZ, this.sapling, metadata, 2);
                } else if (metadata == BlockType.FIR.metadata() && chance <= SaplingSettings.FIR.chance() * ratio) {
                    this.plant2x2Sapling(posX, posY, posZ, event.entityItem.field_70170_p, event.entityItem.func_92059_d());
                } else if (event.entityItem.field_70170_p.func_147437_c(posX, posY, posZ) && metadata == BlockType.GOLDENROD.metadata() && chance <= SaplingSettings.GOLDENROD.chance()) {
                    event.entityItem.field_70170_p.func_147465_d(posX, posY, posZ, this.sapling, metadata, 2);
                } else if (event.entityItem.field_70170_p.func_147437_c(posX, posY, posZ) && metadata == BlockType.VERMILLION.metadata() && chance <= SaplingSettings.VERMILLION.chance()) {
                    event.entityItem.field_70170_p.func_147465_d(posX, posY, posZ, this.sapling, metadata, 2);
                } else if (metadata == BlockType.REDWOOD.metadata() && chance <= SaplingSettings.REDWOOD.chance() * ratio) {
                    this.plant2x2Sapling(posX, posY, posZ, event.entityItem.field_70170_p, event.entityItem.func_92059_d());
                } else if (event.entityItem.field_70170_p.func_147437_c(posX, posY, posZ) && metadata == BlockType.CITRINE.metadata() && chance <= SaplingSettings.CITRINE.chance()) {
                    event.entityItem.field_70170_p.func_147465_d(posX, posY, posZ, this.sapling, metadata, 2);
                }
            }
        }
    }

    private void plant2x2Sapling(int x, int y, int z, World world, ItemStack sapling) {
        int metadata = sapling.func_77960_j();
        if ((world.func_147437_c(x, y, z) || this.isSameSaplingBlock(x, y, z, world, sapling)) && (world.func_147437_c(x + 1, y, z) || this.isSameSaplingBlock(x + 1, y, z, world, sapling)) && (world.func_147437_c(x + 1, y, z + 1) || this.isSameSaplingBlock(x + 1, y, z + 1, world, sapling)) && (world.func_147437_c(x, y, z + 1) || this.isSameSaplingBlock(x, y, z + 1, world, sapling)) && world.func_147437_c(x, y, z) && this.func_149854_a(world.func_147439_a(x, y - 1, z)) && this.func_149854_a(world.func_147439_a(x + 1, y - 1, z)) && this.func_149854_a(world.func_147439_a(x + 1, y - 1, z + 1)) && this.func_149854_a(world.func_147439_a(x, y - 1, z + 1))) {
            world.func_147465_d(x, y, z, this.sapling, metadata, 2);
            world.func_147465_d(x + 1, y, z, this.sapling, metadata, 2);
            world.func_147465_d(x + 1, y, z + 1, this.sapling, metadata, 2);
            world.func_147465_d(x, y, z + 1, this.sapling, metadata, 2);
            return;
        }
        if ((world.func_147437_c(x, y, z) || this.isSameSaplingBlock(x, y, z, world, sapling)) && (world.func_147437_c(x, y, z + 1) || this.isSameSaplingBlock(x, y, z + 1, world, sapling)) && (world.func_147437_c(x - 1, y, z + 1) || this.isSameSaplingBlock(x - 1, y, z + 1, world, sapling)) && (world.func_147437_c(x - 1, y, z) || this.isSameSaplingBlock(x - 1, y, z, world, sapling)) && world.func_147437_c(x, y, z) && this.func_149854_a(world.func_147439_a(x, y - 1, z)) && this.func_149854_a(world.func_147439_a(x, y - 1, z + 1)) && this.func_149854_a(world.func_147439_a(x - 1, y - 1, z + 1)) && this.func_149854_a(world.func_147439_a(x - 1, y - 1, z))) {
            world.func_147465_d(x, y, z, this.sapling, metadata, 2);
            world.func_147465_d(x, y, z + 1, this.sapling, metadata, 2);
            world.func_147465_d(x - 1, y, z + 1, this.sapling, metadata, 2);
            world.func_147465_d(x - 1, y, z, this.sapling, metadata, 2);
            return;
        }
        if ((world.func_147437_c(x, y, z) || this.isSameSaplingBlock(x, y, z, world, sapling)) && (world.func_147437_c(x - 1, y, z) || this.isSameSaplingBlock(x - 1, y, z, world, sapling)) && (world.func_147437_c(x - 1, y, z - 1) || this.isSameSaplingBlock(x - 1, y, z - 1, world, sapling)) && (world.func_147437_c(x, y, z - 1) || this.isSameSaplingBlock(x, y, z - 1, world, sapling)) && world.func_147437_c(x, y, z) && this.func_149854_a(world.func_147439_a(x, y - 1, z)) && this.func_149854_a(world.func_147439_a(x - 1, y - 1, z)) && this.func_149854_a(world.func_147439_a(x - 1, y - 1, z - 1)) && this.func_149854_a(world.func_147439_a(x, y - 1, z - 1))) {
            world.func_147465_d(x, y, z, this.sapling, metadata, 2);
            world.func_147465_d(x - 1, y, z, this.sapling, metadata, 2);
            world.func_147465_d(x - 1, y, z - 1, this.sapling, metadata, 2);
            world.func_147465_d(x, y, z - 1, this.sapling, metadata, 2);
            return;
        }
        if ((world.func_147437_c(x, y, z) || this.isSameSaplingBlock(x, y, z, world, sapling)) && (world.func_147437_c(x, y, z - 1) || this.isSameSaplingBlock(x, y, z - 1, world, sapling)) && (world.func_147437_c(x + 1, y, z - 1) || this.isSameSaplingBlock(x + 1, y, z - 1, world, sapling)) && (world.func_147437_c(x + 1, y, z) || this.isSameSaplingBlock(x + 1, y, z, world, sapling)) && world.func_147437_c(x, y, z) && this.func_149854_a(world.func_147439_a(x, y - 1, z)) && this.func_149854_a(world.func_147439_a(x, y - 1, z - 1)) && this.func_149854_a(world.func_147439_a(x + 1, y - 1, z - 1)) && this.func_149854_a(world.func_147439_a(x + 1, y - 1, z))) {
            world.func_147465_d(x, y, z, this.sapling, metadata, 2);
            world.func_147465_d(x, y, z - 1, this.sapling, metadata, 2);
            world.func_147465_d(x + 1, y, z - 1, this.sapling, metadata, 2);
            world.func_147465_d(x + 1, y, z, this.sapling, metadata, 2);
            return;
        }
    }

    private boolean isSameSaplingBlock(int x, int y, int z, World world, ItemStack sapling) {
        Block block = world.func_147439_a(x, y, z);
        int metadata = world.func_72805_g(x, y, z);
        return !block.isAir((IBlockAccess)world, x, y, z) && block != null && sapling.func_77973_b().equals(Item.func_150898_a((Block)block)) && sapling.func_77960_j() == metadata;
    }

    @SubscribeEvent
    public void itemEntering(EntityJoinWorldEvent event) {
        if (event.entity instanceof EntityItem && !event.world.field_72995_K && ((EntityItem)event.entity).func_92059_d().func_77973_b().equals(Item.func_150898_a((Block)this.sapling))) {
            ((EntityItem)event.entity).lifespan = saplingLifespan;
        }
    }

    public static void addInformation(int metaData, List listOfLines) {
        BlockType test = BlockType.values()[metaData];
        if (test != null) {
            String[] lines = test.toolTipData();
            if (lines.length < 1) {
                return;
            }
            if (lines.length > 1) {
                for (int line = 1; line < lines.length; ++line) {
                    listOfLines.add(lines[line]);
                }
                if (lines[0] != "") {
                    listOfLines.add("");
                }
            }
            if (lines[0] != "") {
                ToolTipStringFormatter.Format(LanguageRegistry.instance().getStringLocalization("extrabiomes.planting_guide"), listOfLines);
                listOfLines.add(lines[0]);
            }
        }
    }

    public static enum BlockType {
        UMBER(0, new String[]{"1x1"}),
        GOLDENROD(1, new String[]{"1x1"}),
        VERMILLION(2, new String[]{"1x1"}),
        CITRINE(3, new String[]{"1x1"}),
        FIR(4, new String[]{"1x1, 2x2"}),
        REDWOOD(5, new String[]{"2x2"}),
        ACACIA(6, new String[]{"1x1"}),
        CYPRESS(7, new String[]{"1x1"});

        private final int metadata;
        private final String[] toolTipData;

        private BlockType(int metadata, String[] data) {
            this.metadata = metadata;
            this.toolTipData = data;
        }

        public int metadata() {
            return this.metadata;
        }

        public String[] toolTipData() {
            return this.toolTipData;
        }
    }
}

