/*
 * Decompiled with CFR 0.152.
 */
package extrabiomes.blocks;

import com.google.common.base.Optional;
import cpw.mods.fml.relauncher.Side;
import cpw.mods.fml.relauncher.SideOnly;
import extrabiomes.Extrabiomes;
import extrabiomes.lib.Element;
import java.util.ArrayList;
import java.util.List;
import java.util.Random;
import net.minecraft.block.Block;
import net.minecraft.block.BlockLeavesBase;
import net.minecraft.block.material.Material;
import net.minecraft.client.renderer.texture.IIconRegister;
import net.minecraft.creativetab.CreativeTabs;
import net.minecraft.entity.Entity;
import net.minecraft.init.Blocks;
import net.minecraft.init.Items;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.util.IIcon;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;
import net.minecraftforge.common.IShearable;

public class BlockAutumnLeaves
extends BlockLeavesBase
implements IShearable {
    private IIcon[] textures = new IIcon[]{null, null, null, null, null, null, null, null, null, null, null, null};
    private static final int METADATA_BITMASK = 3;
    private static final int METADATA_USERPLACEDBIT = 4;
    private static final int METADATA_DECAYBIT = 8;
    private static final int METADATA_CLEARDECAYBIT = -9;
    int[] adjacentTreeBlocks;

    @SideOnly(value=Side.CLIENT)
    public void func_149651_a(IIconRegister iconRegister) {
        this.textures[0] = iconRegister.func_94245_a(Extrabiomes.TEXTURE_PATH + "leavesbrownautumnfancy");
        this.textures[1] = iconRegister.func_94245_a(Extrabiomes.TEXTURE_PATH + "leavesbrownautumnfast");
        this.textures[2] = iconRegister.func_94245_a(Extrabiomes.TEXTURE_PATH + "leavesorangeautumnfancy");
        this.textures[3] = iconRegister.func_94245_a(Extrabiomes.TEXTURE_PATH + "leavesorangeautumnfast");
        this.textures[4] = iconRegister.func_94245_a(Extrabiomes.TEXTURE_PATH + "leavesredautumnfancy");
        this.textures[5] = iconRegister.func_94245_a(Extrabiomes.TEXTURE_PATH + "leavesredautumnfast");
        this.textures[6] = iconRegister.func_94245_a(Extrabiomes.TEXTURE_PATH + "leavesyellowautumnfancy");
        this.textures[7] = iconRegister.func_94245_a(Extrabiomes.TEXTURE_PATH + "leavesyellowautumnfast");
        this.textures[8] = iconRegister.func_94245_a(Extrabiomes.TEXTURE_PATH + "better_leavesbrownautumn");
        this.textures[9] = iconRegister.func_94245_a(Extrabiomes.TEXTURE_PATH + "better_leavesorangeautumn");
        this.textures[10] = iconRegister.func_94245_a(Extrabiomes.TEXTURE_PATH + "better_leavesredautumn");
        this.textures[11] = iconRegister.func_94245_a(Extrabiomes.TEXTURE_PATH + "better_leavesyellowautumn");
    }

    private static int clearDecayOnMetadata(int metadata) {
        return metadata & 0xFFFFFFF7;
    }

    private static boolean isDecaying(int metadata) {
        return (metadata & 8) != 0;
    }

    private static boolean isUserPlaced(int metadata) {
        return (metadata & 4) != 0;
    }

    private static int setDecayOnMetadata(int metadata) {
        return metadata | 8;
    }

    private static int unmarkedMetadata(int metadata) {
        return metadata & 3;
    }

    public BlockAutumnLeaves(int index, Material material, boolean useFastGraphics) {
        super(material, useFastGraphics);
    }

    public void beginLeavesDecay(World world, int x, int y, int z) {
        world.func_72921_c(x, y, z, BlockAutumnLeaves.setDecayOnMetadata(world.func_72805_g(x, y, z)), 3);
    }

    public void func_149749_a(World world, int x, int y, int z, Block block, int metadata) {
        boolean leafDecayRadius = true;
        int chuckCheckRadius = 2;
        if (!world.func_72904_c(x - 2, y - 2, z - 2, x + 2, y + 2, z + 2)) {
            return;
        }
        for (int x1 = -1; x1 <= 1; ++x1) {
            for (int y1 = -1; y1 <= 1; ++y1) {
                for (int z1 = -1; z1 <= 1; ++z1) {
                    Block tblock = world.func_147439_a(x + x1, y + y1, z + z1);
                    if (tblock == null) continue;
                    tblock.beginLeavesDecay(world, x + x1, y + y1, z + z1);
                }
            }
        }
    }

    public int func_149692_a(int metadata) {
        Optional type = Optional.fromNullable((Object)((Object)BlockType.fromMetadata(metadata)));
        return type.isPresent() ? ((BlockType)((Object)type.get())).getSaplingMetadata() : 0;
    }

    private void doSaplingDrop(World world, int x, int y, int z, int metadata, int par7) {
        Item itemDropped = this.func_149650_a(metadata, world.field_73012_v, par7);
        if (itemDropped != null) {
            this.func_149642_a(world, x, y, z, new ItemStack(itemDropped, 1, this.func_149692_a(metadata)));
        }
    }

    public void func_149690_a(World world, int x, int y, int z, int metadata, float chance, int par7) {
        if (world.field_72995_K) {
            return;
        }
        if (world.field_73012_v.nextInt(20) == 0) {
            this.doSaplingDrop(world, x, y, z, metadata, par7);
        }
        if (world.field_73012_v.nextInt(200) == 0) {
            this.func_149642_a(world, x, y, z, new ItemStack(Items.field_151034_e, 1, 0));
        }
    }

    public IIcon func_149691_a(int side, int metadata) {
        return this.textures[BlockAutumnLeaves.unmarkedMetadata(metadata) * 2 + (!this.func_149662_c() ? 0 : 1)];
    }

    public IIcon getIconBetterLeaves(int metadata, float randomIndex) {
        return this.textures[8 + BlockAutumnLeaves.unmarkedMetadata(metadata)];
    }

    public IIcon getIconFallingLeaves(int metadata) {
        return this.textures[BlockAutumnLeaves.unmarkedMetadata(metadata) * 2 + 1];
    }

    public float getSpawnChanceFallingLeaves(int metadata) {
        return 0.1f;
    }

    @SideOnly(value=Side.CLIENT)
    public void func_149666_a(Item id, CreativeTabs tab, List itemList) {
        for (BlockType blockType : BlockType.values()) {
            itemList.add(new ItemStack((Block)this, 1, blockType.metadata()));
        }
    }

    public Item func_149650_a(int metadata, Random rand, int par3) {
        Optional type = Optional.fromNullable((Object)((Object)BlockType.fromMetadata(metadata)));
        return Item.func_150898_a((Block)(type.isPresent() ? ((BlockType)((Object)type.get())).getSaplingBlock() : Blocks.field_150345_g));
    }

    public boolean isLeaves(IBlockAccess world, int x, int y, int z) {
        return true;
    }

    public boolean func_149662_c() {
        return Blocks.field_150362_t.func_149662_c();
    }

    public boolean isShearable(ItemStack item, IBlockAccess world, int x, int y, int z) {
        return true;
    }

    public void func_149724_b(World world, int x, int y, int z, Entity entity) {
        this.beginLeavesDecay(world, x, y, z);
    }

    public ArrayList<ItemStack> onSheared(ItemStack item, IBlockAccess world, int x, int y, int z, int fortune) {
        ArrayList<ItemStack> ret = new ArrayList<ItemStack>();
        ret.add(new ItemStack((Block)this, 1, BlockAutumnLeaves.unmarkedMetadata(world.func_72805_g(x, y, z))));
        return ret;
    }

    public int func_149745_a(Random rand) {
        return rand.nextInt(20) == 0 ? 1 : 0;
    }

    private void removeLeaves(World world, int x, int y, int z) {
        this.func_149697_b(world, x, y, z, world.func_72805_g(x, y, z), 0);
        world.func_147468_f(x, y, z);
    }

    public boolean func_149646_a(IBlockAccess par1iBlockAccess, int par2, int par3, int par4, int par5) {
        this.field_150121_P = !Blocks.field_150362_t.func_149662_c();
        return super.func_149646_a(par1iBlockAccess, par2, par3, par4, par5);
    }

    public void func_149674_a(World world, int x, int y, int z, Random rand) {
        if (world.field_72995_K) {
            return;
        }
        int metadata = world.func_72805_g(x, y, z);
        if (BlockAutumnLeaves.isUserPlaced(metadata) || !BlockAutumnLeaves.isDecaying(metadata)) {
            return;
        }
        int rangeWood = 4;
        int rangeCheckChunk = 5;
        int var9 = 32;
        int var10 = 1024;
        int var11 = 16;
        if (this.adjacentTreeBlocks == null) {
            this.adjacentTreeBlocks = new int[32768];
        }
        if (world.func_72904_c(x - 5, y - 5, z - 5, x + 5, y + 5, z + 5)) {
            int var14;
            int var13;
            int var12;
            for (var12 = -4; var12 <= 4; ++var12) {
                for (var13 = -4; var13 <= 4; ++var13) {
                    for (var14 = -4; var14 <= 4; ++var14) {
                        Block block = world.func_147439_a(x + var12, y + var13, z + var14);
                        this.adjacentTreeBlocks[(var12 + 16) * 1024 + (var13 + 16) * 32 + var14 + 16] = block != null && block.isWood((IBlockAccess)world, x + var12, y + var13, z + var14) ? 0 : (block != null && block.isLeaves((IBlockAccess)world, x + var12, y + var13, z + var14) ? -2 : -1);
                    }
                }
            }
            for (var12 = 1; var12 <= 4; ++var12) {
                for (var13 = -4; var13 <= 4; ++var13) {
                    for (var14 = -4; var14 <= 4; ++var14) {
                        for (int var15 = -4; var15 <= 4; ++var15) {
                            if (this.adjacentTreeBlocks[(var13 + 16) * 1024 + (var14 + 16) * 32 + var15 + 16] != var12 - 1) continue;
                            if (this.adjacentTreeBlocks[(var13 + 16 - 1) * 1024 + (var14 + 16) * 32 + var15 + 16] == -2) {
                                this.adjacentTreeBlocks[(var13 + 16 - 1) * 1024 + (var14 + 16) * 32 + var15 + 16] = var12;
                            }
                            if (this.adjacentTreeBlocks[(var13 + 16 + 1) * 1024 + (var14 + 16) * 32 + var15 + 16] == -2) {
                                this.adjacentTreeBlocks[(var13 + 16 + 1) * 1024 + (var14 + 16) * 32 + var15 + 16] = var12;
                            }
                            if (this.adjacentTreeBlocks[(var13 + 16) * 1024 + (var14 + 16 - 1) * 32 + var15 + 16] == -2) {
                                this.adjacentTreeBlocks[(var13 + 16) * 1024 + (var14 + 16 - 1) * 32 + var15 + 16] = var12;
                            }
                            if (this.adjacentTreeBlocks[(var13 + 16) * 1024 + (var14 + 16 + 1) * 32 + var15 + 16] == -2) {
                                this.adjacentTreeBlocks[(var13 + 16) * 1024 + (var14 + 16 + 1) * 32 + var15 + 16] = var12;
                            }
                            if (this.adjacentTreeBlocks[(var13 + 16) * 1024 + (var14 + 16) * 32 + var15 + 16 - 1] == -2) {
                                this.adjacentTreeBlocks[(var13 + 16) * 1024 + (var14 + 16) * 32 + var15 + 16 - 1] = var12;
                            }
                            if (this.adjacentTreeBlocks[(var13 + 16) * 1024 + (var14 + 16) * 32 + var15 + 16 + 1] != -2) continue;
                            this.adjacentTreeBlocks[(var13 + 16) * 1024 + (var14 + 16) * 32 + var15 + 16 + 1] = var12;
                        }
                    }
                }
            }
        }
        if (this.adjacentTreeBlocks[16912] >= 0) {
            world.func_72921_c(x, y, z, BlockAutumnLeaves.clearDecayOnMetadata(metadata), 3);
        } else {
            this.removeLeaves(world, x, y, z);
        }
    }

    public static enum BlockType {
        UMBER(0),
        GOLDENROD(1),
        VERMILLION(2),
        CITRINE(3);

        private final int metadata;
        private ItemStack sapling = new ItemStack(Blocks.field_150345_g);
        private static boolean loadedCustomBlocks;

        static BlockType fromMetadata(int metadata) {
            metadata = BlockAutumnLeaves.unmarkedMetadata(metadata);
            for (BlockType type : BlockType.values()) {
                if (type.metadata() != metadata) continue;
                return type;
            }
            return null;
        }

        private static void loadCustomBlocks() {
            if (Element.SAPLING_AUTUMN_BROWN.isPresent()) {
                BlockType.UMBER.sapling = Element.SAPLING_AUTUMN_BROWN.get();
            }
            if (Element.SAPLING_AUTUMN_ORANGE.isPresent()) {
                BlockType.GOLDENROD.sapling = Element.SAPLING_AUTUMN_ORANGE.get();
            }
            if (Element.SAPLING_AUTUMN_PURPLE.isPresent()) {
                BlockType.VERMILLION.sapling = Element.SAPLING_AUTUMN_PURPLE.get();
            }
            if (Element.SAPLING_AUTUMN_YELLOW.isPresent()) {
                BlockType.CITRINE.sapling = Element.SAPLING_AUTUMN_YELLOW.get();
            }
            loadedCustomBlocks = true;
        }

        private BlockType(int metadata) {
            this.metadata = metadata;
        }

        Block getSaplingBlock() {
            if (!loadedCustomBlocks) {
                BlockType.loadCustomBlocks();
            }
            return Block.func_149634_a((Item)this.sapling.func_77973_b());
        }

        int getSaplingMetadata() {
            if (!loadedCustomBlocks) {
                BlockType.loadCustomBlocks();
            }
            return this.sapling.func_77960_j();
        }

        public int metadata() {
            return this.metadata;
        }

        static {
            loadedCustomBlocks = false;
        }
    }
}

