/*
 * Decompiled with CFR 0.152.
 */
package extrabiomes.api;

import com.google.common.base.Optional;
import com.google.common.base.Preconditions;
import java.util.Collection;
import java.util.Random;
import net.minecraft.world.biome.BiomeGenBase;
import net.minecraft.world.gen.feature.WorldGenerator;

@Deprecated
public abstract class BiomeManager {
    public static Optional<? extends BiomeGenBase> alpine = Optional.absent();
    public static Optional<? extends BiomeGenBase> autumnwoods = Optional.absent();
    public static Optional<? extends BiomeGenBase> birchforest = Optional.absent();
    public static Optional<? extends BiomeGenBase> extremejungle = Optional.absent();
    public static Optional<? extends BiomeGenBase> forestedisland = Optional.absent();
    public static Optional<? extends BiomeGenBase> forestedhills = Optional.absent();
    public static Optional<? extends BiomeGenBase> glacier = Optional.absent();
    public static Optional<? extends BiomeGenBase> greenhills = Optional.absent();
    public static Optional<? extends BiomeGenBase> icewasteland = Optional.absent();
    public static Optional<? extends BiomeGenBase> greenswamp = Optional.absent();
    public static Optional<? extends BiomeGenBase> marsh = Optional.absent();
    public static Optional<? extends BiomeGenBase> meadow = Optional.absent();
    public static Optional<? extends BiomeGenBase> minijungle = Optional.absent();
    public static Optional<? extends BiomeGenBase> mountaindesert = Optional.absent();
    public static Optional<? extends BiomeGenBase> mountainridge = Optional.absent();
    public static Optional<? extends BiomeGenBase> mountaintaiga = Optional.absent();
    public static Optional<? extends BiomeGenBase> pineforest = Optional.absent();
    public static Optional<? extends BiomeGenBase> rainforest = Optional.absent();
    public static Optional<? extends BiomeGenBase> redwoodforest = Optional.absent();
    public static Optional<? extends BiomeGenBase> redwoodlush = Optional.absent();
    public static Optional<? extends BiomeGenBase> savanna = Optional.absent();
    public static Optional<? extends BiomeGenBase> shrubland = Optional.absent();
    public static Optional<? extends BiomeGenBase> snowforest = Optional.absent();
    public static Optional<? extends BiomeGenBase> snowyrainforest = Optional.absent();
    public static Optional<? extends BiomeGenBase> temperaterainforest = Optional.absent();
    public static Optional<? extends BiomeGenBase> tundra = Optional.absent();
    public static Optional<? extends BiomeGenBase> wasteland = Optional.absent();
    public static Optional<? extends BiomeGenBase> woodlands = Optional.absent();
    protected static Optional<? extends BiomeManager> instance = Optional.absent();

    public static void addWeightedGrassGenForBiome(BiomeGenBase biome, WorldGenerator grassGen, int weight) {
        Preconditions.checkArgument((boolean)instance.isPresent(), (Object)"Cannot add weighted grass gens until after API is initialized.");
        Preconditions.checkNotNull((Object)biome, (Object)"Biome is required.");
        Preconditions.checkNotNull((Object)grassGen, (Object)"Grass generator is required.");
        Preconditions.checkArgument((weight > 0 ? 1 : 0) != 0, (Object)"Weight must be greater than zero.");
        ((BiomeManager)instance.get()).addBiomeGen(GenType.GRASS, biome, grassGen, weight);
    }

    public static void addWeightedTreeGenForBiome(BiomeGenBase biome, WorldGenerator treeGen, int weight) {
        Preconditions.checkArgument((boolean)instance.isPresent(), (Object)"Cannot add weighted tree gens until after API is initialized.");
        Preconditions.checkNotNull((Object)biome, (Object)"Biome is required.");
        Preconditions.checkNotNull((Object)treeGen, (Object)"Tree Generator is required.");
        Preconditions.checkArgument((weight > 0 ? 1 : 0) != 0, (Object)"Weight must be greater than zero.");
        ((BiomeManager)instance.get()).addBiomeGen(GenType.TREE, biome, treeGen, weight);
    }

    public static Optional<? extends WorldGenerator> chooseRandomGrassGenforBiome(Random rand, BiomeGenBase biome) {
        return ((BiomeManager)instance.get()).chooseBiomeRandomGen(GenType.GRASS, rand, biome);
    }

    public static Optional<? extends WorldGenerator> chooseRandomTreeGenforBiome(Random rand, BiomeGenBase biome) {
        return ((BiomeManager)instance.get()).chooseBiomeRandomGen(GenType.TREE, rand, biome);
    }

    public static Collection<BiomeGenBase> getBiomes() {
        Preconditions.checkArgument((boolean)instance.isPresent(), (Object)"Biome list not available until after API is initialized.");
        return ((BiomeManager)instance.get()).getBiomeCollection();
    }

    public static int getTotalGrassWeightForBiome(BiomeGenBase biome) {
        Preconditions.checkNotNull((Object)biome, (Object)"Biome is required.");
        return ((BiomeManager)instance.get()).getBiomeTotalWeight(GenType.GRASS, biome);
    }

    public static int getTotalTreeWeightForBiome(BiomeGenBase biome) {
        Preconditions.checkNotNull((Object)biome, (Object)"Biome is required.");
        return ((BiomeManager)instance.get()).getBiomeTotalWeight(GenType.TREE, biome);
    }

    static boolean isActive() {
        return instance.isPresent();
    }

    protected abstract void addBiomeGen(GenType var1, BiomeGenBase var2, WorldGenerator var3, int var4);

    protected abstract Optional<? extends WorldGenerator> chooseBiomeRandomGen(GenType var1, Random var2, BiomeGenBase var3);

    protected abstract Collection<BiomeGenBase> getBiomeCollection();

    protected abstract int getBiomeTotalWeight(GenType var1, BiomeGenBase var2);

    protected static enum GenType {
        TREE,
        GRASS;

    }
}

