/*
 * Decompiled with CFR 0.152.
 */
package ic2.core.block;

import cpw.mods.fml.common.eventhandler.SubscribeEvent;
import cpw.mods.fml.common.registry.GameRegistry;
import cpw.mods.fml.relauncher.Side;
import cpw.mods.fml.relauncher.SideOnly;
import ic2.api.event.PaintEvent;
import ic2.api.event.RetextureEvent;
import ic2.core.IC2;
import ic2.core.Ic2Items;
import ic2.core.block.BlockMultiID;
import ic2.core.block.TileEntityWall;
import ic2.core.init.InternalName;
import ic2.core.item.block.ItemBlockIC2;
import ic2.core.util.Util;
import java.util.List;
import java.util.Random;
import net.minecraft.block.Block;
import net.minecraft.block.BlockColored;
import net.minecraft.block.material.Material;
import net.minecraft.creativetab.CreativeTabs;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.IIcon;
import net.minecraft.util.MovingObjectPosition;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.common.util.ForgeDirection;
import org.apache.commons.lang3.mutable.MutableObject;

public class BlockWall
extends BlockMultiID {
    protected int colorMultiplier = -1;

    public BlockWall(InternalName internalName1) {
        super(internalName1, Material.field_151576_e, ItemBlockIC2.class);
        this.func_149711_c(3.0f);
        this.func_149752_b(30.0f);
        this.func_149672_a(field_149769_e);
        this.func_149647_a(null);
        Ic2Items.constructionFoamWall = new ItemStack((Block)this);
        GameRegistry.registerTileEntity(TileEntityWall.class, (String)"CF-Wall");
        MinecraftForge.EVENT_BUS.register((Object)this);
    }

    @Override
    public String getTextureFolder(int id) {
        return "cf";
    }

    @Override
    public String getTextureName(int index) {
        if (index >= 0 && index <= 15) {
            return InternalName.blockWall.name() + "." + Util.getColorName(index).name();
        }
        return null;
    }

    @Override
    @SideOnly(value=Side.CLIENT)
    public IIcon func_149673_e(IBlockAccess blockAccess, int x, int y, int z, int side) {
        TileEntityWall te = (TileEntityWall)this.getOwnTe(blockAccess, x, y, z);
        if (te == null) {
            return null;
        }
        Block referencedBlock = te.getReferencedBlock(side);
        if (referencedBlock != null) {
            try {
                return referencedBlock.func_149691_a(te.retextureRefSide[side], te.retextureRefMeta[side]);
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        return super.func_149673_e(blockAccess, x, y, z, side);
    }

    @Override
    public int func_149645_b() {
        return IC2.platform.getRenderId("wall");
    }

    public int func_149745_a(Random r) {
        return 0;
    }

    @Override
    public Class<? extends TileEntity> getTeClass(int meta, MutableObject<Class<?>[]> ctorArgTypes, MutableObject<Object[]> ctorArgs) {
        return TileEntityWall.class;
    }

    public boolean recolourBlock(World world, int x, int y, int z, ForgeDirection side, int color) {
        if ((color = BlockColored.func_150031_c((int)color)) != world.func_72805_g(x, y, z)) {
            world.func_72921_c(x, y, z, color, 3);
            return true;
        }
        return false;
    }

    @SubscribeEvent
    public void onPaint(PaintEvent event) {
        if (event.world.func_147439_a(event.x, event.y, event.z) != this) {
            return;
        }
        if (event.color != event.world.func_72805_g(event.x, event.y, event.z)) {
            event.world.func_72921_c(event.x, event.y, event.z, event.color, 3);
            event.painted = true;
        }
    }

    public ItemStack func_149644_j(int i) {
        return null;
    }

    @Override
    public ItemStack getPickBlock(MovingObjectPosition target, World world, int x, int y, int z) {
        return Ic2Items.constructionFoam.func_77946_l();
    }

    @SubscribeEvent
    public void onRetexture(RetextureEvent event) {
        TileEntityWall te = (TileEntityWall)this.getOwnTe((IBlockAccess)event.world, event.x, event.y, event.z);
        if (te == null) {
            return;
        }
        if (te.retexture(event.side, event.referencedBlock, event.referencedMeta, event.referencedSide)) {
            event.applied = true;
        }
    }

    @Override
    public void func_149666_a(Item item, CreativeTabs par2CreativeTabs, List par3List) {
        for (int j = 0; j < 16; ++j) {
            par3List.add(new ItemStack(item, 1, j));
        }
    }

    public int func_149720_d(IBlockAccess par1iBlockAccess, int x, int y, int z) {
        if (this.colorMultiplier != -1) {
            return this.colorMultiplier;
        }
        return super.func_149720_d(par1iBlockAccess, x, y, z);
    }
}

