/*
 * Decompiled with CFR 0.152.
 */
package pneumaticCraft.common.tileentity;

import java.util.ArrayList;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Set;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.EnumChatFormatting;
import net.minecraft.world.World;
import net.minecraftforge.common.util.ForgeDirection;
import org.apache.commons.lang3.tuple.ImmutablePair;
import org.apache.commons.lang3.tuple.MutablePair;
import org.apache.commons.lang3.tuple.Pair;
import pneumaticCraft.api.tileentity.IAirHandler;
import pneumaticCraft.api.tileentity.IManoMeasurable;
import pneumaticCraft.api.tileentity.IPneumaticMachine;
import pneumaticCraft.api.tileentity.ISidedPneumaticMachine;
import pneumaticCraft.common.block.tubes.IPneumaticPosProvider;
import pneumaticCraft.common.network.GuiSynced;
import pneumaticCraft.common.network.NetworkHandler;
import pneumaticCraft.common.network.PacketPlaySound;
import pneumaticCraft.common.network.PacketSpawnParticle;
import pneumaticCraft.common.thirdparty.ModInteractionUtils;
import pneumaticCraft.common.thirdparty.computercraft.LuaConstant;
import pneumaticCraft.common.thirdparty.computercraft.LuaMethod;
import pneumaticCraft.common.tileentity.TileEntityBase;
import pneumaticCraft.common.util.PneumaticCraftUtils;
import pneumaticCraft.lib.Log;

public class TileEntityPneumaticBase
extends TileEntityBase
implements IManoMeasurable,
IAirHandler,
IPneumaticPosProvider {
    public float maxPressure;
    @GuiSynced
    public int volume;
    public final int DEFAULT_VOLUME;
    public final float DANGER_PRESSURE;
    public final float CRITICAL_PRESSURE;
    @GuiSynced
    public int currentAir;
    public int soundCounter;
    public TileEntity parentTile;
    protected final Set<IAirHandler> specialConnectedHandlers = new HashSet<IAirHandler>();

    public TileEntityPneumaticBase(float dangerPressure, float criticalPressure, int volume) {
        if (volume <= 0) {
            throw new IllegalArgumentException("Volume can't be lower than or equal to 0!");
        }
        this.DANGER_PRESSURE = dangerPressure;
        this.CRITICAL_PRESSURE = criticalPressure;
        this.maxPressure = this.DANGER_PRESSURE + (this.CRITICAL_PRESSURE - this.DANGER_PRESSURE) * (float)Math.random();
        this.volume = volume;
        this.DEFAULT_VOLUME = volume;
        this.currentAir = 0;
        this.addLuaMethods();
    }

    @Override
    public void func_145845_h() {
        if (!this.field_145850_b.field_72995_K && this.getUpgradeSlots() != null) {
            int upgradeVolume = this.getVolumeFromUpgrades(this.getUpgradeSlots());
            this.setVolume(this.DEFAULT_VOLUME + upgradeVolume);
            if (this.getUpgrades(9, this.getUpgradeSlots()) > 0) {
                int excessAir;
                if ((double)this.getPressure(ForgeDirection.UNKNOWN) >= (double)this.DANGER_PRESSURE - 0.1) {
                    this.airLeak(ForgeDirection.DOWN);
                }
                if ((excessAir = this.getCurrentAir(ForgeDirection.UNKNOWN) - (int)((double)this.getVolume() * ((double)this.DANGER_PRESSURE - 0.1))) > 0) {
                    this.addAir(-excessAir, ForgeDirection.DOWN);
                    this.onAirDispersion(-excessAir, ForgeDirection.DOWN);
                }
            }
        }
        super.func_145845_h();
        for (ForgeDirection pneumaticSide : ForgeDirection.values()) {
            if (this.field_145850_b.field_72995_K || !(this.getPressure(pneumaticSide) > this.maxPressure)) continue;
            this.field_145850_b.func_72876_a(null, (double)this.field_145851_c + 0.5, (double)this.field_145848_d + 0.5, (double)this.field_145849_e + 0.5, 1.0f, true);
            this.field_145850_b.func_147468_f(this.field_145851_c, this.field_145848_d, this.field_145849_e);
        }
        if (!this.field_145850_b.field_72995_K) {
            this.disperseAir();
        }
        if (this.soundCounter > 0) {
            --this.soundCounter;
        }
    }

    protected void disperseAir() {
        if (this.field_145850_b.field_72995_K) {
            return;
        }
        this.disperseAir(this.getConnectedPneumatics());
    }

    private void disperseAir(List<Pair<ForgeDirection, IAirHandler>> teList) {
        boolean shouldRepeat = false;
        ArrayList<MutablePair> dispersion = new ArrayList<MutablePair>();
        block0: do {
            shouldRepeat = false;
            int totalVolume = this.getVolume();
            int totalAir = this.currentAir;
            for (Pair<ForgeDirection, IAirHandler> pair : teList) {
                IAirHandler iAirHandler = (IAirHandler)pair.getValue();
                totalVolume += iAirHandler.getVolume();
                totalAir += iAirHandler.getCurrentAir(((ForgeDirection)pair.getKey()).getOpposite());
            }
            Iterator<Pair<ForgeDirection, IAirHandler>> iterator = teList.iterator();
            while (iterator.hasNext()) {
                Pair<ForgeDirection, IAirHandler> pair = iterator.next();
                IAirHandler iAirHandler = (IAirHandler)pair.getValue();
                int totalMachineAir = (int)((long)totalAir * (long)iAirHandler.getVolume() / (long)totalVolume);
                int airDispersed = totalMachineAir - iAirHandler.getCurrentAir(((ForgeDirection)pair.getKey()).getOpposite());
                if (airDispersed < 0) {
                    iterator.remove();
                    shouldRepeat = true;
                    dispersion.clear();
                    continue block0;
                }
                dispersion.add(new MutablePair((Object)this.getMaxDispersion((ForgeDirection)pair.getKey()), (Object)airDispersed));
            }
        } while (shouldRepeat);
        int toBeDivided = 0;
        int receivers = dispersion.size();
        for (Pair pair : dispersion) {
            if ((Integer)pair.getValue() <= (Integer)pair.getKey()) continue;
            toBeDivided += (Integer)pair.getValue() - (Integer)pair.getKey();
            pair.setValue(pair.getKey());
            --receivers;
        }
        while (toBeDivided >= receivers && receivers > 0) {
            int dividedValue = toBeDivided / receivers;
            for (Pair pair : dispersion) {
                int maxTransfer = (Integer)pair.getKey() - (Integer)pair.getValue();
                if (maxTransfer > 0) {
                    if (maxTransfer <= dividedValue) {
                        --receivers;
                    }
                    int transfered = Math.min(dividedValue, maxTransfer);
                    pair.setValue((Object)((Integer)pair.getValue() + transfered));
                    toBeDivided -= transfered;
                    continue;
                }
                --receivers;
            }
        }
        for (int i = 0; i < teList.size(); ++i) {
            IAirHandler iAirHandler = (IAirHandler)teList.get(i).getValue();
            int n = (Integer)((Pair)dispersion.get(i)).getValue();
            this.onAirDispersion(n, (ForgeDirection)teList.get(i).getKey());
            iAirHandler.addAir(n, ((ForgeDirection)teList.get(i).getKey()).getOpposite());
            this.addAir(-n, (ForgeDirection)teList.get(i).getKey());
        }
    }

    protected int getMaxDispersion(ForgeDirection side) {
        return Integer.MAX_VALUE;
    }

    protected void onAirDispersion(int amount, ForgeDirection side) {
    }

    @Override
    public void airLeak(ForgeDirection side) {
        if (this.field_145850_b.field_72995_K || Math.abs(this.getPressure(side)) < 0.01f) {
            return;
        }
        double motionX = side.offsetX;
        double motionY = side.offsetY;
        double motionZ = side.offsetZ;
        if (this.soundCounter <= 0) {
            this.soundCounter = 20;
            NetworkHandler.sendToAllAround(new PacketPlaySound("pneumaticcraft:leakingGas", this.field_145851_c, this.field_145848_d, this.field_145849_e, 0.1f, 1.0f, true), this.field_145850_b);
        }
        if (this.getPressure(side) < 0.0f) {
            double speed = this.getPressure(side) * 0.1f - 0.1f;
            NetworkHandler.sendToAllAround(new PacketSpawnParticle("smoke", (double)this.field_145851_c + 0.5 + motionX / 2.0, (double)this.field_145848_d + 0.5 + motionY / 2.0, (double)this.field_145849_e + 0.5 + motionZ / 2.0, motionX * speed, motionY * speed, motionZ * speed), this.field_145850_b);
            int dispersedAmount = -((int)(this.getPressure(side) * 40.0f)) + 20;
            if (this.getCurrentAir(side) > dispersedAmount) {
                dispersedAmount = -this.getCurrentAir(side);
            }
            this.onAirDispersion(dispersedAmount, side);
            this.addAir(dispersedAmount, side);
        } else {
            double speed = this.getPressure(side) * 0.1f + 0.1f;
            NetworkHandler.sendToAllAround(new PacketSpawnParticle("smoke", (double)this.field_145851_c + 0.5 + motionX / 2.0, (double)this.field_145848_d + 0.5 + motionY / 2.0, (double)this.field_145849_e + 0.5 + motionZ / 2.0, motionX * speed, motionY * speed, motionZ * speed), this.field_145850_b);
            int dispersedAmount = (int)(this.getPressure(side) * 40.0f) + 20;
            if (dispersedAmount > this.getCurrentAir(side)) {
                dispersedAmount = this.getCurrentAir(side);
            }
            this.onAirDispersion(-dispersedAmount, side);
            this.addAir(-dispersedAmount, side);
        }
    }

    @Override
    public List<Pair<ForgeDirection, IAirHandler>> getConnectedPneumatics() {
        ArrayList<Pair<ForgeDirection, IAirHandler>> teList = new ArrayList<Pair<ForgeDirection, IAirHandler>>();
        for (IAirHandler specialConnection : this.specialConnectedHandlers) {
            teList.add((Pair<ForgeDirection, IAirHandler>)new ImmutablePair((Object)ForgeDirection.UNKNOWN, (Object)specialConnection));
        }
        for (ForgeDirection direction : ForgeDirection.VALID_DIRECTIONS) {
            IAirHandler handler;
            TileEntity te = this.getTileCache()[direction.ordinal()].getTileEntity();
            IPneumaticMachine machine = ModInteractionUtils.getInstance().getMachine(te);
            if (machine != null && this.isConnectedTo(direction) && machine.isConnectedTo(direction.getOpposite())) {
                teList.add((Pair<ForgeDirection, IAirHandler>)new ImmutablePair((Object)direction, (Object)machine.getAirHandler()));
                continue;
            }
            if (!(te instanceof ISidedPneumaticMachine) || (handler = ((ISidedPneumaticMachine)te).getAirHandler(direction.getOpposite())) == null) continue;
            teList.add((Pair<ForgeDirection, IAirHandler>)new ImmutablePair((Object)direction, (Object)handler));
        }
        return teList;
    }

    @Override
    public boolean isConnectedTo(ForgeDirection side) {
        if (this.parentTile == null) {
            return true;
        }
        if (this.parentTile instanceof IPneumaticMachine) {
            return ((IPneumaticMachine)this.parentTile).isConnectedTo(side);
        }
        return ((ISidedPneumaticMachine)this.parentTile).getAirHandler(side) == this;
    }

    @Override
    @Deprecated
    public void addAir(float amount, ForgeDirection side) {
        this.addAir((int)amount, side);
    }

    @Override
    public void addAir(int amount, ForgeDirection side) {
        this.currentAir += amount;
    }

    @Override
    @Deprecated
    public void setVolume(float newVolume) {
        this.setVolume((int)newVolume);
    }

    @Override
    public void setVolume(int newVolume) {
        if (newVolume <= 0) {
            throw new IllegalArgumentException("Volume can't be lower or equal than 0!");
        }
        if (newVolume < this.volume) {
            this.currentAir = (int)((float)this.currentAir * (float)newVolume / (float)this.volume);
        }
        this.volume = newVolume;
    }

    @Override
    public float getPressure(ForgeDirection sideRequested) {
        return (float)this.currentAir / (float)this.volume;
    }

    @Override
    public void func_145839_a(NBTTagCompound nbt) {
        if (this.getClass() != TileEntityPneumaticBase.class && this.saveTeInternals()) {
            super.func_145839_a(nbt);
        }
        if (nbt.func_74764_b("pneumatic")) {
            nbt = nbt.func_74775_l("pneumatic");
        }
        this.currentAir = nbt.func_74762_e("currentAir");
        this.maxPressure = nbt.func_74760_g("maxPressure");
        this.volume = nbt.func_74762_e("volume");
        if (this.volume == 0) {
            Log.error("Volume was 0! Assigning default");
            this.volume = this.DEFAULT_VOLUME;
        }
    }

    @Override
    public void func_145841_b(NBTTagCompound nbt) {
        if (this.getClass() != TileEntityPneumaticBase.class && this.saveTeInternals()) {
            super.func_145841_b(nbt);
        }
        nbt.func_74768_a("currentAir", this.currentAir);
        nbt.func_74768_a("volume", this.volume);
        nbt.func_74776_a("maxPressure", this.maxPressure);
        NBTTagCompound tag = new NBTTagCompound();
        nbt.func_74782_a("pneumatic", (NBTBase)tag);
        nbt = tag;
        nbt.func_74768_a("currentAir", this.currentAir);
        nbt.func_74768_a("volume", this.volume);
        nbt.func_74776_a("maxPressure", this.maxPressure);
    }

    protected boolean saveTeInternals() {
        return true;
    }

    protected int getVolumeFromUpgrades(int[] upgradeSlots) {
        return this.getUpgrades(0, upgradeSlots) * 5000;
    }

    @Override
    public void printManometerMessage(EntityPlayer player, List<String> curInfo) {
        curInfo.add(EnumChatFormatting.GREEN + "Current pressure: " + PneumaticCraftUtils.roundNumberTo(this.getPressure(ForgeDirection.UNKNOWN), 1) + " bar.");
    }

    @Override
    public int getVolume() {
        return this.volume;
    }

    @Override
    public float getMaxPressure() {
        return this.maxPressure;
    }

    @Override
    public int getCurrentAir(ForgeDirection sideRequested) {
        return this.currentAir;
    }

    @Override
    public IAirHandler getAirHandler() {
        return this;
    }

    @Override
    public int getXCoord() {
        return this.field_145851_c;
    }

    @Override
    public int getYCoord() {
        return this.field_145848_d;
    }

    @Override
    public int getZCoord() {
        return this.field_145849_e;
    }

    @Override
    protected void addLuaMethods() {
        super.addLuaMethods();
        this.luaMethods.add(new LuaMethod("getPressure"){

            @Override
            public Object[] call(Object[] args) throws Exception {
                if (args.length == 0) {
                    return new Object[]{Float.valueOf(TileEntityPneumaticBase.this.getPressure(ForgeDirection.UNKNOWN))};
                }
                if (args.length == 1) {
                    return new Object[]{Float.valueOf(TileEntityPneumaticBase.this.getPressure(this.getDirForString((String)args[0])))};
                }
                throw new IllegalArgumentException("getPressure method requires 0 or 1 argument (direction: up, down, east, west, north, south!");
            }
        });
        this.luaMethods.add(new LuaConstant("getDangerPressure", this.DANGER_PRESSURE));
        this.luaMethods.add(new LuaConstant("getCriticalPressure", this.CRITICAL_PRESSURE));
        this.luaMethods.add(new LuaConstant("getDefaultVolume", this.DEFAULT_VOLUME));
    }

    @Override
    public void updateEntityI() {
        this.func_145845_h();
    }

    @Override
    public void readFromNBTI(NBTTagCompound nbt) {
        this.func_145839_a(nbt);
    }

    @Override
    public void writeToNBTI(NBTTagCompound nbt) {
        this.func_145841_b(nbt);
    }

    @Override
    public void validateI(TileEntity parent) {
        this.parentTile = parent;
        this.field_145850_b = parent.func_145831_w();
        this.field_145851_c = parent.field_145851_c;
        this.field_145848_d = parent.field_145848_d;
        this.field_145849_e = parent.field_145849_e;
    }

    @Override
    public void onNeighborChange() {
        this.onNeighborTileUpdate();
    }

    @Override
    public World world() {
        return this.field_145850_b;
    }

    @Override
    public int x() {
        return this.field_145851_c;
    }

    @Override
    public int y() {
        return this.field_145848_d;
    }

    @Override
    public int z() {
        return this.field_145849_e;
    }

    @Override
    public void createConnection(IAirHandler otherHandler) {
        if (otherHandler == null) {
            throw new NullPointerException("Can't connect with a null air handler!");
        }
        if (this.specialConnectedHandlers.add(otherHandler)) {
            otherHandler.createConnection(this);
        }
    }

    @Override
    public void removeConnection(IAirHandler otherHandler) {
        if (otherHandler == null) {
            throw new NullPointerException("Can't disconnect a null air handler!");
        }
        if (this.specialConnectedHandlers.remove(otherHandler)) {
            otherHandler.removeConnection(this);
        }
    }
}

