/*
 * Decompiled with CFR 0.152.
 */
package pneumaticCraft.common.tileentity;

import cpw.mods.fml.relauncher.Side;
import cpw.mods.fml.relauncher.SideOnly;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Stack;
import net.minecraft.block.Block;
import net.minecraft.entity.Entity;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.inventory.IInventory;
import net.minecraft.item.ItemBlock;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.nbt.NBTTagList;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.AxisAlignedBB;
import net.minecraft.world.ChunkPosition;
import net.minecraftforge.common.util.ForgeDirection;
import org.apache.commons.lang3.tuple.Pair;
import pneumaticCraft.api.tileentity.IAirHandler;
import pneumaticCraft.api.tileentity.IPneumaticMachine;
import pneumaticCraft.common.block.BlockElevatorBase;
import pneumaticCraft.common.block.Blockss;
import pneumaticCraft.common.config.Config;
import pneumaticCraft.common.item.Itemss;
import pneumaticCraft.common.network.DescSynced;
import pneumaticCraft.common.network.GuiSynced;
import pneumaticCraft.common.network.LazySynced;
import pneumaticCraft.common.network.PacketServerTickTime;
import pneumaticCraft.common.thirdparty.computercraft.LuaConstant;
import pneumaticCraft.common.thirdparty.computercraft.LuaMethod;
import pneumaticCraft.common.tileentity.IGUITextFieldSensitive;
import pneumaticCraft.common.tileentity.IMinWorkingPressure;
import pneumaticCraft.common.tileentity.IRedstoneControlled;
import pneumaticCraft.common.tileentity.TileEntityElevatorCaller;
import pneumaticCraft.common.tileentity.TileEntityPneumaticBase;
import pneumaticCraft.common.util.PneumaticCraftUtils;
import pneumaticCraft.lib.Log;

public class TileEntityElevatorBase
extends TileEntityPneumaticBase
implements IInventory,
IGUITextFieldSensitive,
IRedstoneControlled,
IMinWorkingPressure {
    @DescSynced
    public boolean[] sidesConnected = new boolean[6];
    public float oldExtension;
    @DescSynced
    @LazySynced
    public float extension;
    @DescSynced
    public float targetExtension;
    private int soundCounter;
    private boolean isStopped;
    private TileEntityElevatorBase coreElevator;
    private List<TileEntityElevatorBase> multiElevators;
    @GuiSynced
    public int redstoneMode;
    public int[] floorHeights = new int[0];
    private HashMap<Integer, String> floorNames = new HashMap();
    @GuiSynced
    private int maxFloorHeight;
    private int redstoneInputLevel;
    @DescSynced
    private ItemStack[] inventory = new ItemStack[6];
    public Block baseCamo;
    public Block frameCamo;
    public static final int UPGRADE_SLOT_1 = 0;
    public static final int UPGRADE_SLOT_4 = 3;

    public TileEntityElevatorBase() {
        super(5.0f, 7.0f, 10000);
        this.setUpgradeSlots(0, 1, 2, 3);
    }

    @Override
    public void func_145845_h() {
        this.oldExtension = this.extension;
        if (this.field_145850_b.field_72995_K && this.field_145850_b.func_82737_E() % 60L == 0L) {
            this.coreElevator = null;
        }
        if (this.isCoreElevator()) {
            super.func_145845_h();
            if (!this.field_145850_b.field_72995_K && this.isControlledByRedstone()) {
                float oldTargetExtension = this.targetExtension;
                float maxExtension = this.getMaxElevatorHeight();
                int redstoneInput = this.redstoneInputLevel;
                if (this.multiElevators != null) {
                    for (TileEntityElevatorBase base : this.multiElevators) {
                        redstoneInput = Math.max(this.redstoneInputLevel, base.redstoneInputLevel);
                    }
                }
                this.targetExtension = (float)redstoneInput * maxExtension / 15.0f;
                if (this.targetExtension > this.oldExtension && this.getPressure(ForgeDirection.UNKNOWN) < 3.0f) {
                    this.targetExtension = this.oldExtension;
                }
                if (oldTargetExtension != this.targetExtension) {
                    this.sendDescPacketFromAllElevators();
                }
            }
            float speedMultiplier = this.getSpeedMultiplierFromUpgrades(this.getUpgradeSlots());
            if (this.field_145850_b.field_72995_K) {
                speedMultiplier = (float)((double)speedMultiplier * PacketServerTickTime.tickTimeMultiplier);
            }
            String soundName = null;
            if (this.extension < this.targetExtension) {
                if (!this.field_145850_b.field_72995_K && this.getPressure(ForgeDirection.UNKNOWN) < 3.0f) {
                    this.targetExtension = this.extension;
                    this.sendDescPacket(256.0);
                }
                soundName = "pneumaticcraft:elevatorRising";
                float moveBy = this.extension < this.targetExtension - 0.5f ? 0.05f * speedMultiplier : 0.02f * speedMultiplier;
                if (this.extension + moveBy > this.targetExtension) {
                    this.extension = this.targetExtension;
                    if (!this.field_145850_b.field_72995_K) {
                        this.updateFloors();
                    }
                }
                if (this.isStopped) {
                    soundName = "pneumaticcraft:elevatorRisingStart";
                    this.isStopped = false;
                }
                float startingExtension = this.extension;
                while (this.extension < startingExtension + moveBy) {
                    this.extension += 0.02f;
                }
                this.addAir((int)((this.oldExtension - this.extension) * 300.0f * (this.getSpeedUsageMultiplierFromUpgrades(this.getUpgradeSlots()) / speedMultiplier)), ForgeDirection.UNKNOWN);
            }
            if (this.extension > this.targetExtension) {
                soundName = "pneumaticcraft:elevatorRising";
                this.extension = this.extension > this.targetExtension + 0.5f ? (this.extension -= 0.05f * speedMultiplier) : (this.extension -= 0.02f * speedMultiplier);
                if (this.extension < this.targetExtension) {
                    this.extension = this.targetExtension;
                    if (!this.field_145850_b.field_72995_K) {
                        this.updateFloors();
                    }
                }
                if (this.isStopped) {
                    soundName = "pneumaticcraft:elevatorRisingStart";
                    this.isStopped = false;
                }
            }
            if (this.oldExtension == this.extension && !this.isStopped) {
                soundName = "pneumaticcraft:elevatorRisingStop";
                this.isStopped = true;
                this.soundCounter = 0;
            }
            if (this.soundCounter > 0) {
                --this.soundCounter;
            }
            if (soundName != null && this.field_145850_b.field_72995_K && this.soundCounter == 0) {
                this.field_145850_b.func_72980_b((double)this.field_145851_c + 0.5, (double)this.field_145848_d + 0.5, (double)this.field_145849_e + 0.5, soundName, 0.1f, 1.0f, true);
                this.soundCounter = 10;
            }
        } else {
            this.extension = 0.0f;
        }
        if (!this.field_145850_b.field_72995_K && this.oldExtension != this.extension) {
            this.sendDescPacket(256.0);
        }
    }

    private void movePlayerDown() {
        if (!this.field_145850_b.field_72995_K) {
            return;
        }
        AxisAlignedBB aabb = AxisAlignedBB.func_72330_a((double)this.field_145851_c, (double)(this.field_145848_d + 1), (double)this.field_145849_e, (double)(this.field_145851_c + 1), (double)((float)this.field_145848_d + this.oldExtension + 1.05f), (double)(this.field_145849_e + 1));
        List entityList = this.field_145850_b.func_72839_b(null, aabb);
        for (Entity entity : entityList) {
            if (!(entity instanceof EntityPlayer)) continue;
            double posX = entity.field_70165_t;
            double posZ = entity.field_70161_v;
            if (!(posX >= (double)this.field_145851_c) || !(posX < (double)(this.field_145851_c + 1)) || !(posZ >= (double)this.field_145849_e) || !(posZ < (double)(this.field_145849_e + 1))) continue;
            entity.field_70159_w *= 0.6;
            entity.field_70179_y *= 0.6;
            entity.func_70091_d(0.0, (double)(this.extension - this.oldExtension + 0.001f), 0.0);
        }
    }

    private void moveEntities(float moveBy) {
        AxisAlignedBB aabb = AxisAlignedBB.func_72330_a((double)this.field_145851_c, (double)(this.field_145848_d + 1), (double)this.field_145849_e, (double)(this.field_145851_c + 1), (double)((float)this.field_145848_d + this.extension + 1.0f), (double)(this.field_145849_e + 1));
        List entityList = this.field_145850_b.func_72839_b(null, aabb);
        for (Entity entity : entityList) {
            if (entity instanceof EntityPlayer) continue;
            entity.func_70091_d(0.0, (double)(moveBy + 0.05f), 0.0);
        }
    }

    private void moveEntityToCenter(Entity entity) {
        ((EntityPlayer)entity).func_70107_b((double)((float)this.field_145851_c + 0.5f), entity.field_70163_u, (double)((float)this.field_145849_e + 0.5f));
    }

    @Override
    public void handleGUIButtonPress(int buttonID, EntityPlayer player) {
        if (buttonID == 0) {
            ++this.redstoneMode;
            if (this.redstoneMode > 1) {
                this.redstoneMode = 0;
            }
            if (this.multiElevators != null) {
                for (TileEntityElevatorBase base : this.multiElevators) {
                    while (base.redstoneMode != this.redstoneMode) {
                        base.handleGUIButtonPress(buttonID, player);
                    }
                }
            }
            int i = -1;
            TileEntity te = this.field_145850_b.func_147438_o(this.field_145851_c, this.field_145848_d - 1, this.field_145849_e);
            while (te instanceof TileEntityElevatorBase) {
                ((TileEntityElevatorBase)te).redstoneMode = this.redstoneMode;
                te = this.field_145850_b.func_147438_o(this.field_145851_c, this.field_145848_d + --i, this.field_145849_e);
            }
        }
    }

    private boolean isControlledByRedstone() {
        return this.redstoneMode == 0;
    }

    public void updateRedstoneInputLevel() {
        if (this.multiElevators == null) {
            return;
        }
        int maxRedstone = 0;
        for (TileEntityElevatorBase base : this.multiElevators) {
            int i = 0;
            while (this.field_145850_b.func_147439_a(base.field_145851_c, base.field_145848_d + i, base.field_145849_e) == Blockss.elevatorBase) {
                maxRedstone = Math.max(maxRedstone, PneumaticCraftUtils.getRedstoneLevel(this.field_145850_b, base.field_145851_c, base.field_145848_d + i, base.field_145849_e));
                --i;
            }
        }
        for (TileEntityElevatorBase base : this.multiElevators) {
            base.redstoneInputLevel = maxRedstone;
        }
    }

    public float getMaxElevatorHeight() {
        int max = this.maxFloorHeight;
        if (this.multiElevators != null) {
            for (TileEntityElevatorBase base : this.multiElevators) {
                max = Math.max(max, base.maxFloorHeight);
            }
        }
        return max;
    }

    public void updateMaxElevatorHeight() {
        int i = -1;
        while (this.field_145850_b.func_147439_a(this.field_145851_c, this.field_145848_d + ++i + 1, this.field_145849_e) == Blockss.elevatorFrame) {
        }
        int elevatorBases = 0;
        while (this.field_145850_b.func_147439_a(this.field_145851_c, this.field_145848_d - ++elevatorBases, this.field_145849_e) == Blockss.elevatorBase) {
        }
        this.maxFloorHeight = Math.min(i, elevatorBases * Config.elevatorBaseBlocksPerBase);
    }

    @Override
    public void func_145839_a(NBTTagCompound tag) {
        super.func_145839_a(tag);
        this.extension = tag.func_74760_g("extension");
        this.targetExtension = tag.func_74760_g("targetExtension");
        this.redstoneMode = tag.func_74762_e("redstoneMode");
        if (!tag.func_74764_b("maxFloorHeight")) {
            this.updateMaxElevatorHeight();
        } else {
            this.maxFloorHeight = tag.func_74762_e("maxFloorHeight");
        }
        for (int i = 0; i < 6; ++i) {
            this.sidesConnected[i] = tag.func_74767_n("sideConnected" + i);
        }
        NBTTagList tagList = tag.func_150295_c("Items", 10);
        this.inventory = new ItemStack[this.inventory.length];
        for (int i = 0; i < tagList.func_74745_c(); ++i) {
            NBTTagCompound tagCompound = tagList.func_150305_b(i);
            byte slot = tagCompound.func_74771_c("Slot");
            if (slot < 0 || slot >= this.inventory.length) continue;
            this.inventory[slot] = ItemStack.func_77949_a((NBTTagCompound)tagCompound);
        }
    }

    @Override
    public void func_145841_b(NBTTagCompound tag) {
        super.func_145841_b(tag);
        tag.func_74776_a("extension", this.extension);
        tag.func_74776_a("targetExtension", this.targetExtension);
        tag.func_74768_a("redstoneMode", this.redstoneMode);
        tag.func_74768_a("maxFloorHeight", this.maxFloorHeight);
        for (int i = 0; i < 6; ++i) {
            tag.func_74757_a("sideConnected" + i, this.sidesConnected[i]);
        }
        NBTTagList tagList = new NBTTagList();
        for (int currentIndex = 0; currentIndex < this.inventory.length; ++currentIndex) {
            if (this.inventory[currentIndex] == null) continue;
            NBTTagCompound tagCompound = new NBTTagCompound();
            tagCompound.func_74774_a("Slot", (byte)currentIndex);
            this.inventory[currentIndex].func_77955_b(tagCompound);
            tagList.func_74742_a((NBTBase)tagCompound);
        }
        tag.func_74782_a("Items", (NBTBase)tagList);
    }

    @Override
    public void readFromPacket(NBTTagCompound tag) {
        super.readFromPacket(tag);
        this.floorHeights = tag.func_74759_k("floorHeights");
        this.floorNames.clear();
        NBTTagList floorNameList = tag.func_150295_c("floorNames", 10);
        for (int i = 0; i < floorNameList.func_74745_c(); ++i) {
            NBTTagCompound floorName = floorNameList.func_150305_b(i);
            this.floorNames.put(floorName.func_74762_e("floorHeight"), floorName.func_74779_i("floorName"));
        }
    }

    @Override
    public void writeToPacket(NBTTagCompound tag) {
        super.writeToPacket(tag);
        tag.func_74783_a("floorHeights", this.floorHeights);
        NBTTagList floorNameList = new NBTTagList();
        for (int key : this.floorNames.keySet()) {
            NBTTagCompound floorNameTag = new NBTTagCompound();
            floorNameTag.func_74768_a("floorHeight", key);
            floorNameTag.func_74778_a("floorName", this.floorNames.get(key));
            floorNameList.func_74742_a((NBTBase)floorNameTag);
        }
        tag.func_74782_a("floorNames", (NBTBase)floorNameList);
    }

    @Override
    public void onNeighborTileUpdate() {
        super.onNeighborTileUpdate();
        this.updateConnections();
        this.connectAsMultiblock();
    }

    private void connectAsMultiblock() {
        this.multiElevators = null;
        if (this.isCoreElevator()) {
            this.multiElevators = new ArrayList<TileEntityElevatorBase>();
            Stack<TileEntityElevatorBase> todo = new Stack<TileEntityElevatorBase>();
            todo.add(this);
            while (!todo.isEmpty()) {
                TileEntityElevatorBase curElevator = (TileEntityElevatorBase)todo.pop();
                if (!curElevator.isCoreElevator()) continue;
                this.multiElevators.add(curElevator);
                curElevator.multiElevators = this.multiElevators;
                for (int i = 2; i < 6; ++i) {
                    TileEntity te = curElevator.getTileCache()[i].getTileEntity();
                    if (this.multiElevators.contains(te) || !(te instanceof TileEntityElevatorBase)) continue;
                    todo.push((TileEntityElevatorBase)te);
                }
            }
        }
    }

    @Override
    public void onNeighborBlockUpdate() {
        super.onNeighborBlockUpdate();
        this.getCoreElevator().updateRedstoneInputLevel();
    }

    public void updateConnections() {
        for (ForgeDirection direction : ForgeDirection.VALID_DIRECTIONS) {
            TileEntity te = this.field_145850_b.func_147438_o(this.field_145851_c + direction.offsetX, this.field_145848_d + direction.offsetY, this.field_145849_e + direction.offsetZ);
            this.sidesConnected[direction.ordinal()] = te instanceof IPneumaticMachine ? ((IPneumaticMachine)te).isConnectedTo(direction.getOpposite()) : false;
        }
        if (this.field_145850_b.func_147439_a(this.field_145851_c, this.field_145848_d + 1, this.field_145849_e) != Blockss.elevatorBase) {
            this.coreElevator = this;
            int i = -1;
            TileEntity te = this.field_145850_b.func_147438_o(this.field_145851_c, this.field_145848_d - 1, this.field_145849_e);
            while (te instanceof TileEntityElevatorBase) {
                ((TileEntityElevatorBase)te).coreElevator = this;
                te = this.field_145850_b.func_147438_o(this.field_145851_c, this.field_145848_d + --i, this.field_145849_e);
            }
        }
    }

    public void moveInventoryToThis() {
        TileEntity te = this.field_145850_b.func_147438_o(this.field_145851_c, this.field_145848_d + 1, this.field_145849_e);
        if (te instanceof TileEntityElevatorBase) {
            for (int i = 0; i < this.func_70302_i_(); ++i) {
                this.inventory[i] = ((TileEntityElevatorBase)te).inventory[i];
                ((TileEntityElevatorBase)te).inventory[i] = null;
            }
        }
    }

    public void updateFloors() {
        ArrayList<Integer> floorList = new ArrayList<Integer>();
        ArrayList<ChunkPosition> callerList = new ArrayList<ChunkPosition>();
        if (this.multiElevators != null) {
            int i = 0;
            boolean shouldBreak = false;
            block0: while (!shouldBreak) {
                boolean registeredThisFloor = false;
                for (TileEntityElevatorBase base : this.multiElevators) {
                    for (ForgeDirection dir : ForgeDirection.VALID_DIRECTIONS) {
                        if (dir == ForgeDirection.UP || dir == ForgeDirection.DOWN || base.field_145850_b.func_147439_a(base.field_145851_c + dir.offsetX, base.field_145848_d + i + 2, base.field_145849_e + dir.offsetZ) != Blockss.elevatorCaller) continue;
                        callerList.add(new ChunkPosition(base.field_145851_c + dir.offsetX, base.field_145848_d + i + 2, base.field_145849_e + dir.offsetZ));
                        if (!registeredThisFloor) {
                            floorList.add(i);
                        }
                        registeredThisFloor = true;
                    }
                }
                ++i;
                for (TileEntityElevatorBase base : this.multiElevators) {
                    if (base.field_145850_b.func_147439_a(base.field_145851_c, base.field_145848_d + i, base.field_145849_e) == Blockss.elevatorFrame) continue;
                    shouldBreak = true;
                    continue block0;
                }
            }
            for (TileEntityElevatorBase base : this.multiElevators) {
                base.floorHeights = new int[floorList.size()];
                for (i = 0; i < base.floorHeights.length; ++i) {
                    base.floorHeights[i] = (Integer)floorList.get(i);
                }
            }
        }
        double buttonHeight = 0.06;
        double buttonSpacing = 0.02;
        TileEntityElevatorCaller.ElevatorButton[] elevatorButtons = new TileEntityElevatorCaller.ElevatorButton[this.floorHeights.length];
        int columns = (elevatorButtons.length - 1) / 12 + 1;
        for (int j = 0; j < columns; ++j) {
            for (int i = j * 12; i < this.floorHeights.length && i < j * 12 + 12; ++i) {
                elevatorButtons[i] = new TileEntityElevatorCaller.ElevatorButton(0.2 + 0.6 / (double)columns * (double)j, 0.5 + (double)(Math.min(this.floorHeights.length, 12) - 2) * (buttonSpacing + buttonHeight) / 2.0 - (double)(i % 12) * (buttonHeight + buttonSpacing), 0.58 / (double)columns, buttonHeight, i, this.floorHeights[i]);
                elevatorButtons[i].setColor((float)this.floorHeights[i] == this.targetExtension ? 0.0f : 1.0f, 1.0f, (float)this.floorHeights[i] == this.targetExtension ? 0.0f : 1.0f);
                String floorName = this.floorNames.get(this.floorHeights[i]);
                if (floorName != null) {
                    elevatorButtons[i].buttonText = floorName;
                    continue;
                }
                this.floorNames.put(this.floorHeights[i], elevatorButtons[i].buttonText);
            }
        }
        if (this.multiElevators != null) {
            for (TileEntityElevatorBase base : this.multiElevators) {
                base.floorNames = new HashMap<Integer, String>(this.floorNames);
            }
        }
        for (ChunkPosition p : callerList) {
            TileEntity te = this.field_145850_b.func_147438_o(p.field_151329_a, p.field_151327_b, p.field_151328_c);
            if (!(te instanceof TileEntityElevatorCaller)) continue;
            int callerFloorHeight = p.field_151327_b - this.field_145848_d - 2;
            int callerFloor = -1;
            for (TileEntityElevatorCaller.ElevatorButton floor : elevatorButtons) {
                if (floor.floorHeight != callerFloorHeight) continue;
                callerFloor = floor.floorNumber;
                break;
            }
            if (callerFloor == -1) {
                Log.error("Error while updating elevator floors! This will cause a indexOutOfBoundsException, index = -1");
            }
            ((TileEntityElevatorCaller)te).setEmittingRedstone(PneumaticCraftUtils.areFloatsEqual(this.targetExtension, this.extension, 0.1f) && PneumaticCraftUtils.areFloatsEqual(this.extension, callerFloorHeight, 0.1f));
            ((TileEntityElevatorCaller)te).setFloors(elevatorButtons, callerFloor);
        }
    }

    public void goToFloor(int floor) {
        if (this.getCoreElevator().isControlledByRedstone()) {
            this.getCoreElevator().handleGUIButtonPress(0, null);
        }
        if (floor >= 0 && floor < this.floorHeights.length) {
            this.setTargetHeight(this.floorHeights[floor]);
        }
        this.updateFloors();
        this.sendDescPacketFromAllElevators();
    }

    private void setTargetHeight(float height) {
        height = Math.min(height, this.getMaxElevatorHeight());
        if (this.multiElevators != null) {
            for (TileEntityElevatorBase base : this.multiElevators) {
                base.targetExtension = height;
            }
        }
    }

    @Override
    public void onDescUpdate() {
        Block newFrameCamo;
        this.baseCamo = this.inventory[4] != null && this.inventory[4].func_77973_b() instanceof ItemBlock ? ((ItemBlock)this.inventory[4].func_77973_b()).field_150939_a : null;
        Block block = newFrameCamo = this.inventory[5] != null && this.inventory[5].func_77973_b() instanceof ItemBlock ? ((ItemBlock)this.inventory[5].func_77973_b()).field_150939_a : null;
        if (newFrameCamo != this.frameCamo) {
            this.frameCamo = newFrameCamo;
            this.rerenderChunk();
        }
    }

    private void sendDescPacketFromAllElevators() {
        if (this.multiElevators != null) {
            for (TileEntityElevatorBase base : this.multiElevators) {
                base.sendDescPacket(256.0);
            }
        } else {
            this.sendDescPacket(256.0);
        }
    }

    public int func_70302_i_() {
        return this.getCoreElevator().inventory.length;
    }

    public ItemStack func_70301_a(int slot) {
        return this.getCoreElevator().inventory[slot];
    }

    public ItemStack getRealStackInSlot(int slot) {
        return this.inventory[slot];
    }

    public ItemStack func_70298_a(int slot, int amount) {
        ItemStack itemStack = this.func_70301_a(slot);
        if (itemStack != null) {
            if (itemStack.field_77994_a <= amount) {
                this.func_70299_a(slot, null);
            } else {
                itemStack = itemStack.func_77979_a(amount);
                if (itemStack.field_77994_a == 0) {
                    this.func_70299_a(slot, null);
                }
            }
        }
        return itemStack;
    }

    public ItemStack func_70304_b(int slot) {
        ItemStack itemStack = this.func_70301_a(slot);
        if (itemStack != null) {
            this.func_70299_a(slot, null);
        }
        return itemStack;
    }

    public void func_70299_a(int slot, ItemStack itemStack) {
        this.getCoreElevator().inventory[slot] = itemStack;
        if (itemStack != null && itemStack.field_77994_a > this.func_70297_j_()) {
            itemStack.field_77994_a = this.func_70297_j_();
        }
    }

    public int func_70297_j_() {
        return 64;
    }

    public String func_145825_b() {
        return Blockss.elevatorBase.func_149739_a();
    }

    public void func_70295_k_() {
    }

    public void func_70305_f() {
    }

    public boolean func_94041_b(int i, ItemStack itemstack) {
        return itemstack.func_77973_b() == Itemss.machineUpgrade && i < 4 || itemstack.func_77973_b() instanceof ItemBlock && i >= 4;
    }

    public boolean func_70300_a(EntityPlayer var1) {
        return this.isGuiUseableByPlayer(var1);
    }

    public AxisAlignedBB getRenderBoundingBox() {
        return AxisAlignedBB.func_72330_a((double)this.field_145851_c, (double)this.field_145848_d, (double)this.field_145849_e, (double)(this.field_145851_c + 1), (double)((float)(this.field_145848_d + 1) + this.extension), (double)(this.field_145849_e + 1));
    }

    @Override
    protected double getPacketDistance() {
        return 256.0;
    }

    @SideOnly(value=Side.CLIENT)
    public double func_145833_n() {
        return 65536.0;
    }

    private TileEntityElevatorBase getCoreElevator() {
        if (this.coreElevator == null) {
            this.coreElevator = BlockElevatorBase.getCoreTileEntity(this.field_145850_b, this.field_145851_c, this.field_145848_d, this.field_145849_e);
        }
        return this.coreElevator;
    }

    public boolean isCoreElevator() {
        return this.getCoreElevator() == this;
    }

    @Override
    public boolean isConnectedTo(ForgeDirection side) {
        return side != ForgeDirection.UP && side != ForgeDirection.DOWN || this.field_145850_b.func_147439_a(this.field_145851_c, this.field_145848_d + side.offsetY, this.field_145849_e) != Blockss.elevatorBase;
    }

    @Override
    public void addAir(int amount, ForgeDirection side) {
        if (this.isCoreElevator()) {
            super.addAir(amount, side);
        } else {
            this.getCoreElevator().addAir(amount, side);
        }
    }

    @Override
    public float getPressure(ForgeDirection sideRequested) {
        if (this.isCoreElevator()) {
            return super.getPressure(sideRequested);
        }
        return this.getCoreElevator().getPressure(sideRequested);
    }

    @Override
    public int getCurrentAir(ForgeDirection sideRequested) {
        if (this.isCoreElevator()) {
            return super.getCurrentAir(sideRequested);
        }
        return this.getCoreElevator().getCurrentAir(sideRequested);
    }

    @Override
    public List<Pair<ForgeDirection, IAirHandler>> getConnectedPneumatics() {
        List<Pair<ForgeDirection, IAirHandler>> connectedMachines = super.getConnectedPneumatics();
        TileEntity te = this.getTileCache()[ForgeDirection.DOWN.ordinal()].getTileEntity();
        if (te instanceof TileEntityElevatorBase) {
            connectedMachines.addAll(((TileEntityElevatorBase)te).getConnectedPneumatics());
        }
        return connectedMachines;
    }

    @Override
    public void setText(int textFieldID, String text) {
        this.setFloorName(textFieldID, text);
    }

    @Override
    public String getText(int textFieldID) {
        return this.getFloorName(textFieldID);
    }

    public String getFloorName(int floor) {
        return floor < this.floorHeights.length ? this.floorNames.get(this.floorHeights[floor]) : "";
    }

    public void setFloorName(int floor, String name) {
        if (floor < this.floorHeights.length) {
            this.floorNames.put(this.floorHeights[floor], name);
            this.updateFloors();
        }
    }

    @Override
    public boolean isGuiUseableByPlayer(EntityPlayer par1EntityPlayer) {
        return this.field_145850_b.func_147438_o(this.field_145851_c, this.field_145848_d, this.field_145849_e) == this;
    }

    public boolean func_145818_k_() {
        return false;
    }

    @Override
    public String getType() {
        return "elevator";
    }

    @Override
    protected void addLuaMethods() {
        super.addLuaMethods();
        this.luaMethods.add(new LuaConstant("getMinWorkingPressure", 3.0f));
        this.luaMethods.add(new LuaMethod("setHeight"){

            @Override
            public Object[] call(Object[] args) throws Exception {
                if (args.length == 1) {
                    TileEntityElevatorBase.this.setTargetHeight(((Double)args[0]).floatValue());
                    if (TileEntityElevatorBase.this.getCoreElevator().isControlledByRedstone()) {
                        TileEntityElevatorBase.this.getCoreElevator().handleGUIButtonPress(0, null);
                    }
                    TileEntityElevatorBase.this.getCoreElevator().sendDescPacketFromAllElevators();
                    return null;
                }
                throw new IllegalArgumentException("setHeight does take one argument (height)");
            }
        });
        this.luaMethods.add(new LuaMethod("setExternalControl"){

            @Override
            public Object[] call(Object[] args) throws Exception {
                if (args.length == 1) {
                    if (((Boolean)args[0]).booleanValue() && TileEntityElevatorBase.this.getCoreElevator().isControlledByRedstone() || !((Boolean)args[0]).booleanValue() && !TileEntityElevatorBase.this.getCoreElevator().isControlledByRedstone()) {
                        TileEntityElevatorBase.this.getCoreElevator().handleGUIButtonPress(0, null);
                    }
                    return null;
                }
                throw new IllegalArgumentException("setExternalControl does take one argument! (bool)");
            }
        });
    }

    @Override
    public int getRedstoneMode() {
        return this.redstoneMode;
    }

    @Override
    public float getMinWorkingPressure() {
        return 3.0f;
    }
}

