/*
 * Decompiled with CFR 0.152.
 */
package pneumaticCraft.common.tileentity;

import java.util.List;
import net.minecraft.inventory.IInventory;
import net.minecraft.inventory.ISidedInventory;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.nbt.NBTTagList;
import net.minecraft.tileentity.TileEntity;
import net.minecraftforge.common.util.ForgeDirection;
import pneumaticCraft.api.recipe.AssemblyRecipe;
import pneumaticCraft.common.network.DescSynced;
import pneumaticCraft.common.network.LazySynced;
import pneumaticCraft.common.tileentity.TileEntityAssemblyPlatform;
import pneumaticCraft.common.tileentity.TileEntityAssemblyRobot;
import pneumaticCraft.common.util.IOHelper;
import pneumaticCraft.common.util.PneumaticCraftUtils;

public class TileEntityAssemblyIOUnit
extends TileEntityAssemblyRobot {
    @DescSynced
    public boolean shouldClawClose;
    @DescSynced
    @LazySynced
    public float clawProgress;
    public float oldClawProgress;
    @DescSynced
    public ItemStack[] inventory = new ItemStack[1];
    private List<AssemblyRecipe> recipeList;
    private ItemStack searchedItemStack;
    private byte state = 0;
    private byte tickCounter = 0;
    private boolean hasSwitchedThisTick;
    private static final byte SLEEP_TICKS = 50;
    private static final byte STATE_IDLE = 0;
    private static final byte STATE_SEARCH_SRC = 1;
    private static final byte STATE_CLOSECLAW_AFTER_PICKUP = 5;
    private static final byte STATE_RESET_CLOSECLAW_AFTER_PICKUP = 20;
    private static final byte STATE_RESET_GOTO_IDLE = 26;
    private static final byte STATE_MAX = 127;

    @Override
    public void func_145845_h() {
        super.func_145845_h();
        this.hasSwitchedThisTick = false;
        if (this.field_145850_b.field_72995_K) {
            if (!this.isClawDone()) {
                this.moveClaw();
            }
        } else {
            this.slowMode = false;
            switch (this.state) {
                case 0: {
                    break;
                }
                case 1: {
                    if (!this.findPickupLocation()) break;
                    this.state = (byte)(this.state + 1);
                    break;
                }
                case 2: 
                case 7: 
                case 22: {
                    if (!this.hoverOverTarget()) break;
                    this.state = (byte)(this.state + 1);
                    break;
                }
                case 3: 
                case 8: 
                case 23: {
                    this.slowMode = true;
                    if (!this.gotoTarget()) break;
                    this.state = (byte)(this.state + 1);
                    break;
                }
                case 4: {
                    if (!this.getItemFromCurrentDirection()) break;
                    this.state = (byte)(this.state + 1);
                    break;
                }
                case 5: 
                case 20: {
                    if (!this.closeClaw()) break;
                    this.state = (byte)(this.state + 1);
                    break;
                }
                case 6: 
                case 21: {
                    if (!this.findDropOffLocation()) break;
                    this.state = (byte)(this.state + 1);
                    break;
                }
                case 9: 
                case 24: {
                    if (!this.openClaw()) break;
                    this.state = (byte)(this.state + 1);
                    break;
                }
                case 10: 
                case 25: {
                    if (!this.putItemToCurrentDirection()) break;
                    this.state = (byte)(this.state + 1);
                    break;
                }
                case 11: 
                case 26: {
                    if (this.gotoIdlePos()) {
                        this.state = 0;
                    }
                }
                case 127: {
                    break;
                }
                default: {
                    System.out.printf("unexpected state: %d%n", this.state);
                    this.state = (byte)127;
                }
            }
        }
    }

    @Override
    public boolean reset() {
        if (this.state >= 20) {
            return false;
        }
        if (this.inventory[0] != null) {
            this.state = (byte)20;
            return false;
        }
        if (this.state == 0) {
            return true;
        }
        this.state = (byte)26;
        return this.isIdle();
    }

    public boolean pickupItem(List<AssemblyRecipe> list) {
        this.recipeList = list;
        if (this.state == 0) {
            this.state = (byte)(this.state + 1);
        }
        return this.state > 0 && !this.isSleeping() && this.state < 127;
    }

    private boolean gotoIdlePos() {
        this.gotoHomePosition();
        return this.isDoneInternal();
    }

    private boolean findPickupLocation() {
        if (this.shouldSleep()) {
            return false;
        }
        ForgeDirection[] inventoryDir = null;
        if (this.isImportUnit()) {
            this.searchedItemStack = null;
            if (this.recipeList != null) {
                for (AssemblyRecipe recipe : this.recipeList) {
                    inventoryDir = this.getInventoryDirectionForItem(recipe.getInput());
                    if (inventoryDir == null) continue;
                    this.searchedItemStack = recipe.getInput();
                    break;
                }
            }
        } else {
            inventoryDir = this.getPlatformDirection();
        }
        this.targetDirection = inventoryDir;
        if (this.targetDirection == null) {
            this.sleepBeforeNextSearch();
            return false;
        }
        return true;
    }

    private boolean isSleeping() {
        return this.tickCounter > 0;
    }

    private boolean shouldSleep() {
        if (this.tickCounter > 0) {
            byte by = this.tickCounter;
            this.tickCounter = (byte)(by + 1);
            if (by < 50) {
                return true;
            }
        }
        this.tickCounter = 0;
        return false;
    }

    private void sleepBeforeNextSearch() {
        this.tickCounter = 1;
    }

    private boolean findDropOffLocation() {
        if (this.shouldSleep()) {
            return false;
        }
        ForgeDirection[] inventoryDir = null;
        inventoryDir = this.isImportUnit() ? this.getPlatformDirection() : this.getExportLocationForItem(this.inventory[0]);
        this.targetDirection = inventoryDir;
        if (this.targetDirection == null) {
            this.sleepBeforeNextSearch();
            return false;
        }
        return true;
    }

    private boolean getItemFromCurrentDirection() {
        TileEntityAssemblyPlatform plat;
        TileEntity tile = this.getTileEntityForCurrentDirection();
        boolean extracted = false;
        if (this.isImportUnit()) {
            if (this.searchedItemStack == null) {
                this.reset();
            } else if (tile instanceof IInventory) {
                IInventory inv = (IInventory)tile;
                int oldStackSize = this.inventory[0] == null ? 0 : this.inventory[0].field_77994_a;
                for (int i = 0; i < inv.func_70302_i_(); ++i) {
                    if (inv.func_70301_a(i) == null) continue;
                    if (this.inventory[0] == null) {
                        if (inv.func_70301_a(i).func_77969_a(this.searchedItemStack)) {
                            this.inventory[0] = inv.func_70298_a(i, 1);
                        }
                    } else if (inv.func_70301_a(i).func_77969_a(this.inventory[0])) {
                        inv.func_70298_a(i, 1);
                        ++this.inventory[0].field_77994_a;
                    }
                    boolean bl = extracted = (this.inventory[0] == null ? 0 : this.inventory[0].field_77994_a) == this.searchedItemStack.field_77994_a;
                    if (extracted) break;
                }
                if (oldStackSize == (this.inventory[0] == null ? 0 : this.inventory[0].field_77994_a)) {
                    this.state = 1;
                }
            } else {
                this.state = 1;
            }
        } else if (tile instanceof TileEntityAssemblyPlatform && (plat = (TileEntityAssemblyPlatform)tile).openClaw()) {
            this.inventory[0] = plat.getHeldStack();
            plat.setHeldStack(null);
            boolean bl = extracted = this.inventory[0] != null;
            if (!extracted) {
                this.state = 1;
            }
        }
        return extracted;
    }

    private boolean putItemToCurrentDirection() {
        if (this.isImportUnit()) {
            TileEntity tile = this.getTileEntityForCurrentDirection();
            if (tile instanceof TileEntityAssemblyPlatform) {
                TileEntityAssemblyPlatform plat = (TileEntityAssemblyPlatform)tile;
                if (this.inventory[0] == null) {
                    return plat.closeClaw();
                }
                if (plat.isIdle()) {
                    plat.setHeldStack(this.inventory[0]);
                    this.inventory[0] = null;
                    return plat.closeClaw();
                }
            } else {
                this.repeatDropOffSearch();
            }
        } else {
            IInventory inv = this.getInventoryForCurrentDirection();
            if (inv == null) {
                this.repeatDropOffSearch();
            } else {
                int startSize = this.inventory[0].field_77994_a;
                for (int i = 0; i < 6; ++i) {
                    this.inventory[0] = PneumaticCraftUtils.exportStackToInventory(inv, this.inventory[0], ForgeDirection.getOrientation((int)i));
                    if (this.inventory[0] == null) break;
                }
                if (this.inventory[0] == null || startSize != this.inventory[0].field_77994_a) {
                    this.sendDescriptionPacket();
                }
                if (this.inventory[0] != null && startSize == this.inventory[0].field_77994_a) {
                    this.repeatDropOffSearch();
                }
            }
            return this.inventory[0] == null;
        }
        return false;
    }

    private void repeatDropOffSearch() {
        this.state = (byte)(this.state >= 20 ? 20 : 5);
    }

    private boolean closeClaw() {
        this.shouldClawClose = true;
        return this.moveClaw();
    }

    private boolean openClaw() {
        this.shouldClawClose = false;
        return this.moveClaw();
    }

    private boolean moveClaw() {
        this.oldClawProgress = this.clawProgress;
        if (!this.shouldClawClose && this.clawProgress > 0.0f) {
            this.clawProgress = Math.max(this.clawProgress - 0.05f * this.speed, 0.0f);
        } else if (this.shouldClawClose && this.clawProgress < 1.0f) {
            this.clawProgress = Math.min(this.clawProgress + 0.05f * this.speed, 1.0f);
        }
        return this.isClawDone();
    }

    private boolean isClawDone() {
        return this.clawProgress == this.oldClawProgress && this.clawProgress == (this.shouldClawClose ? 1.0f : 0.0f);
    }

    private boolean isImportUnit() {
        return this.func_145832_p() == 0;
    }

    public IInventory getInventoryForCurrentDirection() {
        TileEntity te = this.getTileEntityForCurrentDirection();
        if (te instanceof IInventory) {
            return (IInventory)te;
        }
        return null;
    }

    public boolean switchMode() {
        if (this.state <= 1) {
            if (!this.hasSwitchedThisTick) {
                this.field_145850_b.func_72921_c(this.field_145851_c, this.field_145848_d, this.field_145849_e, 1 - this.func_145832_p(), 3);
                this.hasSwitchedThisTick = true;
            }
            return true;
        }
        return false;
    }

    @Override
    public void gotoHomePosition() {
        super.gotoHomePosition();
        if (this.isClawDone()) {
            this.openClaw();
        }
    }

    @Override
    public boolean isIdle() {
        return this.state == 0;
    }

    private boolean isDoneInternal() {
        return super.isDoneMoving();
    }

    public ForgeDirection[] getInventoryDirectionForItem(ItemStack searchedItem) {
        if (searchedItem != null && (this.inventory[0] == null || this.inventory[0].func_77969_a(searchedItem))) {
            for (ForgeDirection dir : ForgeDirection.VALID_DIRECTIONS) {
                TileEntity te;
                if (dir == ForgeDirection.UP || dir == ForgeDirection.DOWN || !((te = this.field_145850_b.func_147438_o(this.field_145851_c + dir.offsetX, this.field_145848_d, this.field_145849_e + dir.offsetZ)) instanceof IInventory) || IOHelper.extract(te, ForgeDirection.UP, searchedItem, true, true) == null) continue;
                return new ForgeDirection[]{dir, ForgeDirection.UNKNOWN};
            }
            if (this.canMoveToDiagonalNeighbours()) {
                for (ForgeDirection secDir : new ForgeDirection[]{ForgeDirection.WEST, ForgeDirection.EAST}) {
                    for (ForgeDirection primDir : new ForgeDirection[]{ForgeDirection.NORTH, ForgeDirection.SOUTH}) {
                        TileEntity te = this.field_145850_b.func_147438_o(this.field_145851_c + primDir.offsetX + secDir.offsetX, this.field_145848_d, this.field_145849_e + primDir.offsetZ + secDir.offsetZ);
                        if (!(te instanceof IInventory) || IOHelper.extract(te, ForgeDirection.UP, searchedItem, true, true) == null) continue;
                        return new ForgeDirection[]{primDir, secDir};
                    }
                }
            }
        }
        return null;
    }

    public IInventory getInventory(ItemStack searchedItem) {
        ForgeDirection[] inventoryDir = this.getInventoryDirectionForItem(searchedItem);
        return (IInventory)this.field_145850_b.func_147438_o(this.field_145851_c + inventoryDir[0].offsetX + inventoryDir[1].offsetX, this.field_145848_d, this.field_145849_e + inventoryDir[0].offsetZ + inventoryDir[1].offsetZ);
    }

    public ForgeDirection[] getExportLocationForItem(ItemStack exportedItem) {
        if (exportedItem != null) {
            for (ForgeDirection dir : ForgeDirection.VALID_DIRECTIONS) {
                int slot;
                TileEntity te;
                if (dir == ForgeDirection.UP || dir == ForgeDirection.DOWN || !((te = this.field_145850_b.func_147438_o(this.field_145851_c + dir.offsetX, this.field_145848_d, this.field_145849_e + dir.offsetZ)) instanceof IInventory) || (slot = TileEntityAssemblyIOUnit.getInventoryPlaceLocation(exportedItem, (IInventory)te)) < 0) continue;
                return new ForgeDirection[]{dir, ForgeDirection.UNKNOWN};
            }
            if (this.canMoveToDiagonalNeighbours()) {
                for (ForgeDirection secDir : new ForgeDirection[]{ForgeDirection.WEST, ForgeDirection.EAST}) {
                    for (ForgeDirection primDir : new ForgeDirection[]{ForgeDirection.NORTH, ForgeDirection.SOUTH}) {
                        int slot;
                        TileEntity te = this.field_145850_b.func_147438_o(this.field_145851_c + primDir.offsetX + secDir.offsetX, this.field_145848_d, this.field_145849_e + primDir.offsetZ + secDir.offsetZ);
                        if (!(te instanceof IInventory) || (slot = TileEntityAssemblyIOUnit.getInventoryPlaceLocation(exportedItem, (IInventory)te)) < 0) continue;
                        return new ForgeDirection[]{primDir, secDir};
                    }
                }
            }
        }
        return null;
    }

    public static int getInventoryPlaceLocation(ItemStack exportedItem, IInventory inventory) {
        if (inventory instanceof ISidedInventory) {
            int[] slotsInTop;
            for (int slot : slotsInTop = ((ISidedInventory)inventory).func_94128_d(ForgeDirection.UP.ordinal())) {
                ItemStack stack;
                if (!inventory.func_94041_b(slot, exportedItem) || (stack = inventory.func_70301_a(slot)) != null && (!stack.func_77969_a(exportedItem) || stack.func_77976_d() <= stack.field_77994_a)) continue;
                return slot;
            }
        } else {
            for (int slot = 0; slot < inventory.func_70302_i_(); ++slot) {
                ItemStack stack;
                if (!inventory.func_94041_b(slot, exportedItem) || (stack = inventory.func_70301_a(slot)) != null && (!stack.func_77969_a(exportedItem) || stack.func_77976_d() <= stack.field_77994_a)) continue;
                return slot;
            }
        }
        return -1;
    }

    public IInventory getExportInventory(ItemStack exportedItem) {
        ForgeDirection[] inventoryDir = this.getExportLocationForItem(exportedItem);
        return (IInventory)this.field_145850_b.func_147438_o(this.field_145851_c + inventoryDir[0].offsetX + inventoryDir[1].offsetX, this.field_145848_d, this.field_145849_e + inventoryDir[0].offsetZ + inventoryDir[1].offsetZ);
    }

    @Override
    public void func_145839_a(NBTTagCompound tag) {
        super.func_145839_a(tag);
        this.clawProgress = tag.func_74760_g("clawProgress");
        this.shouldClawClose = tag.func_74767_n("clawClosing");
        this.state = tag.func_74771_c("state");
        NBTTagList tagList = tag.func_150295_c("Items", 10);
        this.inventory = new ItemStack[1];
        for (int i = 0; i < tagList.func_74745_c(); ++i) {
            NBTTagCompound tagCompound = tagList.func_150305_b(i);
            byte slot = tagCompound.func_74771_c("Slot");
            if (slot < 0 || slot >= this.inventory.length) continue;
            this.inventory[slot] = ItemStack.func_77949_a((NBTTagCompound)tagCompound);
        }
    }

    @Override
    public void func_145841_b(NBTTagCompound tag) {
        super.func_145841_b(tag);
        tag.func_74776_a("clawProgress", this.clawProgress);
        tag.func_74757_a("clawClosing", this.shouldClawClose);
        tag.func_74774_a("state", this.state);
        NBTTagList tagList = new NBTTagList();
        for (int currentIndex = 0; currentIndex < this.inventory.length; ++currentIndex) {
            if (this.inventory[currentIndex] == null) continue;
            NBTTagCompound tagCompound = new NBTTagCompound();
            tagCompound.func_74774_a("Slot", (byte)currentIndex);
            this.inventory[currentIndex].func_77955_b(tagCompound);
            tagList.func_74742_a((NBTBase)tagCompound);
        }
        tag.func_74782_a("Items", (NBTBase)tagList);
    }

    @Override
    public boolean canMoveToDiagonalNeighbours() {
        return true;
    }
}

