/*
 * Decompiled with CFR 0.152.
 */
package pneumaticCraft.common.progwidgets;

import cpw.mods.fml.relauncher.Side;
import cpw.mods.fml.relauncher.SideOnly;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import net.minecraft.client.gui.GuiScreen;
import net.minecraft.entity.ai.EntityAIBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.util.ResourceLocation;
import net.minecraft.world.ChunkPosition;
import pneumaticCraft.client.gui.GuiProgrammer;
import pneumaticCraft.client.gui.programmer.GuiProgWidgetForEach;
import pneumaticCraft.common.ai.DroneAIForEachCoordinate;
import pneumaticCraft.common.ai.IDroneBase;
import pneumaticCraft.common.progwidgets.IJump;
import pneumaticCraft.common.progwidgets.IJumpBackWidget;
import pneumaticCraft.common.progwidgets.IProgWidget;
import pneumaticCraft.common.progwidgets.IVariableSetWidget;
import pneumaticCraft.common.progwidgets.ProgWidgetArea;
import pneumaticCraft.common.progwidgets.ProgWidgetAreaItemBase;
import pneumaticCraft.common.progwidgets.ProgWidgetJump;
import pneumaticCraft.common.progwidgets.ProgWidgetString;
import pneumaticCraft.lib.Textures;

public class ProgWidgetForEachCoordinate
extends ProgWidgetAreaItemBase
implements IJumpBackWidget,
IJump,
IVariableSetWidget {
    private String elementVariable = "";
    private final Set<ChunkPosition> traversedPositions = new HashSet<ChunkPosition>();
    private DroneAIForEachCoordinate ai;

    @Override
    public String getWidgetString() {
        return "forEachCoordinate";
    }

    @Override
    public int getCraftingColorIndex() {
        return 11;
    }

    @Override
    protected ResourceLocation getTexture() {
        return Textures.PROG_WIDGET_FOR_EACH_COORDINATE;
    }

    @Override
    public Class<? extends IProgWidget>[] getParameters() {
        return new Class[]{ProgWidgetArea.class, ProgWidgetString.class};
    }

    @Override
    public void addVariables(Set<String> variables) {
        super.addVariables(variables);
        variables.add(this.elementVariable);
    }

    @Override
    public String getVariable() {
        return this.elementVariable;
    }

    @Override
    public void setVariable(String variable) {
        this.elementVariable = variable;
    }

    @Override
    public void writeToNBT(NBTTagCompound tag) {
        tag.func_74778_a("variable", this.elementVariable);
        super.writeToNBT(tag);
    }

    @Override
    public void readFromNBT(NBTTagCompound tag) {
        this.elementVariable = tag.func_74779_i("variable");
        super.readFromNBT(tag);
    }

    @Override
    public IProgWidget.WidgetDifficulty getDifficulty() {
        return IProgWidget.WidgetDifficulty.ADVANCED;
    }

    @Override
    public IProgWidget getOutputWidget(IDroneBase drone, List<IProgWidget> allWidgets) {
        ChunkPosition pos;
        List<String> locations = this.getPossibleJumpLocations();
        if (!(locations.size() <= 0 || this.ai == null || this.traversedPositions.size() != 1 && this.aiManager.getCoordinate(this.elementVariable).equals((Object)new ChunkPosition(0, 0, 0)) || (pos = this.ai.getCurCoord()) == null)) {
            this.aiManager.setCoordinate(this.elementVariable, pos);
            return ProgWidgetJump.jumpToLabel(drone, allWidgets, locations.get(0));
        }
        this.traversedPositions.clear();
        return super.getOutputWidget(drone, allWidgets);
    }

    @Override
    public List<String> getPossibleJumpLocations() {
        IProgWidget widget = this.getConnectedParameters()[this.getParameters().length - 1];
        ProgWidgetString textWidget = widget != null ? (ProgWidgetString)widget : null;
        ArrayList<String> locations = new ArrayList<String>();
        if (textWidget != null) {
            locations.add(textWidget.string);
        }
        return locations;
    }

    @Override
    public EntityAIBase getWidgetAI(IDroneBase drone, IProgWidget widget) {
        this.ai = new DroneAIForEachCoordinate(drone, (ProgWidgetForEachCoordinate)widget);
        return this.ai;
    }

    public boolean isValidPosition(ChunkPosition pos) {
        return this.traversedPositions.add(pos);
    }

    @Override
    public boolean canBeRunByComputers(IDroneBase drone, IProgWidget widget) {
        return false;
    }

    @Override
    @SideOnly(value=Side.CLIENT)
    public GuiScreen getOptionWindow(GuiProgrammer guiProgrammer) {
        return new GuiProgWidgetForEach(this, guiProgrammer);
    }

    @Override
    public String getExtraStringInfo() {
        return "\"" + this.elementVariable + "\"";
    }

    @Override
    public boolean canSetParameter(int index) {
        return index != 2;
    }
}

