/*
 * Decompiled with CFR 0.152.
 */
package pneumaticCraft.common.network;

import io.netty.buffer.ByteBuf;
import net.minecraft.entity.Entity;
import net.minecraft.entity.player.EntityPlayer;
import pneumaticCraft.common.entity.EntityRing;
import pneumaticCraft.common.network.LocationDoublePacket;

public class PacketSpawnRing
extends LocationDoublePacket<PacketSpawnRing> {
    private int[] colors;
    private int targetEntityId;

    public PacketSpawnRing() {
    }

    public PacketSpawnRing(double x, double y, double z, Entity targetEntity, int ... colors) {
        super(x, y, z);
        this.targetEntityId = targetEntity.func_145782_y();
        this.colors = colors;
    }

    @Override
    public void toBytes(ByteBuf buffer) {
        super.toBytes(buffer);
        buffer.writeInt(this.targetEntityId);
        buffer.writeInt(this.colors.length);
        for (int i : this.colors) {
            buffer.writeInt(i);
        }
    }

    @Override
    public void fromBytes(ByteBuf buffer) {
        super.fromBytes(buffer);
        this.targetEntityId = buffer.readInt();
        this.colors = new int[buffer.readInt()];
        for (int i = 0; i < this.colors.length; ++i) {
            this.colors[i] = buffer.readInt();
        }
    }

    @Override
    public void handleClientSide(PacketSpawnRing message, EntityPlayer player) {
        Entity entity = player.field_70170_p.func_73045_a(message.targetEntityId);
        if (entity != null) {
            for (int color : message.colors) {
                player.field_70170_p.func_72838_d((Entity)new EntityRing(player.field_70170_p, message.x, message.y, message.z, entity, color));
            }
        }
    }

    @Override
    public void handleServerSide(PacketSpawnRing message, EntityPlayer player) {
    }
}

