/*
 * Decompiled with CFR 0.152.
 */
package pneumaticCraft.common.network;

import cpw.mods.fml.common.network.ByteBufUtils;
import io.netty.buffer.ByteBuf;
import net.minecraft.entity.player.EntityPlayer;
import pneumaticCraft.common.network.AbstractPacket;

public class PacketAddChatMessage
extends AbstractPacket<PacketAddChatMessage> {
    private String message;
    private String[] replacements;

    public PacketAddChatMessage() {
    }

    public PacketAddChatMessage(String message, String ... replacements) {
        this.message = message;
        this.replacements = replacements;
    }

    public void toBytes(ByteBuf buffer) {
        ByteBufUtils.writeUTF8String((ByteBuf)buffer, (String)this.message);
        if (this.replacements != null) {
            buffer.writeInt(this.replacements.length);
            for (String replacement : this.replacements) {
                ByteBufUtils.writeUTF8String((ByteBuf)buffer, (String)replacement);
            }
        } else {
            buffer.writeInt(0);
        }
    }

    public void fromBytes(ByteBuf buffer) {
        this.message = ByteBufUtils.readUTF8String((ByteBuf)buffer);
        this.replacements = new String[buffer.readInt()];
        for (int i = 0; i < this.replacements.length; ++i) {
            this.replacements[i] = ByteBufUtils.readUTF8String((ByteBuf)buffer);
        }
    }

    @Override
    public void handleClientSide(PacketAddChatMessage message, EntityPlayer player) {
    }

    @Override
    public void handleServerSide(PacketAddChatMessage message, EntityPlayer player) {
    }
}

