/*
 * Decompiled with CFR 0.152.
 */
package pneumaticCraft.common;

import cpw.mods.fml.common.eventhandler.SubscribeEvent;
import cpw.mods.fml.common.gameevent.TickEvent;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import net.minecraft.block.Block;
import net.minecraft.entity.Entity;
import net.minecraft.world.World;
import pneumaticCraft.api.client.pneumaticHelmet.IHackableBlock;
import pneumaticCraft.api.client.pneumaticHelmet.IHackableEntity;
import pneumaticCraft.client.render.pneumaticArmor.hacking.HackableHandler;
import pneumaticCraft.common.PneumaticCraftAPIHandler;
import pneumaticCraft.common.util.WorldAndCoord;
import pneumaticCraft.lib.Log;

public class HackTickHandler {
    private final Map<WorldAndCoord, IHackableBlock> hackedBlocks = new HashMap<WorldAndCoord, IHackableBlock>();

    @SubscribeEvent
    public void onServerTick(TickEvent.ServerTickEvent event) {
        if (event.phase == TickEvent.Phase.END) {
            Iterator<Map.Entry<WorldAndCoord, IHackableBlock>> blockIterator = this.hackedBlocks.entrySet().iterator();
            while (blockIterator.hasNext()) {
                Map.Entry<WorldAndCoord, IHackableBlock> entry = blockIterator.next();
                IHackableBlock hackableBlock = entry.getValue();
                WorldAndCoord hackedBlock = entry.getKey();
                boolean found = false;
                for (Map.Entry<Block, Class<? extends IHackableBlock>> registeredEntry : PneumaticCraftAPIHandler.getInstance().hackableBlocks.entrySet()) {
                    if (hackableBlock.getClass() != registeredEntry.getValue() || hackedBlock.getBlock() != registeredEntry.getKey()) continue;
                    if (!hackableBlock.afterHackTick((World)hackedBlock.world, hackedBlock.x, hackedBlock.y, hackedBlock.z)) {
                        blockIterator.remove();
                    }
                    found = true;
                    break;
                }
                if (found) continue;
                blockIterator.remove();
            }
        }
    }

    @SubscribeEvent
    public void worldTick(TickEvent.WorldTickEvent event) {
        if (event.phase == TickEvent.Phase.END) {
            try {
                for (Entity entity : event.world.field_72996_f) {
                    HackableHandler.HackingEntityProperties hackingProps = (HackableHandler.HackingEntityProperties)entity.getExtendedProperties("PneumaticCraftHacking");
                    if (hackingProps != null) {
                        hackingProps.update(entity);
                        continue;
                    }
                    Log.warning("Extended entity props HackingEntityProperties couldn't be found in the entity " + entity.func_70005_c_());
                }
            }
            catch (Throwable throwable) {
                // empty catch block
            }
        }
    }

    public void trackBlock(WorldAndCoord coord, IHackableBlock iHackable) {
        this.hackedBlocks.put(coord, iHackable);
    }

    public void trackEntity(Entity entity, IHackableEntity iHackable) {
        if (iHackable.getId() != null) {
            HackableHandler.HackingEntityProperties hackingProps = (HackableHandler.HackingEntityProperties)entity.getExtendedProperties("PneumaticCraftHacking");
            if (hackingProps != null) {
                hackingProps.addHackable(iHackable);
            } else {
                Log.warning("Extended entity props HackingEntityProperties couldn't be found in the entity " + entity.func_70005_c_());
            }
        }
    }
}

