/*
 * Decompiled with CFR 0.152.
 */
package pneumaticCraft.common;

import java.util.HashMap;
import java.util.Map;
import net.minecraft.block.Block;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.init.Blocks;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.stats.Achievement;
import net.minecraft.stats.StatBase;
import net.minecraft.world.ChunkCache;
import net.minecraftforge.common.AchievementPage;
import net.minecraftforge.common.util.ForgeDirection;
import net.minecraftforge.fluids.FluidContainerRegistry;
import net.minecraftforge.fluids.FluidStack;
import pneumaticCraft.common.block.Blockss;
import pneumaticCraft.common.fluid.Fluids;
import pneumaticCraft.common.item.Itemss;

public class AchievementHandler {
    public static final Map<String, Achievement> achieveList = new HashMap<String, Achievement>();

    public static void init() {
        AchievementHandler.registerAcquire(0, 0, Itemss.ingotIronCompressed, null);
        AchievementHandler.registerAcquire(2, 0, Blockss.airCompressor, AchievementHandler.getAchieve(Itemss.ingotIronCompressed));
        AchievementHandler.registerAcquire(4, 0, Fluids.getBucket(Fluids.oil), AchievementHandler.getAchieve(Itemss.ingotIronCompressed));
        AchievementHandler.registerAcquire(6, 0, Blockss.refinery, AchievementHandler.getAchieve(Fluids.getBucket(Fluids.oil)));
        AchievementHandler.registerAcquire(8, 0, Itemss.plastic, AchievementHandler.getAchieve(Blockss.refinery));
        AchievementHandler.registerAcquire(10, 0, Blockss.uvLightBox, AchievementHandler.getAchieve(Itemss.plastic));
        AchievementHandler.registerAcquire(12, 0, Fluids.getBucket(Fluids.etchingAcid), AchievementHandler.getAchieve(Blockss.uvLightBox));
        AchievementHandler.register("dw9x9", 0, 2, new ItemStack(Blocks.field_150347_e), null).func_75987_b();
        AchievementPage.registerAchievementPage((AchievementPage)new AchievementPage("PneumaticCraft", achieveList.values().toArray(new Achievement[achieveList.size()])));
    }

    private static void registerAcquire(int x, int y, Item item, Achievement parentAchievement) {
        AchievementHandler.registerAcquire(x, y, new ItemStack(item), parentAchievement);
    }

    private static void registerAcquire(int x, int y, Block block, Achievement parentAchievement) {
        AchievementHandler.registerAcquire(x, y, new ItemStack(block), parentAchievement);
    }

    private static void registerAcquire(int x, int y, ItemStack stack, Achievement parentAchievement) {
        AchievementHandler.register(stack.func_77973_b().func_77658_a().substring(5), x, y, stack, parentAchievement);
    }

    private static Achievement register(String id, int x, int y, ItemStack icon, Achievement parentAchievement) {
        Achievement achieve = new Achievement(id, id, x, y, icon, parentAchievement);
        achieve.func_75966_h();
        achieve.func_75971_g();
        achieveList.put(id, achieve);
        return achieve;
    }

    public static void giveAchievement(EntityPlayer player, ItemStack acquiredStack) {
        try {
            if (FluidContainerRegistry.containsFluid((ItemStack)acquiredStack, (FluidStack)new FluidStack(Fluids.oil, 1))) {
                AchievementHandler.giveAchievement(player, Fluids.getBucket(Fluids.oil).func_77658_a().substring(5));
            }
            AchievementHandler.giveAchievement(player, acquiredStack.func_77973_b().func_77658_a().substring(5));
        }
        catch (Throwable throwable) {
            // empty catch block
        }
    }

    public static void giveAchievement(EntityPlayer player, String id) {
        Achievement achieve = AchievementHandler.getAchieve(id);
        if (achieve != null) {
            player.func_71029_a((StatBase)achieve);
        }
    }

    private static Achievement getAchieve(Item item) {
        return AchievementHandler.getAchieve(new ItemStack(item));
    }

    private static Achievement getAchieve(Block block) {
        return AchievementHandler.getAchieve(new ItemStack(block));
    }

    private static Achievement getAchieve(ItemStack stack) {
        return AchievementHandler.getAchieve(stack.func_77973_b().func_77658_a().substring(5));
    }

    private static Achievement getAchieve(String id) {
        return achieveList.get(id);
    }

    public static void checkFor9x9(EntityPlayer player, int x, int y, int z) {
        ForgeDirection[] dirs;
        ChunkCache cache = new ChunkCache(player.field_70170_p, x - 8, y, z - 8, x + 8, y, z + 8, 0);
        for (ForgeDirection dir : dirs = new ForgeDirection[]{ForgeDirection.NORTH, ForgeDirection.WEST}) {
            int wallLength = 1;
            int minX = x;
            int minZ = z;
            int maxX = x;
            int maxZ = z;
            int newX = x + dir.offsetX;
            int newZ = z + dir.offsetZ;
            while (wallLength < 9 && cache.func_147439_a(newX, y, newZ) == Blocks.field_150347_e) {
                ++wallLength;
                minX = Math.min(minX, newX);
                minZ = Math.min(minZ, newZ);
                maxX = Math.max(maxX, newX);
                maxZ = Math.max(maxZ, newZ);
                newX += dir.offsetX;
                newZ += dir.offsetZ;
            }
            newX = x - dir.offsetX;
            newZ = z - dir.offsetZ;
            while (wallLength < 9 && cache.func_147439_a(newX, y, newZ) == Blocks.field_150347_e) {
                ++wallLength;
                minX = Math.min(minX, newX);
                minZ = Math.min(minZ, newZ);
                maxX = Math.max(maxX, newX);
                maxZ = Math.max(maxZ, newZ);
                newX -= dir.offsetX;
                newZ -= dir.offsetZ;
            }
            if (wallLength != 9 || !AchievementHandler.checkFor9x9(cache, x, y, z, minX, minZ, maxX, maxZ)) continue;
            AchievementHandler.giveAchievement(player, "dw9x9");
            return;
        }
    }

    private static boolean checkFor9x9(ChunkCache cache, int x, int y, int z, int minX, int minZ, int maxX, int maxZ) {
        if (minX == maxX) {
            for (int offset = 0; offset < 2; ++offset) {
                boolean isValid = true;
                for (int i = 0; i < 9; ++i) {
                    if (cache.func_147439_a(x - 8 + offset * 16, y, minZ + i) != Blocks.field_150347_e) {
                        isValid = false;
                        break;
                    }
                    if (cache.func_147439_a(x - 8 + offset * 8 + i, y, minZ) != Blocks.field_150347_e) {
                        isValid = false;
                        break;
                    }
                    if (cache.func_147439_a(x - 8 + offset * 8 + i, y, maxZ) == Blocks.field_150347_e) continue;
                    isValid = false;
                    break;
                }
                if (!isValid) continue;
                return true;
            }
        } else {
            for (int offset = 0; offset < 2; ++offset) {
                boolean isValid = true;
                for (int i = 0; i < 9; ++i) {
                    if (cache.func_147439_a(minX + i, y, z - 8 + offset * 16) != Blocks.field_150347_e) {
                        isValid = false;
                        break;
                    }
                    if (cache.func_147439_a(minX, y, z - 8 + offset * 8 + i) != Blocks.field_150347_e) {
                        isValid = false;
                        break;
                    }
                    if (cache.func_147439_a(maxX, y, z - 8 + offset * 8 + i) == Blocks.field_150347_e) continue;
                    isValid = false;
                    break;
                }
                if (!isValid) continue;
                return true;
            }
        }
        return false;
    }
}

