/*
 * Decompiled with CFR 0.152.
 */
package pneumaticCraft.client.render.tileentity;

import cpw.mods.fml.client.FMLClientHandler;
import cpw.mods.fml.client.registry.ISimpleBlockRenderingHandler;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import net.minecraft.block.Block;
import net.minecraft.client.renderer.RenderBlocks;
import net.minecraft.client.renderer.tileentity.TileEntitySpecialRenderer;
import net.minecraft.item.ItemStack;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.world.IBlockAccess;
import net.minecraftforge.client.IItemRenderer;
import org.lwjgl.opengl.GL11;
import pneumaticCraft.PneumaticCraft;
import pneumaticCraft.client.model.BaseModel;
import pneumaticCraft.client.model.IBaseModel;
import pneumaticCraft.common.util.PneumaticCraftUtils;

public class RenderModelBase
extends TileEntitySpecialRenderer
implements IItemRenderer,
ISimpleBlockRenderingHandler {
    private static final Map<TileEntity, Integer> renderLists = new HashMap<TileEntity, Integer>();
    private static final List<TileEntity> tilesRequiringRerender = new ArrayList<TileEntity>();
    private IBaseModel model;

    public RenderModelBase(IBaseModel model) {
        this.model = model;
    }

    public RenderModelBase() {
    }

    public void func_147500_a(TileEntity tileentity, double d0, double d1, double d2, float f) {
        this.renderModelAt(tileentity, d0, d1, d2, f);
    }

    public void renderModelAt(TileEntity tile, double d, double d1, double d2, float f) {
        GL11.glPushMatrix();
        if (this.model.getModelTexture(tile) != null) {
            FMLClientHandler.instance().getClient().func_110434_K().func_110577_a(this.model.getModelTexture(tile));
        }
        GL11.glTranslatef((float)((float)d + 0.5f), (float)((float)d1 + 1.5f), (float)((float)d2 + 0.5f));
        GL11.glScalef((float)1.0f, (float)-1.0f, (float)-1.0f);
        if (this.model.rotateModelBasedOnBlockMeta()) {
            PneumaticCraftUtils.rotateMatrixByMetadata(tile.func_145832_p() % 6);
        } else {
            PneumaticCraftUtils.rotateMatrixByMetadata(2);
        }
        if (this.model instanceof BaseModel) {
            GL11.glTranslated((double)0.0, (double)1.5, (double)0.0);
            GL11.glScalef((float)0.0625f, (float)0.0625f, (float)0.0625f);
            GL11.glEnable((int)32826);
        }
        this.model.renderDynamic(0.0625f, tile, f);
        Integer renderList = renderLists.get(tile);
        if (renderList == null) {
            renderList = GL11.glGenLists((int)1);
            renderLists.put(tile, renderList);
            tilesRequiringRerender.add(tile);
        }
        GL11.glPushMatrix();
        this.model.renderStatic(0.0625f, tile);
        GL11.glPopMatrix();
        GL11.glPopMatrix();
    }

    public boolean handleRenderType(ItemStack item, IItemRenderer.ItemRenderType type) {
        return true;
    }

    public boolean shouldUseRenderHelper(IItemRenderer.ItemRenderType type, ItemStack item, IItemRenderer.ItemRendererHelper helper) {
        return true;
    }

    public void renderItem(IItemRenderer.ItemRenderType type, ItemStack item, Object ... data) {
        switch (type) {
            case ENTITY: {
                this.render(0.0f, 0.0f, 1.0f, 1.0f);
                return;
            }
            case EQUIPPED: {
                this.render(0.5f, -0.5f, 1.5f, 1.0f);
                return;
            }
            case EQUIPPED_FIRST_PERSON: {
                GL11.glRotatef((float)-90.0f, (float)0.0f, (float)1.0f, (float)0.0f);
                this.render(0.7f, 0.7f, 1.9f, 1.0f);
                return;
            }
            case INVENTORY: {
                this.render(0.0f, 0.0f, 1.0f, 1.0f);
                return;
            }
        }
    }

    private void render(float x, float y, float z, float scale) {
        GL11.glPushMatrix();
        GL11.glRotatef((float)-90.0f, (float)1.0f, (float)0.0f, (float)0.0f);
        GL11.glScalef((float)scale, (float)scale, (float)scale);
        GL11.glTranslatef((float)x, (float)y, (float)z);
        GL11.glRotatef((float)-90.0f, (float)1.0f, (float)0.0f, (float)0.0f);
        if (this.model.getModelTexture(null) != null) {
            FMLClientHandler.instance().getClient().func_110434_K().func_110577_a(this.model.getModelTexture(null));
        }
        if (this.model instanceof BaseModel) {
            GL11.glTranslated((double)0.0, (double)1.5, (double)0.0);
            GL11.glScalef((float)0.0625f, (float)0.0625f, (float)0.0625f);
        }
        this.model.rotateModelBasedOnBlockMeta();
        this.model.renderDynamic(0.0625f, null, 0.0f);
        this.model.renderStatic(0.0625f, null);
        GL11.glPopMatrix();
    }

    public void renderInventoryBlock(Block block, int metadata, int modelId, RenderBlocks renderer) {
    }

    public boolean renderWorldBlock(IBlockAccess world, int x, int y, int z, Block block, int modelId, RenderBlocks renderer) {
        TileEntity te = world.func_147438_o(x, y, z);
        if (te != null) {
            tilesRequiringRerender.add(te);
        }
        return false;
    }

    public boolean shouldRender3DInInventory(int modelId) {
        return false;
    }

    public int getRenderId() {
        return PneumaticCraft.proxy.SPECIAL_RENDER_TYPE_VALUE;
    }
}

