/*
 * Decompiled with CFR 0.152.
 */
package pneumaticCraft.client.render.pneumaticArmor;

import cpw.mods.fml.client.FMLClientHandler;
import cpw.mods.fml.relauncher.Side;
import cpw.mods.fml.relauncher.SideOnly;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.ScaledResolution;
import net.minecraft.client.renderer.entity.RenderManager;
import net.minecraft.entity.item.EntityItem;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.inventory.IInventory;
import net.minecraft.item.ItemStack;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.MathHelper;
import net.minecraftforge.common.config.Configuration;
import org.lwjgl.input.Keyboard;
import org.lwjgl.opengl.GL11;
import pneumaticCraft.api.client.pneumaticHelmet.IOptionPage;
import pneumaticCraft.api.client.pneumaticHelmet.IUpgradeRenderHandler;
import pneumaticCraft.client.KeyHandler;
import pneumaticCraft.client.gui.pneumaticHelmet.GuiSearchUpgradeOptions;
import pneumaticCraft.client.gui.widget.GuiAnimatedStat;
import pneumaticCraft.client.render.pneumaticArmor.EntityTrackUpgradeHandler;
import pneumaticCraft.client.render.pneumaticArmor.RenderSearchItemBlock;
import pneumaticCraft.common.config.Config;
import pneumaticCraft.common.item.ItemPneumaticArmor;
import pneumaticCraft.common.item.Itemss;
import pneumaticCraft.common.util.PneumaticCraftUtils;
import pneumaticCraft.lib.Textures;

public class SearchUpgradeHandler
implements IUpgradeRenderHandler {
    private int totalSearchedItemCount;
    public int searchedItemCounter;
    private int ticksExisted;
    private final Map<EntityItem, Integer> searchedItems = new HashMap<EntityItem, Integer>();
    private final List<RenderSearchItemBlock> searchedBlocks = new ArrayList<RenderSearchItemBlock>();
    @SideOnly(value=Side.CLIENT)
    private GuiAnimatedStat searchInfo;
    private int statX;
    private int statY;
    private boolean statLeftSided;

    @Override
    @SideOnly(value=Side.CLIENT)
    public String getUpgradeName() {
        return "itemSearcher";
    }

    @Override
    public void initConfig(Configuration config) {
        this.statX = config.get("Helmet_Options.Item_Search", "stat X", -1).getInt();
        this.statY = config.get("Helmet_Options.Item_Search", "stat Y", 17).getInt();
        this.statLeftSided = config.get("Helmet_Options.Item_Search", "stat leftsided", true).getBoolean(true);
    }

    @Override
    public void saveToConfig() {
        Configuration config = Config.config;
        config.load();
        config.get("Helmet_Options.Item_Search", "stat X", -1).set(this.searchInfo.getBaseX());
        config.get("Helmet_Options.Item_Search", "stat Y", 17).set(this.searchInfo.getBaseY());
        config.get("Helmet_Options.Item_Search", "stat leftsided", true).set(this.searchInfo.isLeftSided());
        config.save();
        this.statX = this.searchInfo.getBaseX();
        this.statY = this.searchInfo.getBaseY();
        this.statLeftSided = this.searchInfo.isLeftSided();
    }

    public void addToSearchedItemCounter(int amount) {
        this.searchedItemCounter += amount;
    }

    @Override
    @SideOnly(value=Side.CLIENT)
    public void update(EntityPlayer player, int rangeUpgrades) {
        ++this.ticksExisted;
        ItemStack searchStack = ItemPneumaticArmor.getSearchedStack(player.func_82169_q(3));
        if (this.ticksExisted % 20 == 0) {
            List items = player.field_70170_p.func_72872_a(EntityItem.class, EntityTrackUpgradeHandler.getAABBFromRange(player, rangeUpgrades));
            this.searchedItems.clear();
            for (EntityItem item : items) {
                if (item.func_92059_d() == null || searchStack == null) continue;
                if (item.func_92059_d().func_77969_a(searchStack)) {
                    this.searchedItems.put(item, item.func_92059_d().field_77994_a);
                    continue;
                }
                List<ItemStack> inventoryItems = PneumaticCraftUtils.getStacksInItem(item.func_92059_d());
                int itemCount = 0;
                for (ItemStack inventoryItem : inventoryItems) {
                    if (!inventoryItem.func_77969_a(searchStack)) continue;
                    itemCount += inventoryItem.field_77994_a;
                }
                if (itemCount <= 0) continue;
                this.searchedItems.put(item, itemCount);
            }
            this.totalSearchedItemCount = this.searchedItemCounter;
            this.searchedItemCounter = 0;
            for (Integer itemCount : this.searchedItems.values()) {
                this.searchedItemCounter += itemCount.intValue();
            }
        }
    }

    @Override
    @SideOnly(value=Side.CLIENT)
    public void render3D(float partialTicks) {
        GL11.glEnable((int)32826);
        GL11.glEnable((int)3553);
        GL11.glDepthMask((boolean)false);
        GL11.glDisable((int)2929);
        GL11.glDisable((int)2884);
        GL11.glEnable((int)3042);
        GL11.glClear((int)256);
        GL11.glBlendFunc((int)770, (int)771);
        RenderManager.field_78727_a.field_78724_e.func_110577_a(Textures.GLOW_RESOURCE);
        for (Map.Entry<EntityItem, Integer> entry : this.searchedItems.entrySet()) {
            EntityItem item = entry.getKey();
            float height = MathHelper.func_76126_a((float)(((float)item.field_70292_b + partialTicks) / 10.0f + item.field_70290_d)) * 0.1f + 0.2f;
            RenderSearchItemBlock.renderSearch(item.field_70142_S + (item.field_70165_t - item.field_70142_S) * (double)partialTicks, item.field_70137_T + (item.field_70163_u - item.field_70137_T) * (double)partialTicks + (double)height, item.field_70136_U + (item.field_70161_v - item.field_70136_U) * (double)partialTicks, entry.getValue(), this.totalSearchedItemCount);
        }
        for (int i = 0; i < this.searchedBlocks.size(); ++i) {
            if (this.searchedBlocks.get(i).renderSearchBlock(this.totalSearchedItemCount)) continue;
            this.searchedBlocks.remove(i);
            --i;
        }
        GL11.glEnable((int)2884);
        GL11.glEnable((int)2929);
        GL11.glDisable((int)3042);
        GL11.glDepthMask((boolean)true);
        GL11.glEnable((int)3553);
        GL11.glDisable((int)32826);
    }

    @Override
    @SideOnly(value=Side.CLIENT)
    public void render2D(float partialTicks, boolean helmetEnabled) {
        ItemStack searchStack = ItemPneumaticArmor.getSearchedStack(FMLClientHandler.instance().getClient().field_71439_g.func_82169_q(3));
        ArrayList<String> textList = new ArrayList<String>();
        if (searchStack == null) {
            textList.add("press '" + Keyboard.getKeyName((int)KeyHandler.getInstance().keybindOpenOptions.func_151463_i()) + "' to configure");
        } else {
            textList.add(searchStack.func_82833_r() + " (" + this.totalSearchedItemCount + " found)");
        }
        this.searchInfo.setText(textList);
    }

    @Override
    public boolean isEnabled(ItemStack[] upgradeStacks) {
        for (ItemStack stack : upgradeStacks) {
            if (stack == null || stack.func_77973_b() != Itemss.machineUpgrade || stack.func_77960_j() != 6) continue;
            return true;
        }
        return false;
    }

    public void checkInventoryForItems(TileEntity te) {
        try {
            ItemStack searchStack = ItemPneumaticArmor.getSearchedStack(FMLClientHandler.instance().getClient().field_71439_g.func_82169_q(3));
            IInventory inventory = (IInventory)te;
            boolean hasFoundItem = false;
            if (searchStack != null) {
                for (int l = 0; l < inventory.func_70302_i_(); ++l) {
                    int items;
                    if (inventory.func_70301_a(l) == null || (items = RenderSearchItemBlock.getSearchedItemCount(inventory.func_70301_a(l), searchStack)) <= 0) continue;
                    hasFoundItem = true;
                    this.searchedItemCounter += items;
                }
            }
            if (hasFoundItem) {
                boolean inList = false;
                for (RenderSearchItemBlock trackedBlock : this.searchedBlocks) {
                    if (!trackedBlock.isAlreadyTrackingCoord(te.field_145851_c, te.field_145848_d, te.field_145849_e)) continue;
                    inList = true;
                    break;
                }
                if (!inList) {
                    this.searchedBlocks.add(new RenderSearchItemBlock(te.func_145831_w(), te.field_145851_c, te.field_145848_d, te.field_145849_e));
                }
            }
        }
        catch (Throwable throwable) {
            // empty catch block
        }
    }

    @Override
    @SideOnly(value=Side.CLIENT)
    public void reset() {
        this.searchedBlocks.clear();
        this.searchedItemCounter = 0;
        this.searchedItems.clear();
        this.ticksExisted = 0;
        this.searchInfo = null;
    }

    @Override
    public float getEnergyUsage(int rangeUpgrades, EntityPlayer player) {
        return 1.0f;
    }

    @Override
    @SideOnly(value=Side.CLIENT)
    public IOptionPage getGuiOptionsPage() {
        return new GuiSearchUpgradeOptions(this);
    }

    @Override
    @SideOnly(value=Side.CLIENT)
    public GuiAnimatedStat getAnimatedStat() {
        if (this.searchInfo == null) {
            Minecraft minecraft = Minecraft.func_71410_x();
            ScaledResolution sr = new ScaledResolution(minecraft, minecraft.field_71443_c, minecraft.field_71440_d);
            this.searchInfo = new GuiAnimatedStat(null, "Currently searching for:", new ItemStack(Itemss.machineUpgrade, 1, 6), this.statX != -1 ? this.statX : sr.func_78326_a() - 2, this.statY, 0x3000AA00, null, this.statLeftSided);
            this.searchInfo.setMinDimensionsAndReset(0, 0);
        }
        return this.searchInfo;
    }
}

