/*
 * Decompiled with CFR 0.152.
 */
package pneumaticCraft.client.render.pneumaticArmor;

import cpw.mods.fml.client.FMLClientHandler;
import java.util.List;
import net.minecraft.client.renderer.Tessellator;
import net.minecraft.client.renderer.entity.RenderManager;
import net.minecraft.inventory.IInventory;
import net.minecraft.item.ItemStack;
import net.minecraft.world.World;
import org.lwjgl.opengl.GL11;
import pneumaticCraft.common.item.ItemPneumaticArmor;
import pneumaticCraft.common.util.PneumaticCraftUtils;

public class RenderSearchItemBlock {
    int blockX;
    int blockY;
    int blockZ;
    World world;

    public RenderSearchItemBlock(World world, int x, int y, int z) {
        this.world = world;
        this.blockX = x;
        this.blockY = y;
        this.blockZ = z;
    }

    private int getSearchedItemCount() {
        if (this.world.func_147438_o(this.blockX, this.blockY, this.blockZ) instanceof IInventory) {
            int itemCount = 0;
            IInventory inventory = (IInventory)this.world.func_147438_o(this.blockX, this.blockY, this.blockZ);
            ItemStack searchStack = ItemPneumaticArmor.getSearchedStack(FMLClientHandler.instance().getClient().field_71439_g.func_82169_q(3));
            if (searchStack == null) {
                return 0;
            }
            for (int l = 0; l < inventory.func_70302_i_(); ++l) {
                if (inventory.func_70301_a(l) == null) continue;
                itemCount += RenderSearchItemBlock.getSearchedItemCount(inventory.func_70301_a(l), searchStack);
            }
            return itemCount;
        }
        return 0;
    }

    public static int getSearchedItemCount(ItemStack stack, ItemStack searchStack) {
        int itemCount = 0;
        if (stack.func_77969_a(searchStack)) {
            itemCount += stack.field_77994_a;
        }
        List<ItemStack> inventoryItems = PneumaticCraftUtils.getStacksInItem(stack);
        for (ItemStack s : inventoryItems) {
            itemCount += RenderSearchItemBlock.getSearchedItemCount(s, searchStack);
        }
        return itemCount;
    }

    public boolean isAlreadyTrackingCoord(int x, int y, int z) {
        return this.blockX == x && this.blockY == y && this.blockZ == z;
    }

    public boolean renderSearchBlock(int totalCount) {
        int itemCount = this.getSearchedItemCount();
        RenderSearchItemBlock.renderSearch((double)this.blockX + 0.5, (double)this.blockY + 0.5, (double)this.blockZ + 0.5, itemCount, totalCount);
        return itemCount > 0;
    }

    public static void renderSearch(double x, double y, double z, int itemCount, int totalCount) {
        GL11.glPushMatrix();
        GL11.glTranslated((double)x, (double)y, (double)z);
        GL11.glColor4d((double)0.0, (double)1.0, (double)0.0, (double)0.5);
        GL11.glRotatef((float)(180.0f - RenderManager.field_78727_a.field_78735_i), (float)0.0f, (float)1.0f, (float)0.0f);
        GL11.glRotatef((float)(180.0f - RenderManager.field_78727_a.field_78732_j), (float)1.0f, (float)0.0f, (float)0.0f);
        double ratio = (double)itemCount / (double)totalCount;
        double diff = (1.0 - ratio) / 1.5;
        double size = 1.0 - diff;
        Tessellator tess = Tessellator.field_78398_a;
        tess.func_78371_b(7);
        tess.func_78374_a(-size, size, 0.0, 0.0, 1.0);
        tess.func_78374_a(-size, -size, 0.0, 0.0, 0.0);
        tess.func_78374_a(size, -size, 0.0, 1.0, 0.0);
        tess.func_78374_a(size, size, 0.0, 1.0, 1.0);
        tess.func_78381_a();
        GL11.glPopMatrix();
    }
}

