/*
 * Decompiled with CFR 0.152.
 */
package pneumaticCraft.client.gui;

import cpw.mods.fml.relauncher.Side;
import cpw.mods.fml.relauncher.SideOnly;
import java.util.ArrayList;
import java.util.List;
import net.minecraft.entity.player.InventoryPlayer;
import net.minecraft.item.ItemStack;
import net.minecraft.util.EnumChatFormatting;
import pneumaticCraft.client.gui.GuiPneumaticContainerBase;
import pneumaticCraft.client.gui.widget.GuiAnimatedStat;
import pneumaticCraft.common.block.Blockss;
import pneumaticCraft.common.inventory.ContainerAssemblyController;
import pneumaticCraft.common.tileentity.IAssemblyMachine;
import pneumaticCraft.common.tileentity.TileEntityAssemblyController;
import pneumaticCraft.common.tileentity.TileEntityAssemblyDrill;
import pneumaticCraft.common.tileentity.TileEntityAssemblyIOUnit;
import pneumaticCraft.common.tileentity.TileEntityAssemblyLaser;
import pneumaticCraft.common.tileentity.TileEntityAssemblyPlatform;

@SideOnly(value=Side.CLIENT)
public class GuiAssemblyController
extends GuiPneumaticContainerBase<TileEntityAssemblyController> {
    private GuiAnimatedStat statusStat;

    public GuiAssemblyController(InventoryPlayer player, TileEntityAssemblyController te) {
        super(new ContainerAssemblyController(player, te), te, "pneumaticcraft:textures/gui/GuiAssemblyController.png");
    }

    @Override
    public void func_73866_w_() {
        super.func_73866_w_();
        this.statusStat = this.addAnimatedStat("Assembly Controller Status", new ItemStack(Blockss.assemblyController), -22016, false);
    }

    @Override
    protected void func_146979_b(int x, int y) {
        super.func_146979_b(x, y);
        this.field_146289_q.func_78276_b("Upgr.", 18, 21, 0x404040);
        this.field_146289_q.func_78276_b("Prog.", 70, 24, 0x404040);
    }

    @Override
    public void func_73876_c() {
        super.func_73876_c();
        this.statusStat.setText(this.getStatusText());
    }

    private List<String> getStatusText() {
        ArrayList<String> text = new ArrayList<String>();
        List<IAssemblyMachine> machineList = ((TileEntityAssemblyController)this.te).getMachines();
        boolean platformFound = false;
        boolean drillFound = false;
        boolean laserFound = false;
        boolean IOUnitExportFound = false;
        boolean IOUnitImportFound = false;
        text.add("\u00a77Machine Status:");
        for (IAssemblyMachine machine : machineList) {
            if (machine instanceof TileEntityAssemblyPlatform) {
                platformFound = true;
                text.add(EnumChatFormatting.GREEN + "-Assembly Platform online");
                continue;
            }
            if (machine instanceof TileEntityAssemblyDrill) {
                drillFound = true;
                text.add(EnumChatFormatting.GREEN + "-Assembly Drill online");
                continue;
            }
            if (machine instanceof TileEntityAssemblyIOUnit) {
                if (((TileEntityAssemblyIOUnit)machine).func_145832_p() == 0) {
                    IOUnitImportFound = true;
                    text.add(EnumChatFormatting.GREEN + "-Assembly IO Unit (import) online");
                    continue;
                }
                IOUnitExportFound = true;
                text.add(EnumChatFormatting.GREEN + "-Assembly IO Unit (export) online");
                continue;
            }
            if (!(machine instanceof TileEntityAssemblyLaser)) continue;
            laserFound = true;
            text.add(EnumChatFormatting.GREEN + "-Assembly Laser online");
        }
        if (!platformFound) {
            text.add(EnumChatFormatting.DARK_RED + "-Assembly Platform offline");
        }
        if (!drillFound) {
            text.add(EnumChatFormatting.DARK_RED + "-Assembly Drill offline");
        }
        if (!laserFound) {
            text.add(EnumChatFormatting.DARK_RED + "-Assembly Laser offline");
        }
        if (!IOUnitExportFound) {
            text.add(EnumChatFormatting.DARK_RED + "-Assembly IO Unit (export) offline");
        }
        if (!IOUnitImportFound) {
            text.add(EnumChatFormatting.DARK_RED + "-Assembly IO Unit (import) offline");
        }
        return text;
    }

    @Override
    protected void addProblems(List<String> textList) {
        ((TileEntityAssemblyController)this.te).addProblems(textList);
    }
}

