/*
 * Decompiled with CFR 0.152.
 */
package pneumaticCraft.api.tileentity;

import java.lang.reflect.Constructor;
import pneumaticCraft.api.tileentity.IAirHandler;

public class AirHandlerSupplier {
    private static Constructor airHandlerConstructor;

    public static IAirHandler getTierOneAirHandler(int volume) {
        return AirHandlerSupplier.getAirHandler(5.0f, 7.0f, volume);
    }

    public static IAirHandler getTierTwoAirHandler(int volume) {
        return AirHandlerSupplier.getAirHandler(20.0f, 25.0f, volume);
    }

    public static IAirHandler getAirHandler(float dangerPressure, float criticalPressure, int volume) {
        IAirHandler airHandler = null;
        try {
            if (airHandlerConstructor == null) {
                airHandlerConstructor = Class.forName("pneumaticCraft.common.tileentity.TileEntityPneumaticBase").getConstructor(Float.TYPE, Float.TYPE, Integer.TYPE);
            }
            airHandler = (IAirHandler)airHandlerConstructor.newInstance(Float.valueOf(dangerPressure), Float.valueOf(criticalPressure), volume);
        }
        catch (Exception e) {
            System.err.println("[PneumaticCraft API] An error has occured whilst trying to get an AirHandler. Here's a stacktrace:");
            e.printStackTrace();
        }
        return airHandler;
    }

    @Deprecated
    public static IAirHandler getAirHandler(float dangerPressure, float criticalPressure, float maxFlow, float volume) {
        return AirHandlerSupplier.getAirHandler(dangerPressure, criticalPressure, (int)volume);
    }
}

