/*
 * Decompiled with CFR 0.152.
 */
package net.blay09.mods.trashslot.coremod;

import java.util.HashMap;
import java.util.Map;
import net.minecraft.inventory.Container;
import net.minecraft.launchwrapper.IClassTransformer;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.objectweb.asm.ClassReader;
import org.objectweb.asm.ClassVisitor;
import org.objectweb.asm.ClassWriter;
import org.objectweb.asm.tree.ClassNode;
import org.objectweb.asm.tree.MethodNode;

public class InventoryTweaksClassTransformer
implements IClassTransformer {
    public static final Logger logger = LogManager.getLogger();
    public static final String OBF_CLASS = "aap";
    public static final String MCP_CLASS = "net.minecraft.inventory.ContainerPlayer";

    public byte[] transform(String className, String transformedClassName, byte[] bytes) {
        if (!className.equals(OBF_CLASS) && !className.equals(MCP_CLASS)) {
            return bytes;
        }
        ClassNode classNode = new ClassNode();
        ClassReader classReader = new ClassReader(bytes);
        classReader.accept((ClassVisitor)classNode, 0);
        logger.info("TrashSlot is now looking for Inventory Tweaks in {}", new Object[]{className});
        boolean found = false;
        for (MethodNode method : classNode.methods) {
            if (!method.name.equals("invtweaks$slotMap")) continue;
            logger.info("TrashSlot will now patch {} in {} to fix Inventory Tweaks...", new Object[]{method.name, className});
            method.instructions.clear();
            method.visitVarInsn(25, 0);
            method.visitMethodInsn(184, "net/blay09/mods/trashslot/coremod/InventoryTweaksClassTransformer", "fixInventoryTweaks", "(Lnet/minecraft/inventory/Container;)Ljava/util/Map;", false);
            method.visitInsn(176);
            found = true;
            break;
        }
        if (!found) {
            logger.info("TrashSlot tried to fix Inventory Tweaks, but it's probably not installed.");
        }
        ClassWriter writer = new ClassWriter(1);
        classNode.accept((ClassVisitor)writer);
        return writer.toByteArray();
    }

    public static Map fixInventoryTweaks(Container container) {
        HashMap map = new HashMap();
        map.put(InventoryTweaksClassTransformer.getContainerSection("CRAFTING_OUT"), container.field_75151_b.subList(0, 1));
        map.put(InventoryTweaksClassTransformer.getContainerSection("CRAFTING_IN"), container.field_75151_b.subList(1, 5));
        map.put(InventoryTweaksClassTransformer.getContainerSection("ARMOR"), container.field_75151_b.subList(5, 9));
        map.put(InventoryTweaksClassTransformer.getContainerSection("INVENTORY"), container.field_75151_b.subList(9, 45));
        map.put(InventoryTweaksClassTransformer.getContainerSection("INVENTORY_NOT_HOTBAR"), container.field_75151_b.subList(9, 36));
        map.put(InventoryTweaksClassTransformer.getContainerSection("INVENTORY_HOTBAR"), container.field_75151_b.subList(36, 45));
        return map;
    }

    private static Enum getContainerSection(String name) {
        try {
            Class<?> clazz = Class.forName("invtweaks.api.container.ContainerSection");
            for (Enum obj : (Enum[])clazz.getEnumConstants()) {
                if (!obj.name().equals(name)) continue;
                return obj;
            }
        }
        catch (ClassNotFoundException e) {
            e.printStackTrace();
        }
        return null;
    }
}

