/*
 * Decompiled with CFR 0.152.
 */
package net.blay09.mods.trashslot.coremod;

import net.minecraft.launchwrapper.IClassTransformer;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.objectweb.asm.ClassReader;
import org.objectweb.asm.ClassVisitor;
import org.objectweb.asm.ClassWriter;
import org.objectweb.asm.tree.AbstractInsnNode;
import org.objectweb.asm.tree.ClassNode;
import org.objectweb.asm.tree.MethodNode;
import org.objectweb.asm.tree.VarInsnNode;

public class GuiContainerClassTransformer
implements IClassTransformer {
    public static final Logger logger = LogManager.getLogger();
    public static final String OBF_CLASS = "bex";
    public static final String MCP_CLASS = "net.minecraft.client.gui.inventory.GuiContainer";
    public static final String OBF_METHOD_MOVEDORUP = "func_146286_b";
    public static final String MCP_METHOD_MOVEDORUP = "mouseMovedOrUp";
    public static final String OBF_METHOD_CLICKED = "func_73864_a";
    public static final String MCP_METHOD_CLICKED = "mouseClicked";
    private static final String METHOD_DESC = "(III)V";

    public byte[] transform(String className, String transformedClassName, byte[] bytes) {
        String methodNameClicked;
        String methodNameMovedOrUp;
        if (className.equals(OBF_CLASS)) {
            methodNameMovedOrUp = OBF_METHOD_MOVEDORUP;
            methodNameClicked = OBF_METHOD_CLICKED;
        } else if (className.equals(MCP_CLASS)) {
            methodNameMovedOrUp = MCP_METHOD_MOVEDORUP;
            methodNameClicked = MCP_METHOD_CLICKED;
        } else {
            return bytes;
        }
        ClassNode classNode = new ClassNode();
        ClassReader classReader = new ClassReader(bytes);
        classReader.accept((ClassVisitor)classNode, 0);
        for (MethodNode method : classNode.methods) {
            AbstractInsnNode node;
            int i;
            AbstractInsnNode insertBefore;
            MethodNode mn;
            if (method.name.equals(methodNameMovedOrUp) && method.desc.equals(METHOD_DESC)) {
                logger.info("TrashSlot will now patch {} in {}...", new Object[]{methodNameMovedOrUp, className});
                mn = new MethodNode();
                mn.visitVarInsn(21, 7);
                mn.visitVarInsn(21, 1);
                mn.visitVarInsn(21, 2);
                mn.visitMethodInsn(184, "net/blay09/mods/trashslot/TrashSlot", "canDropStack", "(ZII)Z", false);
                mn.visitVarInsn(54, 7);
                insertBefore = null;
                for (i = 0; i < method.instructions.size(); ++i) {
                    node = method.instructions.get(i);
                    if (!(node instanceof VarInsnNode) || node.getOpcode() != 54 || ((VarInsnNode)node).var != 7) continue;
                    insertBefore = node;
                    break;
                }
                if (insertBefore != null) {
                    method.instructions.insert(insertBefore, mn.instructions);
                    logger.info("TrashSlot successfully patched {} in {}!", new Object[]{methodNameMovedOrUp, className});
                    continue;
                }
                logger.warn("TrashSlot failed to patch {0}::{1} ({2} not found) - items will drop when being taken out of the trash slot!", new Object[]{className, methodNameMovedOrUp, "ISTORE 7"});
                continue;
            }
            if (!method.name.equals(methodNameClicked) || !method.desc.equals(METHOD_DESC)) continue;
            logger.info("TrashSlot will now patch {} in {}...", new Object[]{methodNameClicked, className});
            mn = new MethodNode();
            mn.visitVarInsn(21, 10);
            mn.visitVarInsn(21, 1);
            mn.visitVarInsn(21, 2);
            mn.visitMethodInsn(184, "net/blay09/mods/trashslot/TrashSlot", "canDropStack", "(ZII)Z", false);
            mn.visitVarInsn(54, 10);
            insertBefore = null;
            for (i = 0; i < method.instructions.size(); ++i) {
                node = method.instructions.get(i);
                if (!(node instanceof VarInsnNode) || node.getOpcode() != 54 || ((VarInsnNode)node).var != 10) continue;
                insertBefore = node;
                break;
            }
            if (insertBefore != null) {
                method.instructions.insert(insertBefore, mn.instructions);
                logger.info("TrashSlot successfully patched {} in {}!", new Object[]{methodNameClicked, className});
                continue;
            }
            logger.warn("TrashSlot failed to patch {0}::{1} ({2} not found) - items will drop when being taken out of the trash slot!", new Object[]{className, methodNameClicked, "ISTORE 10"});
        }
        ClassWriter writer = new ClassWriter(1);
        classNode.accept((ClassVisitor)writer);
        return writer.toByteArray();
    }
}

