/*
 * Decompiled with CFR 0.152.
 */
package nl.lang2619.bagginses.references;

import cpw.mods.fml.common.Loader;
import cpw.mods.fml.common.registry.GameData;
import cpw.mods.fml.common.registry.GameRegistry;
import java.util.ArrayList;
import java.util.IdentityHashMap;
import java.util.Map;
import java.util.Set;
import net.minecraft.block.Block;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraftforge.oredict.OreDictionary;
import nl.lang2619.bagginses.references.Log;
import org.apache.commons.lang3.ArrayUtils;

public class BlockList {
    public static IdentityHashMap<Item, short[]> blackList = new IdentityHashMap();
    public static IdentityHashMap<Item, short[]> blueList = new IdentityHashMap();
    public static IdentityHashMap<Item, short[]> brownList = new IdentityHashMap();
    public static IdentityHashMap<Item, short[]> cyanList = new IdentityHashMap();
    public static IdentityHashMap<Item, short[]> grayList = new IdentityHashMap();
    public static IdentityHashMap<Item, short[]> greenList = new IdentityHashMap();
    public static IdentityHashMap<Item, short[]> lightBlueList = new IdentityHashMap();
    public static IdentityHashMap<Item, short[]> limeList = new IdentityHashMap();
    public static IdentityHashMap<Item, short[]> magentaList = new IdentityHashMap();
    public static IdentityHashMap<Item, short[]> orangeList = new IdentityHashMap();
    public static IdentityHashMap<Item, short[]> purpleList = new IdentityHashMap();
    public static IdentityHashMap<Item, short[]> pinkList = new IdentityHashMap();
    public static IdentityHashMap<Item, short[]> redList = new IdentityHashMap();
    public static IdentityHashMap<Item, short[]> silverList = new IdentityHashMap();
    public static IdentityHashMap<Item, short[]> whiteList = new IdentityHashMap();
    public static IdentityHashMap<Item, short[]> yellowList = new IdentityHashMap();

    public static boolean contains(Item item, int damage, String color) {
        short[] listedDamages = BlockList.getList(color).get(item);
        return listedDamages != null && listedDamages.length > 0 && (listedDamages[0] == -1 || ArrayUtils.contains((short[])listedDamages, (short)((short)damage)));
    }

    public static IdentityHashMap<Item, short[]> getList(String color) {
        if (color.equals("black")) {
            return blackList;
        }
        if (color.equals("blue")) {
            return blueList;
        }
        if (color.equals("brown")) {
            return brownList;
        }
        if (color.equals("cyan")) {
            return cyanList;
        }
        if (color.equals("gray")) {
            return grayList;
        }
        if (color.equals("green")) {
            return greenList;
        }
        if (color.equals("lightBlue")) {
            return lightBlueList;
        }
        if (color.equals("lime")) {
            return limeList;
        }
        if (color.equals("magenta")) {
            return magentaList;
        }
        if (color.equals("orange")) {
            return orangeList;
        }
        if (color.equals("purple")) {
            return purpleList;
        }
        if (color.equals("pink")) {
            return pinkList;
        }
        if (color.equals("red")) {
            return redList;
        }
        if (color.equals("silver")) {
            return silverList;
        }
        if (color.equals("white")) {
            return whiteList;
        }
        if (color.equals("yellow")) {
            return yellowList;
        }
        return null;
    }

    public static void addFromString(String list, String color) {
        String[] split;
        if (list.isEmpty()) {
            return;
        }
        int added = 0;
        for (String entry : split = list.split(",")) {
            String identifier;
            String[] itemId;
            if ((entry = entry.trim()).length() == 0) continue;
            String itemName = entry;
            short[] dmgs = new short[]{-1};
            if (entry.contains("/")) {
                String[] sep = entry.split("/");
                if (sep.length != 2) {
                    Log.warn("Invalid entry in whitelist $1 : $0", entry, color);
                    continue;
                }
                itemName = sep[0];
                try {
                    if (sep[1].contains("+")) {
                        String[] dmgVals = sep[1].split("\\+");
                        dmgs = new short[dmgVals.length];
                        for (int a = 0; a < dmgVals.length; ++a) {
                            dmgs[a] = Short.parseShort(dmgVals[a]);
                        }
                    } else {
                        dmgs = new short[]{Short.parseShort(sep[1])};
                    }
                }
                catch (NumberFormatException e) {
                    Log.warn("Invalid entry in whitelist $1, wrong damage values: $0", entry, color);
                    continue;
                }
            }
            if ((itemId = itemName.split(":")).length > 2) {
                Log.warn("Invalid entry in whitelist $1, wrong item identifier: $0", entry, color);
                continue;
            }
            if (itemId.length == 1) {
                itemId = new String[]{"minecraft", itemId[0]};
            }
            if (itemId[0].equals("ore")) {
                identifier = itemId[1];
                ArrayList items = OreDictionary.getOres((String)identifier);
                for (ItemStack is : items) {
                    if (GameData.getItemRegistry().getRaw(Item.func_150891_b((Item)is.func_77973_b())) instanceof Item) {
                        Item item = (Item)GameData.getItemRegistry().getRaw(Item.func_150891_b((Item)is.func_77973_b()));
                        BlockList.getList(color).put(item, dmgs);
                        ++added;
                        continue;
                    }
                    Block block = (Block)GameData.getBlockRegistry().getRaw(Block.func_149682_b((Block)Block.func_149634_a((Item)is.func_77973_b())));
                    BlockList.getList(color).put(Item.func_150898_a((Block)block), dmgs);
                    ++added;
                }
            }
            if (itemId[1].equals("*")) {
                identifier = itemId[0] + ":";
                added = BlockList.SpecifiedBlock(color, added, dmgs, itemId, identifier);
                added = BlockList.SpecifiedItem(color, added, dmgs, itemId, identifier);
                continue;
            }
            added = BlockList.SpecifiedEntry(color, added, entry, dmgs, itemId);
        }
        if (list.equals("*:*")) {
            added = BlockList.addAllMods(color, added);
        }
        if (added > 0) {
            Log.info("Added $0 items into whitelist $1", added, color);
        }
    }

    private static int SpecifiedEntry(String color, int added, String entry, short[] dmgs, String[] itemId) {
        Item item = GameRegistry.findItem((String)itemId[0], (String)itemId[1]);
        if (item == null) {
            Block block = GameRegistry.findBlock((String)itemId[0], (String)itemId[1]);
            if (block == null) {
                if (itemId[0].equals("minecraft") || Loader.isModLoaded((String)itemId[0])) {
                    Log.warn("Invalid entry in whitelist $1, item not found: $0", entry, color);
                }
                return added;
            }
            item = Item.func_150898_a((Block)block);
        }
        BlockList.getList(color).put(item, dmgs);
        return ++added;
    }

    private static int SpecifiedItem(String color, int added, short[] dmgs, String[] itemId, String identifier) {
        for (String key : GameData.getItemRegistry().func_148742_b()) {
            if (!key.startsWith(identifier)) continue;
            Item item = (Item)GameData.getItemRegistry().getRaw(key);
            if (item == null) {
                if (!itemId[0].equals("minecraft") && !Loader.isModLoaded((String)itemId[0])) continue;
                Log.warn("Stumbled upon invalid entry in item registry while parsing whitelist $1, object not found: $0", key, color);
                continue;
            }
            BlockList.getList(color).put(item, dmgs);
            ++added;
        }
        return added;
    }

    private static int SpecifiedBlock(String color, int added, short[] dmgs, String[] itemId, String identifier) {
        for (String key : GameData.getBlockRegistry().func_148742_b()) {
            if (!key.startsWith(identifier)) continue;
            Block block = (Block)GameData.getBlockRegistry().getRaw(key);
            if (block == null) {
                if (!itemId[0].equals("minecraft") && !Loader.isModLoaded((String)itemId[0])) continue;
                Log.warn("Stumbled upon invalid entry in block registry while parsing whitelist $1, object not found: $0", key, color);
                continue;
            }
            BlockList.getList(color).put(Item.func_150898_a((Block)block), dmgs);
            ++added;
        }
        return added;
    }

    private static int addAllMods(String color, int added) {
        short[] dmgs = new short[]{-1};
        Set mapSet = Loader.instance().getIndexedModList().entrySet();
        for (Map.Entry mapEntry : mapSet) {
            String keyValue = (String)mapEntry.getKey();
            String identifier = keyValue + ":";
            for (String key : GameData.getBlockRegistry().func_148742_b()) {
                if (!key.startsWith(identifier)) continue;
                Block block = (Block)GameData.getBlockRegistry().getRaw(key);
                if (block == null) {
                    if (!keyValue.equals("minecraft") && !Loader.isModLoaded((String)keyValue)) continue;
                    Log.warn("Stumbled upon invalid entry in block registry while parsing whitelist $1, object not found: $0", key, color);
                    continue;
                }
                BlockList.getList(color).put(Item.func_150898_a((Block)block), dmgs);
                ++added;
            }
            for (String key : GameData.getItemRegistry().func_148742_b()) {
                if (!key.startsWith(identifier)) continue;
                Item item = (Item)GameData.getItemRegistry().getRaw(key);
                if (item == null) {
                    if (!keyValue.equals("minecraft") && !Loader.isModLoaded((String)keyValue)) continue;
                    Log.warn("Stumbled upon invalid entry in item registry while parsing whitelist $1, object not found: $0", key, color);
                    continue;
                }
                BlockList.getList(color).put(item, dmgs);
                ++added;
            }
        }
        String identifier = "minecraft:";
        for (String key : GameData.getBlockRegistry().func_148742_b()) {
            if (!key.startsWith(identifier)) continue;
            Block block = (Block)GameData.getBlockRegistry().getRaw(key);
            BlockList.getList(color).put(Item.func_150898_a((Block)block), dmgs);
            ++added;
        }
        for (String key : GameData.getItemRegistry().func_148742_b()) {
            if (!key.startsWith(identifier)) continue;
            Item item = (Item)GameData.getItemRegistry().getRaw(key);
            BlockList.getList(color).put(item, dmgs);
            ++added;
        }
        return added;
    }
}

