/*
 * Decompiled with CFR 0.152.
 */
package cofh.thermalfoundation;

import cofh.core.CoFHProps;
import cofh.core.util.ConfigHandler;
import cofh.core.util.CoreUtils;
import cofh.mod.BaseMod;
import cofh.mod.updater.IUpdatableMod;
import cofh.mod.updater.UpdateManager;
import cofh.thermalfoundation.block.TFBlocks;
import cofh.thermalfoundation.core.Proxy;
import cofh.thermalfoundation.core.TFProps;
import cofh.thermalfoundation.fluid.TFFluids;
import cofh.thermalfoundation.gui.GuiHandler;
import cofh.thermalfoundation.gui.TFCreativeTab;
import cofh.thermalfoundation.item.Equipment;
import cofh.thermalfoundation.item.TFItems;
import cofh.thermalfoundation.network.PacketTFBase;
import cofh.thermalfoundation.plugins.TFPlugins;
import cofh.thermalfoundation.util.EventHandlerLexicon;
import cofh.thermalfoundation.util.IMCHandler;
import cofh.thermalfoundation.util.LexiconManager;
import cpw.mods.fml.common.Mod;
import cpw.mods.fml.common.SidedProxy;
import cpw.mods.fml.common.event.FMLInitializationEvent;
import cpw.mods.fml.common.event.FMLInterModComms;
import cpw.mods.fml.common.event.FMLLoadCompleteEvent;
import cpw.mods.fml.common.event.FMLPostInitializationEvent;
import cpw.mods.fml.common.event.FMLPreInitializationEvent;
import cpw.mods.fml.common.event.FMLServerStartingEvent;
import cpw.mods.fml.common.network.IGuiHandler;
import cpw.mods.fml.common.network.NetworkRegistry;
import java.io.File;
import java.util.List;
import net.minecraft.creativetab.CreativeTabs;
import net.minecraft.item.ItemStack;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.common.config.Configuration;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

@Mod(modid="ThermalFoundation", name="Thermal Foundation", version="1.7.10R1.2.5", dependencies="required-after:CoFHCore@[1.7.10R3.1.3,1.7.10R3.2.0);", guiFactory="cofh.thermalfoundation.gui.GuiConfigTFFactory", canBeDeactivated=false, customProperties={@Mod.CustomProperty(k="cofhversion", v="true")})
public class ThermalFoundation
extends BaseMod {
    public static final String modId = "ThermalFoundation";
    public static final String modName = "Thermal Foundation";
    public static final String version = "1.7.10R1.2.5";
    public static final String version_max = "1.7.10R1.3.0";
    public static final String dependencies = "required-after:CoFHCore@[1.7.10R3.1.3,1.7.10R3.2.0);";
    public static final String modGuiFactory = "cofh.thermalfoundation.gui.GuiConfigTFFactory";
    public static final String version_group = "required-after:ThermalFoundation@[1.7.10R1.2.5,1.7.10R1.3.0);";
    public static final String releaseURL = "https://raw.github.com/CoFH/VERSION/master/ThermalFoundation";
    @Mod.Instance(value="ThermalFoundation")
    public static ThermalFoundation instance;
    @SidedProxy(clientSide="cofh.thermalfoundation.core.ProxyClient", serverSide="cofh.thermalfoundation.core.Proxy")
    public static Proxy proxy;
    public static final Logger log;
    public static final ConfigHandler config;
    public static final ConfigHandler configClient;
    public static final GuiHandler guiHandler;
    public static CreativeTabs tabCommon;
    public static CreativeTabs tabTools;
    public static CreativeTabs tabArmor;
    public static File worldGenOres;
    public static final String worldGenInternalOres = "assets/thermalfoundation/world/ThermalFoundation-Ores.json";

    public ThermalFoundation() {
        super(log);
    }

    @Mod.EventHandler
    public void preInit(FMLPreInitializationEvent fMLPreInitializationEvent) {
        UpdateManager.registerUpdater((UpdateManager)new UpdateManager((IUpdatableMod)this, releaseURL, "http://teamcofh.com/downloads/"));
        config.setConfiguration(new Configuration(new File(CoFHProps.configDir, "/cofh/thermalfoundation/common.cfg"), true));
        configClient.setConfiguration(new Configuration(new File(CoFHProps.configDir, "cofh/thermalfoundation/client.cfg"), true));
        tabCommon = new TFCreativeTab();
        this.cleanConfig(true);
        this.configOptions();
        TFFluids.preInit();
        TFItems.preInit();
        TFBlocks.preInit();
        TFPlugins.preInit();
        LexiconManager.preInit();
    }

    @Mod.EventHandler
    public void initialize(FMLInitializationEvent fMLInitializationEvent) {
        TFFluids.initialize();
        TFItems.initialize();
        TFBlocks.initialize();
        TFPlugins.initialize();
        this.loadWorldGeneration();
        NetworkRegistry.INSTANCE.registerGuiHandler((Object)instance, (IGuiHandler)guiHandler);
        MinecraftForge.EVENT_BUS.register((Object)proxy);
        EventHandlerLexicon.initialize();
        PacketTFBase.initialize();
    }

    @Mod.EventHandler
    public void postInit(FMLPostInitializationEvent fMLPostInitializationEvent) {
        TFFluids.postInit();
        TFItems.postInit();
        TFBlocks.postInit();
        TFPlugins.postInit();
        proxy.registerEntities();
        proxy.registerRenderInformation();
    }

    @Mod.EventHandler
    public void loadComplete(FMLLoadCompleteEvent fMLLoadCompleteEvent) {
        IMCHandler.instance.handleIMC((List<FMLInterModComms.IMCMessage>)FMLInterModComms.fetchRuntimeMessages((Object)((Object)this)));
        LexiconManager.loadComplete();
        TFPlugins.loadComplete();
        this.cleanConfig(false);
        config.cleanUp(false, true);
        configClient.cleanUp(false, true);
        log.info("Thermal Foundation: Load Complete.");
    }

    @Mod.EventHandler
    public void serverStarting(FMLServerStartingEvent fMLServerStartingEvent) {
        TFFluids.registerDispenserHandlers();
    }

    @Mod.EventHandler
    public void handleIMC(FMLInterModComms.IMCEvent iMCEvent) {
        IMCHandler.instance.handleIMC((List<FMLInterModComms.IMCMessage>)iMCEvent.getMessages());
    }

    void configOptions() {
        String string = "If TRUE, Fire-Immune mobs have a chance to drop Sulfur.";
        TFProps.dropSulfurFireImmune = config.get("General", "FireImmuneDropSulfur", TFProps.dropSulfurFireImmune, string);
        string = "Set to FALSE to revert Blaze Powder to the default Minecraft icon.";
        TFProps.iconBlazePowder = configClient.get("Icons", "BlazePowder", TFProps.iconBlazePowder, string);
        string = "Set to TRUE for Ender devices to be a bit more Cagey year-round.";
        TFProps.renderStarfieldCage = configClient.get("Render", "CageyEnder", TFProps.renderStarfieldCage, string);
        String string2 = "Interface.CreativeTab";
        boolean bl = false;
        boolean bl2 = false;
        string = "Set to TRUE to put Thermal Foundation Armor under the general \"Thermal Foundation\" Creative Tab.";
        bl = configClient.get(string2, "ArmorInCommonTab", bl);
        string = "Set to TRUE to put Thermal Foundation Tools under the general \"Thermal Foundation\" Creative Tab.";
        bl2 = configClient.get(string2, "ToolsInCommonTab", bl2);
        string2 = "Equipment";
        string = "Set to TRUE to disable ALL armor sets.";
        TFProps.disableAllArmor = config.get(string2, "DisableAllArmor", TFProps.disableAllArmor, string);
        string = "Set to TRUE to disable ALL tool sets.";
        TFProps.disableAllTools = config.get(string2, "DisableAllTools", TFProps.disableAllTools, string);
        string = "Set to FALSE to hide all disabled equipment from the Creative Tabs and NEI.";
        TFProps.showDisabledEquipment = config.get(string2, "ShowDisabledEquipment", TFProps.showDisabledEquipment, string);
        if (bl) {
            tabArmor = tabCommon;
        } else if (!TFProps.disableAllArmor || TFProps.disableAllArmor && TFProps.showDisabledEquipment) {
            tabArmor = new TFCreativeTab("Armor"){

                @Override
                protected ItemStack getStack() {
                    return Equipment.Invar.armorPlate;
                }
            };
        }
        if (bl2) {
            tabTools = tabCommon;
        } else if (!TFProps.disableAllTools || TFProps.disableAllTools && TFProps.showDisabledEquipment) {
            tabTools = new TFCreativeTab("Tools"){

                @Override
                protected ItemStack getStack() {
                    return Equipment.Invar.toolPickaxe;
                }
            };
        }
    }

    void cleanConfig(boolean bl) {
        int n;
        if (bl) {
            // empty if block
        }
        String string = "config.thermalfoundation.";
        String[] stringArray = config.getCategoryNames().toArray(new String[config.getCategoryNames().size()]);
        for (n = 0; n < stringArray.length; ++n) {
            config.getCategory(stringArray[n]).setLanguageKey(string + stringArray[n]).setRequiresMcRestart(true);
        }
        stringArray = configClient.getCategoryNames().toArray(new String[configClient.getCategoryNames().size()]);
        for (n = 0; n < stringArray.length; ++n) {
            configClient.getCategory(stringArray[n]).setLanguageKey(string + stringArray[n]).setRequiresMcRestart(true);
        }
    }

    void loadWorldGeneration() {
        if (!config.get("World", "GenerateDefaultFiles", true, "If enabled, Thermal Foundation will create default world generation files - if it cannot find existing ones. Only disable this if you know what you are doing.")) {
            return;
        }
        worldGenOres = new File(CoFHProps.configDir, "/cofh/world/ThermalFoundation-Ores.json");
        boolean bl = false;
        File file = new File(CoFHProps.configDir, "/cofh/world/ThermalExpansion-Ores.json");
        if (file.exists() && file.renameTo(worldGenOres)) {
            log.warn("Thermal Foundation was unable to convert existing world generation! This is really bad - your files are probably write protected and you need to handle it now!");
            bl = true;
        }
        if (!worldGenOres.exists() && !bl) {
            try {
                worldGenOres.createNewFile();
                CoreUtils.copyFileUsingStream((String)worldGenInternalOres, (File)worldGenOres);
            }
            catch (Throwable throwable) {
                throwable.printStackTrace();
            }
        }
    }

    public String getModId() {
        return modId;
    }

    public String getModName() {
        return modName;
    }

    public String getModVersion() {
        return version;
    }

    static {
        log = LogManager.getLogger((String)modId);
        config = new ConfigHandler(version);
        configClient = new ConfigHandler(version);
        guiHandler = new GuiHandler();
        tabTools = CreativeTabs.field_78040_i;
        tabArmor = CreativeTabs.field_78037_j;
    }
}

