/*
 * Decompiled with CFR 0.152.
 */
package com.jaquadro.minecraft.gardentrees.core.handlers;

import com.jaquadro.minecraft.gardencore.api.SaplingRegistry;
import com.jaquadro.minecraft.gardencore.api.event.EnrichedSoilEvent;
import com.jaquadro.minecraft.gardentrees.GardenTrees;
import com.jaquadro.minecraft.gardentrees.core.recipe.WoodPostRecipe;
import com.jaquadro.minecraft.gardentrees.item.ItemThinLog;
import cpw.mods.fml.common.eventhandler.Event;
import cpw.mods.fml.common.eventhandler.SubscribeEvent;
import cpw.mods.fml.common.gameevent.PlayerEvent;
import net.minecraft.block.Block;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.world.gen.feature.WorldGenerator;

public class ForgeEventHandler {
    @SubscribeEvent
    public void applyEnrichedSoil(EnrichedSoilEvent event) {
        if (!GardenTrees.config.compostGrowsOrnamentalTrees) {
            return;
        }
        Item sapling = Item.func_150898_a((Block)event.block);
        int saplingMeta = event.world.func_72805_g(event.x, event.y, event.z);
        if (sapling == null) {
            return;
        }
        WorldGenerator generator = (WorldGenerator)SaplingRegistry.instance().getExtendedData(sapling, saplingMeta, "sm_generator");
        if (generator == null) {
            return;
        }
        event.world.func_147468_f(event.x, event.y, event.z);
        if (generator.func_76484_a(event.world, event.world.field_73012_v, event.x, event.y, event.z)) {
            event.setResult(Event.Result.ALLOW);
            return;
        }
        event.world.func_147465_d(event.x, event.y, event.z, event.block, saplingMeta, 0);
    }

    @SubscribeEvent
    public void handleCrafting(PlayerEvent.ItemCraftedEvent event) {
        if (event.crafting.func_77973_b() instanceof ItemThinLog) {
            for (int i = 0; i < event.craftMatrix.func_70302_i_(); ++i) {
                ItemStack item = event.craftMatrix.func_70301_a(i);
                if (item == null || !this.isValidAxe(item) || item.func_77960_j() >= item.func_77958_k()) continue;
                ItemStack modifiedAxe = item.func_77946_l();
                modifiedAxe.func_77964_b(modifiedAxe.func_77960_j() + 1);
                modifiedAxe.field_77994_a += modifiedAxe.field_77994_a;
                event.craftMatrix.func_70299_a(i, modifiedAxe);
            }
        }
    }

    private boolean isValidAxe(ItemStack itemStack) {
        Item item = itemStack.func_77973_b();
        int n = WoodPostRecipe.axeList.size();
        for (int i = 0; i < n; ++i) {
            if (item != WoodPostRecipe.axeList.get(i)) continue;
            return true;
        }
        return false;
    }
}

