/*
 * Decompiled with CFR 0.152.
 */
package com.jaquadro.minecraft.gardenstuff.renderer;

import com.jaquadro.minecraft.gardenapi.api.GardenAPI;
import com.jaquadro.minecraft.gardenapi.api.connect.IAttachable;
import com.jaquadro.minecraft.gardenapi.api.connect.IChainSingleAttachable;
import com.jaquadro.minecraft.gardenstuff.block.BlockHeavyChain;
import com.jaquadro.minecraft.gardenstuff.core.ClientProxy;
import cpw.mods.fml.client.registry.ISimpleBlockRenderingHandler;
import net.minecraft.block.Block;
import net.minecraft.client.renderer.EntityRenderer;
import net.minecraft.client.renderer.RenderBlocks;
import net.minecraft.client.renderer.Tessellator;
import net.minecraft.util.IIcon;
import net.minecraft.util.Vec3;
import net.minecraft.world.IBlockAccess;

public class HeavyChainRenderer
implements ISimpleBlockRenderingHandler {
    private static final Vec3[] defaultAttachPoint = new Vec3[]{Vec3.func_72443_a((double)0.5, (double)0.0, (double)0.5), Vec3.func_72443_a((double)0.5, (double)1.0, (double)0.5), Vec3.func_72443_a((double)0.5, (double)0.5, (double)0.0), Vec3.func_72443_a((double)0.5, (double)0.5, (double)1.0), Vec3.func_72443_a((double)0.0, (double)0.5, (double)0.5), Vec3.func_72443_a((double)1.0, (double)0.5, (double)0.5)};

    public void renderInventoryBlock(Block block, int metadata, int modelId, RenderBlocks renderer) {
    }

    public boolean renderWorldBlock(IBlockAccess world, int x, int y, int z, Block block, int modelId, RenderBlocks renderer) {
        if (block instanceof BlockHeavyChain) {
            return this.renderWorldBlock(world, x, y, z, (BlockHeavyChain)block, modelId, renderer);
        }
        return false;
    }

    private boolean renderWorldBlock(IBlockAccess world, int x, int y, int z, BlockHeavyChain block, int modelId, RenderBlocks renderer) {
        IAttachable attachable;
        Vec3 attach;
        Block lowerBlock;
        IAttachable attachable2;
        Vec3 attach2;
        renderer.func_147782_a(0.0, 0.0, 0.0, 1.0, 1.0, 1.0);
        this.renderCrossedSquares(renderer, block, x, y, z);
        double upperDepth = 0.0;
        double lowerDepth = 0.0;
        Block upperBlock = world.func_147439_a(x, y + 1, z);
        if (upperBlock instanceof IChainSingleAttachable && (attach2 = ((IChainSingleAttachable)upperBlock).getChainAttachPoint(world, x, y + 1, z, 0)) != null && attach2 != defaultAttachPoint[0]) {
            upperDepth = attach2.field_72448_b;
        }
        if (upperDepth == 0.0 && (attachable2 = GardenAPI.instance().registries().attachable().getAttachable(upperBlock, world.func_72805_g(x, y + 1, z))) != null && attachable2.isAttachable(world, x, y + 1, z, 0)) {
            upperDepth = attachable2.getAttachDepth(world, x, y + 1, z, 0);
        }
        if ((lowerBlock = world.func_147439_a(x, y - 1, z)) instanceof IChainSingleAttachable && (attach = ((IChainSingleAttachable)lowerBlock).getChainAttachPoint(world, x, y - 1, z, 1)) != null && attach != defaultAttachPoint[1]) {
            lowerDepth = attach.field_72448_b;
        }
        if (lowerDepth == 0.0 && (attachable = GardenAPI.instance().registries().attachable().getAttachable(lowerBlock, world.func_72805_g(x, y - 1, z))) != null && attachable.isAttachable(world, x, y - 1, z, 1)) {
            lowerDepth = attachable.getAttachDepth(world, x, y - 1, z, 1);
        }
        if (upperDepth > 0.0) {
            renderer.func_147782_a(0.0, 0.0, 0.0, 1.0, upperDepth, 1.0);
            renderer.func_147757_a(block.func_149673_e(world, x, y, z, 0));
            this.renderCrossedSquares(renderer, block, x, y + 1, z);
            renderer.func_147757_a(null);
        }
        if (lowerDepth > 0.0) {
            renderer.func_147782_a(0.0, lowerDepth, 0.0, 1.0, 1.0, 1.0);
            renderer.func_147757_a(block.func_149673_e(world, x, y, z, 0));
            this.renderCrossedSquares(renderer, block, x, y - 1, z);
            renderer.func_147757_a(null);
        }
        return true;
    }

    public boolean shouldRender3DInInventory(int modelId) {
        return false;
    }

    public int getRenderId() {
        return ClientProxy.heavyChainRenderID;
    }

    private void renderCrossedSquares(RenderBlocks renderer, Block block, int x, int y, int z) {
        Tessellator tessellator = Tessellator.field_78398_a;
        tessellator.func_78380_c(block.func_149677_c(renderer.field_147845_a, x, y, z));
        int l = block.func_149720_d(renderer.field_147845_a, x, y, z);
        float f = (float)(l >> 16 & 0xFF) / 255.0f;
        float f1 = (float)(l >> 8 & 0xFF) / 255.0f;
        float f2 = (float)(l & 0xFF) / 255.0f;
        if (EntityRenderer.field_78517_a) {
            float f3 = (f * 30.0f + f1 * 59.0f + f2 * 11.0f) / 100.0f;
            float f4 = (f * 30.0f + f1 * 70.0f) / 100.0f;
            float f5 = (f * 30.0f + f2 * 70.0f) / 100.0f;
            f = f3;
            f1 = f4;
            f2 = f5;
        }
        tessellator.func_78386_a(f, f1, f2);
        IIcon iicon = renderer.func_147787_a(block, 0, renderer.field_147845_a.func_72805_g(x, y, z));
        this.drawCrossedSquares(renderer, iicon, x, y, z, 1.0f);
    }

    private void drawCrossedSquares(RenderBlocks renderer, IIcon icon, double x, double y, double z, float scale) {
        Tessellator tessellator = Tessellator.field_78398_a;
        if (renderer.func_147744_b()) {
            icon = renderer.field_147840_d;
        }
        double uMin = icon.func_94214_a(renderer.field_147859_h * 16.0);
        double uMax = icon.func_94214_a(renderer.field_147861_i * 16.0);
        double vMin = icon.func_94207_b(16.0 - renderer.field_147857_k * 16.0);
        double vMax = icon.func_94207_b(16.0 - renderer.field_147855_j * 16.0);
        double d7 = 0.45 * (double)scale;
        double xMin = x + 0.5 - d7;
        double xMax = x + 0.5 + d7;
        double yMin = y + renderer.field_147855_j * (double)scale;
        double yMax = y + renderer.field_147857_k * (double)scale;
        double zMin = z + 0.5 - d7;
        double zMax = z + 0.5 + d7;
        tessellator.func_78374_a(xMin, yMax, zMin, uMin, vMin);
        tessellator.func_78374_a(xMin, yMin, zMin, uMin, vMax);
        tessellator.func_78374_a(xMax, yMin, zMax, uMax, vMax);
        tessellator.func_78374_a(xMax, yMax, zMax, uMax, vMin);
        tessellator.func_78374_a(xMax, yMax, zMax, uMin, vMin);
        tessellator.func_78374_a(xMax, yMin, zMax, uMin, vMax);
        tessellator.func_78374_a(xMin, yMin, zMin, uMax, vMax);
        tessellator.func_78374_a(xMin, yMax, zMin, uMax, vMin);
        tessellator.func_78374_a(xMin, yMax, zMax, uMin, vMin);
        tessellator.func_78374_a(xMin, yMin, zMax, uMin, vMax);
        tessellator.func_78374_a(xMax, yMin, zMin, uMax, vMax);
        tessellator.func_78374_a(xMax, yMax, zMin, uMax, vMin);
        tessellator.func_78374_a(xMax, yMax, zMin, uMin, vMin);
        tessellator.func_78374_a(xMax, yMin, zMin, uMin, vMax);
        tessellator.func_78374_a(xMin, yMin, zMax, uMax, vMax);
        tessellator.func_78374_a(xMin, yMax, zMax, uMax, vMin);
    }
}

