/*
 * Decompiled with CFR 0.152.
 */
package com.jaquadro.minecraft.gardencore.block;

import com.jaquadro.minecraft.gardencore.GardenCore;
import com.jaquadro.minecraft.gardencore.block.BlockGarden;
import com.jaquadro.minecraft.gardencore.block.support.BasicConnectionProfile;
import com.jaquadro.minecraft.gardencore.block.support.BasicSlotProfile;
import com.jaquadro.minecraft.gardencore.block.support.SlotShare0Profile;
import com.jaquadro.minecraft.gardencore.block.tile.TileEntityGarden;
import com.jaquadro.minecraft.gardencore.block.tile.TileEntityGardenFarmland;
import com.jaquadro.minecraft.gardencore.core.ModBlocks;
import com.jaquadro.minecraft.gardencore.core.ModCreativeTabs;
import cpw.mods.fml.relauncher.Side;
import cpw.mods.fml.relauncher.SideOnly;
import java.util.Random;
import net.minecraft.block.Block;
import net.minecraft.block.IGrowable;
import net.minecraft.block.material.Material;
import net.minecraft.client.renderer.texture.IIconRegister;
import net.minecraft.init.Blocks;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.util.AxisAlignedBB;
import net.minecraft.util.IIcon;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;
import net.minecraftforge.common.EnumPlantType;
import net.minecraftforge.common.IPlantable;
import net.minecraftforge.common.util.ForgeDirection;

public class BlockGardenFarmland
extends BlockGarden {
    @SideOnly(value=Side.CLIENT)
    IIcon iconTilledSoil;
    private static ItemStack substrate = new ItemStack(Blocks.field_150458_ak, 1);

    public BlockGardenFarmland(String blockName) {
        super(blockName, Material.field_151578_c);
        this.func_149647_a(ModCreativeTabs.tabGardenCore);
        this.func_149711_c(0.5f);
        this.func_149672_a(Block.field_149779_h);
        this.func_149676_a(0.0f, 0.0f, 0.0f, 1.0f, 0.9375f, 1.0f);
        if (GardenCore.config.enableTilledSoilGrowthBonus) {
            this.func_149675_a(true);
        }
        this.connectionProfile = new BasicConnectionProfile();
        this.slotShareProfile = new SlotShare0Profile();
        this.slotProfile = new BasicSlotProfile(new BasicSlotProfile.Slot[0]);
    }

    public AxisAlignedBB func_149668_a(World world, int x, int y, int z) {
        return AxisAlignedBB.func_72330_a((double)x, (double)y, (double)z, (double)(x + 1), (double)(y + 1), (double)(z + 1));
    }

    public boolean func_149662_c() {
        return false;
    }

    public boolean func_149686_d() {
        return false;
    }

    public boolean isFertile(World world, int x, int y, int z) {
        return true;
    }

    @Override
    public boolean canSustainPlant(IBlockAccess world, int x, int y, int z, ForgeDirection direction, IPlantable plantable) {
        EnumPlantType plantType = plantable.getPlantType(world, x, y, z);
        return plantType == EnumPlantType.Crop;
    }

    public void func_149674_a(World world, int x, int y, int z, Random random) {
        Block block = world.func_147439_a(x, y + 1, z);
        if (block instanceof IPlantable || block instanceof IGrowable) {
            block.func_149674_a(world, x, y + 1, z, random);
        }
    }

    public Item func_149650_a(int meta, Random rand, int fortune) {
        return Item.func_150898_a((Block)ModBlocks.gardenSoil);
    }

    @Override
    public TileEntityGarden createNewTileEntity(World world, int meta) {
        return new TileEntityGardenFarmland();
    }

    @Override
    public ItemStack getGardenSubstrate(IBlockAccess blockAccess, int x, int y, int z, int slot) {
        return substrate;
    }

    public IIcon func_149691_a(int side, int meta) {
        if (side == 1) {
            return this.iconTilledSoil;
        }
        return this.field_149761_L;
    }

    @SideOnly(value=Side.CLIENT)
    public void func_149651_a(IIconRegister iconRegister) {
        this.field_149761_L = iconRegister.func_94245_a("GardenCore:garden_dirt");
        this.iconTilledSoil = iconRegister.func_94245_a("GardenCore:garden_farmland");
    }
}

