/*
 * Decompiled with CFR 0.152.
 */
package igwmod.json;

import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonParser;
import cpw.mods.fml.common.Loader;
import cpw.mods.fml.common.ModContainer;
import igwmod.InfoSupplier;
import igwmod.WikiUtils;
import igwmod.api.WikiRegistry;
import igwmod.lib.IGWLog;
import java.io.IOException;
import java.io.InputStream;
import java.util.List;
import java.util.Map;
import net.minecraft.item.ItemStack;
import net.minecraft.util.ResourceLocation;
import org.apache.commons.io.IOUtils;
import org.apache.commons.lang3.StringUtils;

public class JsonRegistrator {
    public static void init() {
        for (ModContainer mod : Loader.instance().getActiveModList()) {
            try {
                InputStream jsonStream = InfoSupplier.getStreamForResource(new ResourceLocation(mod.getModId().toLowerCase() + ":wiki/" + "pageMappings.json"));
                List lines = IOUtils.readLines((InputStream)jsonStream);
                String jsonString = StringUtils.join((Iterable)lines, (String)"");
                JsonObject obj = new JsonParser().parse(jsonString).getAsJsonObject();
                for (Map.Entry entry : obj.entrySet()) {
                    String forwardedPage = (String)entry.getKey();
                    for (JsonElement forwardingPage : ((JsonElement)entry.getValue()).getAsJsonArray()) {
                        ItemStack stack = WikiUtils.getStackFromName(forwardingPage.getAsString());
                        if (stack != null) {
                            WikiRegistry.registerBlockAndItemPageEntry(stack, forwardedPage);
                            continue;
                        }
                        IGWLog.warning("Couldn't forward the page " + forwardingPage.getAsString() + "! Not a valid item name");
                    }
                }
                IGWLog.info("Successfully loaded IGW json file for mod " + mod.getName());
            }
            catch (IOException jsonStream) {
            }
            catch (Exception e) {
                IGWLog.warning("IGW json failed to load for mod " + mod.getName() + "! Details:");
                e.printStackTrace();
            }
        }
    }
}

