/*
 * Decompiled with CFR 0.152.
 */
package router.reborn.tileentity.chest;

import cpw.mods.fml.relauncher.Side;
import cpw.mods.fml.relauncher.SideOnly;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.UUID;
import net.minecraft.client.renderer.texture.IIconRegister;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.inventory.IInventory;
import net.minecraft.inventory.InventoryCrafting;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.item.crafting.CraftingManager;
import net.minecraft.item.crafting.IRecipe;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.nbt.NBTTagList;
import net.minecraft.tileentity.TileEntityHopper;
import net.minecraft.world.World;
import router.reborn.RouterReborn;
import router.reborn.tileentity.IUpgrades;
import router.reborn.tileentity.TileEntityChest;
import router.reborn.tileentity.chest.Recipe;
import router.reborn.tileentity.chest.UpgradePackager;
import router.reborn.tileentity.chest.Util;
import router.reborn.tileentity.chest.inventory.InventoryAutoCrafting;

public class UpgradePackagerAdvanced
extends Item
implements IUpgrades,
Serializable {
    CraftingManager crafter = null;
    InventoryAutoCrafting autocraft = new InventoryAutoCrafting();
    int mode = 0;
    boolean doEject = false;
    protected ItemStack[] slots = new ItemStack[9];
    protected int side = 6;
    private static final int itemsToPack = 3;
    String uniqueID = "";

    public UpgradePackagerAdvanced() {
        this.func_111206_d("chesteject");
        this.func_77625_d(1);
    }

    @SideOnly(value=Side.CLIENT)
    public void func_94581_a(IIconRegister par1IconRegister) {
        this.field_77791_bV = par1IconRegister.func_94245_a("RouterReborn:chestpackageradvanced");
    }

    public void readFromNBT(NBTTagCompound compound) {
        if (compound == null) {
            compound = new NBTTagCompound();
        }
        if ("".equals(this.uniqueID)) {
            this.uniqueID = compound.func_74779_i("uniqueID");
            if ("".equals(this.uniqueID)) {
                this.uniqueID = UUID.randomUUID().toString();
            }
        }
        this.mode = compound.func_74762_e("mode");
        this.doEject = compound.func_74767_n("doeject");
        this.side = compound.func_74762_e("side");
        NBTTagList items = compound.func_150295_c("ItemInventory", 10);
        this.slots = new ItemStack[9];
        for (int i = 0; i < items.func_74745_c(); ++i) {
            NBTTagCompound item = items.func_150305_b(i);
            int slot = item.func_74762_e("Slot");
            if (slot < 0 || slot >= this.slots.length) continue;
            this.slots[slot] = ItemStack.func_77949_a((NBTTagCompound)item);
        }
    }

    @Override
    public void doUpgradeUpdate(World world, int side, ItemStack[] upgrades, TileEntityChest tile, ItemStack myStack) {
        this.crafter = CraftingManager.func_77594_a();
        if (world.field_72995_K || world.func_82737_E() % 20L != 0L) {
            return;
        }
        this.readFromNBT(myStack.func_77978_p());
        TileEntityChest output = this.side < 6 ? tile.invs[side] : tile;
        int n = this.side = this.side == 6 ? side : this.side;
        if (output == null) {
            return;
        }
        int x = tile.field_145851_c;
        int y = tile.field_145848_d;
        int z = tile.field_145849_e;
        if (side == 0) {
            --y;
        }
        if (side == 1) {
            ++y;
        }
        if (side == 2) {
            --z;
        }
        if (side == 3) {
            ++z;
        }
        if (side == 4) {
            --x;
        }
        if (side == 5) {
            ++x;
        }
        block6: for (int i = 0; i < tile.func_70302_i_(); ++i) {
            ItemStack stack = tile.func_70301_a(i);
            if (stack == null) continue;
            String key = Item.func_150891_b((Item)stack.func_77973_b()) + ":" + stack.func_77960_j();
            ItemStack res2x2 = null;
            ItemStack res3x3 = null;
            Recipe item = UpgradePackager.map2x2.get(key);
            Recipe item2 = UpgradePackager.map3x3.get(key);
            if (item != null) {
                res2x2 = item.result;
            } else {
                UpgradePackager.map2x2.put(key, new Recipe(this.check2x2(stack, tile.func_145831_w()), 2));
            }
            if (item2 != null) {
                res3x3 = item2.result;
            } else {
                UpgradePackager.map3x3.put(key, new Recipe(this.check3x3(stack, tile.func_145831_w()), 3));
            }
            if (res2x2 == null && res3x3 == null) continue;
            boolean hasFilter = false;
            for (ItemStack itemStack : this.slots) {
                if (itemStack == null || !(itemStack.func_77973_b() instanceof IUpgrades) || !((IUpgrades)itemStack.func_77973_b()).isFilter()) continue;
                hasFilter = true;
                break;
            }
            if (!Util.checkFilter(stack, hasFilter ? this.slots : upgrades)) continue;
            switch (this.mode) {
                case 0: {
                    if (res2x2 != null && this.pack(stack, res2x2, (IInventory)tile, false, 3, (IInventory)output, this.side)) {
                        return;
                    }
                    if (res3x3 == null || !this.pack(stack, res3x3, (IInventory)tile, true, 3, (IInventory)output, this.side)) continue block6;
                    return;
                }
                case 1: {
                    if (res3x3 != null && this.pack(stack, res3x3, (IInventory)tile, true, 3, (IInventory)output, this.side)) {
                        return;
                    }
                    if (res2x2 == null || !this.pack(stack, res2x2, (IInventory)tile, false, 3, (IInventory)output, this.side)) continue block6;
                    return;
                }
                case 2: {
                    if (res2x2 == null || !this.pack(stack, res2x2, (IInventory)tile, false, 3, (IInventory)output, this.side)) continue block6;
                    return;
                }
                case 3: {
                    if (res3x3 == null || !this.pack(stack, res3x3, (IInventory)tile, true, 3, (IInventory)output, this.side)) continue block6;
                    return;
                }
            }
        }
    }

    private boolean pack(ItemStack craftItem, ItemStack result, IInventory tile, boolean isBig, int maxItems, IInventory addto, int side) {
        if (this.canInsertItem(result, addto)) {
            int count = this.countItems(craftItem, tile);
            int maxForaStack = 0;
            int removeItems = 0;
            int max = count / (isBig ? 9 : 4);
            if (count > 0 && max > 0) {
                maxForaStack = result.func_77976_d() / result.field_77994_a;
                count = Math.min(maxForaStack, max);
                count = Math.min(count, maxItems);
                removeItems = isBig ? 9 * count : 4 * count;
                ItemStack tmp = result.func_77946_l();
                tmp.field_77994_a = result.field_77994_a * count;
                ItemStack ret = null;
                if (side < 6) {
                    ret = TileEntityHopper.func_145889_a((IInventory)addto, (ItemStack)tmp, (int)side);
                    this.RemoveItem(craftItem, removeItems - (ret == null ? 0 : ret.field_77994_a * maxForaStack), tile);
                } else {
                    this.InsertItem(tmp, addto);
                }
                return true;
            }
        }
        return false;
    }

    public ItemStack func_77659_a(ItemStack itemstack, World world, EntityPlayer player) {
        if (!world.field_72995_K && !player.func_70093_af()) {
            player.openGui((Object)RouterReborn.instance, 8, world, (int)player.field_70165_t, (int)player.field_70163_u, (int)player.field_70161_v);
        }
        return itemstack;
    }

    public int func_77626_a(ItemStack stack) {
        return 1;
    }

    private int countItems(ItemStack item, IInventory tile) {
        int count = 0;
        for (int i = 0; i < tile.func_70302_i_(); ++i) {
            ItemStack scan = tile.func_70301_a(i);
            if (scan == null || scan.func_77973_b() != item.func_77973_b() || scan.func_77960_j() != item.func_77960_j() || !ItemStack.func_77970_a((ItemStack)scan, (ItemStack)item)) continue;
            count += scan.field_77994_a;
        }
        return count;
    }

    private void RemoveItem(ItemStack stack, int count, IInventory tile) {
        ItemStack item = stack.func_77946_l();
        for (int i = 0; i < tile.func_70302_i_(); ++i) {
            ItemStack scan = tile.func_70301_a(i);
            if (scan == null || scan.func_77973_b() != item.func_77973_b() || scan.func_77960_j() != item.func_77960_j() || !ItemStack.func_77970_a((ItemStack)scan, (ItemStack)item)) continue;
            int max = scan.field_77994_a;
            max = Math.min(max, count);
            scan.field_77994_a -= max;
            tile.func_70299_a(i, scan.field_77994_a == 0 ? null : scan);
            if ((count -= max) > 0) continue;
            return;
        }
    }

    private void InsertItem(ItemStack stack, IInventory tile) {
        ItemStack item = stack.func_77946_l();
        for (int i = 0; i < tile.func_70302_i_(); ++i) {
            ItemStack scan = tile.func_70301_a(i);
            if (scan != null) {
                if (scan.func_77973_b() != item.func_77973_b() || scan.func_77960_j() != item.func_77960_j() || !ItemStack.func_77970_a((ItemStack)scan, (ItemStack)item) || scan.field_77994_a >= scan.func_77976_d()) continue;
                int max = scan.func_77976_d() - scan.field_77994_a;
                max = Math.min(max, item.field_77994_a);
                item.field_77994_a -= max;
                scan.field_77994_a += max;
                tile.func_70299_a(i, scan);
                if (item.field_77994_a > 0) continue;
                return;
            }
            tile.func_70299_a(i, item.func_77946_l());
            return;
        }
    }

    private ItemStack check3x3(ItemStack stack, World worldObj) {
        ItemStack stack2 = stack.func_77946_l();
        stack2.field_77994_a = 1;
        this.autocraft.func_70299_a(0, stack2.func_77946_l());
        this.autocraft.func_70299_a(1, stack2.func_77946_l());
        this.autocraft.func_70299_a(2, stack2.func_77946_l());
        this.autocraft.func_70299_a(3, stack2.func_77946_l());
        this.autocraft.func_70299_a(4, stack2.func_77946_l());
        this.autocraft.func_70299_a(5, stack2.func_77946_l());
        this.autocraft.func_70299_a(6, stack2.func_77946_l());
        this.autocraft.func_70299_a(7, stack2.func_77946_l());
        this.autocraft.func_70299_a(8, stack2.func_77946_l());
        ItemStack res = this.findMatchingRecipe(this.autocraft, worldObj);
        return res;
    }

    private ItemStack check2x2(ItemStack stack, World world) {
        ItemStack stack2 = stack.func_77946_l();
        stack2.field_77994_a = 1;
        for (int i = 0; i < 9; ++i) {
            this.autocraft.func_70299_a(i, null);
        }
        this.autocraft.func_70299_a(3, stack2.func_77946_l());
        this.autocraft.func_70299_a(4, stack2.func_77946_l());
        this.autocraft.func_70299_a(6, stack2.func_77946_l());
        this.autocraft.func_70299_a(7, stack2.func_77946_l());
        ItemStack res = this.findMatchingRecipe(this.autocraft, world);
        return res;
    }

    private boolean canInsertItem(ItemStack stack, IInventory tile) {
        ItemStack item = stack.func_77946_l();
        for (int i = 0; i < tile.func_70302_i_(); ++i) {
            ItemStack scan = tile.func_70301_a(i);
            if (scan != null) {
                if (scan.func_77973_b() != item.func_77973_b() || scan.func_77960_j() != item.func_77960_j() || !ItemStack.func_77970_a((ItemStack)scan, (ItemStack)item) || scan.field_77994_a >= scan.func_77976_d()) continue;
                int max = scan.func_77976_d() - scan.field_77994_a;
                max = Math.min(max, item.field_77994_a);
                item.field_77994_a -= max;
                if (item.field_77994_a != 0) continue;
                return true;
            }
            return true;
        }
        return false;
    }

    private ArrayList<Integer> findMatchingItem(TileEntityChest tile, ItemStack item, int skip) {
        ArrayList<Integer> lst = new ArrayList<Integer>();
        for (int i = 0; i < tile.func_70302_i_(); ++i) {
            ItemStack scan = tile.func_70301_a(i);
            if (scan == null || scan.func_77973_b() != item.func_77973_b() || scan.func_77960_j() != item.func_77960_j() || !ItemStack.func_77970_a((ItemStack)scan, (ItemStack)item)) continue;
            lst.add(i);
        }
        return lst;
    }

    public ItemStack findMatchingRecipe(InventoryCrafting inventory, World world) {
        int j;
        int i = 0;
        ItemStack itemstack = null;
        ItemStack itemstack1 = null;
        for (j = 0; j < inventory.func_70302_i_(); ++j) {
            ItemStack itemstack2 = inventory.func_70301_a(j);
            if (itemstack2 == null) continue;
            if (i == 0) {
                itemstack = itemstack2;
            }
            if (i == 1) {
                itemstack1 = itemstack2;
            }
            ++i;
        }
        if (i == 2 && itemstack.func_77973_b() == itemstack1.func_77973_b() && itemstack.field_77994_a == 1 && itemstack1.field_77994_a == 1 && itemstack.func_77973_b().isRepairable()) {
            Item item = itemstack.func_77973_b();
            int j1 = item.func_77612_l() - itemstack.func_77952_i();
            int k = item.func_77612_l() - itemstack1.func_77952_i();
            int l = j1 + k + item.func_77612_l() * 5 / 100;
            int i1 = item.func_77612_l() - l;
            if (i1 < 0) {
                i1 = 0;
            }
            return new ItemStack(itemstack.func_77973_b(), 1, i1);
        }
        for (j = 0; j < this.crafter.func_77592_b().size(); ++j) {
            IRecipe irecipe = (IRecipe)this.crafter.func_77592_b().get(j);
            if (!irecipe.func_77569_a(inventory, world)) continue;
            return irecipe.func_77572_b(inventory);
        }
        return null;
    }

    @Override
    public int isWhitelistItemOK(ItemStack itemStack, ItemStack myStack) {
        return -1;
    }

    @Override
    public boolean isBlackItemOK(ItemStack itemStack, ItemStack myStack) {
        return true;
    }

    @Override
    public boolean isFilter() {
        return false;
    }
}

