/*
 * Decompiled with CFR 0.152.
 */
package org.mcupdater.autopackager;

import cofh.api.block.IDismantleable;
import cofh.lib.util.helpers.BlockHelper;
import cpw.mods.fml.relauncher.Side;
import cpw.mods.fml.relauncher.SideOnly;
import java.util.ArrayList;
import net.minecraft.block.BlockContainer;
import net.minecraft.block.material.Material;
import net.minecraft.client.renderer.texture.IIconRegister;
import net.minecraft.creativetab.CreativeTabs;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.item.EntityItem;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.ItemStack;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.IIcon;
import net.minecraft.world.World;
import net.minecraftforge.common.util.ForgeDirection;
import org.mcupdater.autopackager.AutoPackager;
import org.mcupdater.autopackager.TilePackager;
import org.mcupdater.shared.Position;
import org.mcupdater.shared.Utils;

public class BlockPackager
extends BlockContainer
implements IDismantleable {
    IIcon textureFront;
    IIcon textureSide;

    protected BlockPackager() {
        super(Material.field_151576_e);
        this.func_149711_c(10.0f);
        this.func_149752_b(10.0f);
        this.func_149672_a(field_149769_e);
        this.func_149663_c("packagerBlock");
        this.func_149647_a(CreativeTabs.field_78028_d);
    }

    public void func_149689_a(World world, int i, int j, int k, EntityLivingBase entityliving, ItemStack stack) {
        super.func_149689_a(world, i, j, k, entityliving, stack);
        ForgeDirection orientation = Utils.get2dOrientation(new Position(entityliving.field_70165_t, entityliving.field_70163_u, entityliving.field_70161_v), new Position(i, j, k));
        world.func_72921_c(i, j, k, orientation.getOpposite().ordinal(), 1);
        ((TilePackager)world.func_147438_o(i, j, k)).setOrientation(orientation);
    }

    public IIcon func_149691_a(int i, int j) {
        if (j == 0 && i == 3) {
            return this.textureFront;
        }
        if (i == j && i > 1) {
            return this.textureFront;
        }
        return this.textureSide;
    }

    @SideOnly(value=Side.CLIENT)
    public void func_149651_a(IIconRegister iconRegistry) {
        this.textureFront = iconRegistry.func_94245_a("autopackager:packager_front");
        this.textureSide = iconRegistry.func_94245_a("autopackager:packager_side");
    }

    public TileEntity func_149915_a(World world, int meta) {
        return new TilePackager();
    }

    public boolean func_149727_a(World world, int i, int j, int k, EntityPlayer player, int side, float par7, float par8, float par9) {
        TilePackager tile = (TilePackager)world.func_147438_o(i, j, k);
        if (player.func_71045_bC() == null) {
            if (player.func_70093_af()) {
                tile.cycleMode(player);
            } else {
                tile.checkMode(player);
            }
            return true;
        }
        return false;
    }

    public boolean rotateBlock(World world, int x, int y, int z, ForgeDirection axis) {
        int meta = world.func_72805_g(x, y, z);
        int newMeta = BlockHelper.getLeftSide((int)meta);
        world.func_72921_c(x, y, z, newMeta, 3);
        ((TilePackager)world.func_147438_o(x, y, z)).setOrientation(ForgeDirection.getOrientation((int)newMeta).getOpposite());
        return true;
    }

    public ArrayList<ItemStack> dismantleBlock(EntityPlayer entityPlayer, World world, int x, int y, int z, boolean placeInInventory) {
        ArrayList<ItemStack> dropped = new ArrayList<ItemStack>();
        dropped.add(new ItemStack(AutoPackager.packagerBlock));
        world.func_147468_f(x, y, z);
        float multiplier = 0.3f;
        double deltaX = (double)(world.field_73012_v.nextFloat() * multiplier) + (double)(1.0f - multiplier) * 0.5;
        double deltaY = (double)(world.field_73012_v.nextFloat() * multiplier) + (double)(1.0f - multiplier) * 0.5;
        double deltaZ = (double)(world.field_73012_v.nextFloat() * multiplier) + (double)(1.0f - multiplier) * 0.5;
        EntityItem spawnedItem = new EntityItem(world, (double)x + deltaX, (double)y + deltaY, (double)z + deltaZ, (ItemStack)dropped.get(0));
        spawnedItem.field_145804_b = 10;
        world.func_72838_d((Entity)spawnedItem);
        return dropped;
    }

    public boolean canDismantle(EntityPlayer entityPlayer, World world, int i, int i2, int i3) {
        return true;
    }
}

