/*
 * Decompiled with CFR 0.152.
 */
package info.inpureprojects.core.API.Utils;

import java.io.File;
import org.apache.commons.io.FileUtils;
import org.apache.commons.lang3.SystemUtils;
import org.apache.logging.log4j.Level;
import org.apache.logging.log4j.Logger;

public class LogWrapper {
    private Logger log;
    private File debug;

    public LogWrapper(Logger log, File debug) {
        this.log = log;
        this.debug = debug;
        if (this.debug != null && this.debug.exists()) {
            this.debug.delete();
        }
    }

    public Logger getLog() {
        return this.log;
    }

    public String IntArrayToString(int[] array) {
        String s = "";
        for (int i : array) {
            s = s + String.format("%s,", i);
        }
        return s.substring(0, s.length() - 1);
    }

    public void info(String msg) {
        this.log.info(msg);
        this.writeToLog(String.format(msg, new Object[0]));
    }

    public void info(String msg, Object ... data) {
        this.log.log(Level.INFO, String.format(msg, data));
        this.writeToLog(String.format(msg, data));
    }

    public void warn(String msg) {
        this.log.warn(msg);
        this.writeToLog(String.format(msg, new Object[0]));
    }

    public void warn(String msg, Object ... data) {
        this.log.log(Level.WARN, String.format(msg, data));
        this.writeToLog(String.format(msg, data));
    }

    public void debug(String msg) {
        this.log.debug(msg);
        this.writeToLog(msg);
    }

    public void debug(String msg, Object ... data) {
        this.log.log(Level.DEBUG, String.format(msg, data));
        this.writeToLog(String.format(msg, data));
    }

    public void bigWarning(String msg) {
        this.log.warn("--------------------------");
        this.log.warn(String.format(msg, new Object[0]));
        this.log.warn("--------------------------");
        this.writeToLog("--------------------------");
        this.writeToLog(String.format(msg, new Object[0]));
        this.writeToLog("--------------------------");
    }

    public void bigWarning(String msg, Object ... data) {
        this.log.warn("--------------------------");
        this.log.warn(String.format(msg, data));
        this.log.warn("--------------------------");
        this.writeToLog("--------------------------");
        this.writeToLog(String.format(msg, data));
        this.writeToLog("--------------------------");
    }

    private void writeToLog(String msg) {
        try {
            if (this.debug == null) {
                return;
            }
            FileUtils.writeStringToFile((File)this.debug, (String)msg.concat(SystemUtils.LINE_SEPARATOR), (boolean)true);
        }
        catch (Throwable t) {
            t.printStackTrace();
        }
    }
}

