/*
 * Decompiled with CFR 0.152.
 */
package powercrystals.powerconverters.common;

import cpw.mods.fml.relauncher.Side;
import cpw.mods.fml.relauncher.SideOnly;
import java.util.HashMap;
import java.util.Map;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.tileentity.TileEntity;
import net.minecraftforge.common.util.ForgeDirection;
import powercrystals.powerconverters.PowerConverterCore;
import powercrystals.powerconverters.common.BridgeSideData;
import powercrystals.powerconverters.position.BlockPosition;
import powercrystals.powerconverters.position.INeighboorUpdateTile;
import powercrystals.powerconverters.power.PowerSystem;
import powercrystals.powerconverters.power.base.TileEntityBridgeComponent;
import powercrystals.powerconverters.power.base.TileEntityEnergyConsumer;
import powercrystals.powerconverters.power.base.TileEntityEnergyProducer;
import powercrystals.powerconverters.power.util.ICustomHandler;

public class TileEntityEnergyBridge
extends TileEntity
implements INeighboorUpdateTile {
    private int _energyStored;
    private int _energyStoredMax = PowerConverterCore.bridgeBufferSize;
    private int _energyScaledClient;
    private int _energyStoredLast;
    private boolean _isInputLimited;
    private Map<ForgeDirection, TileEntityEnergyProducer<?>> _producerTiles = new HashMap();
    private Map<ForgeDirection, BridgeSideData> _clientSideData = new HashMap<ForgeDirection, BridgeSideData>();
    private Map<ForgeDirection, Integer> _producerOutputRates = new HashMap<ForgeDirection, Integer>();
    private boolean _initialized;

    public TileEntityEnergyBridge() {
        for (ForgeDirection d : ForgeDirection.VALID_DIRECTIONS) {
            this._clientSideData.put(d, new BridgeSideData());
            this._producerOutputRates.put(d, 0);
        }
    }

    public int getEnergyStored() {
        return this._energyStored;
    }

    public int getEnergyStoredMax() {
        return this._energyStoredMax;
    }

    public double storeEnergy(double energy, boolean simulate) {
        double toStore = Math.min(energy, (double)(this._energyStoredMax - this._energyStored));
        if (!simulate) {
            this._energyStored = (int)((double)this._energyStored + toStore);
        }
        return energy - toStore;
    }

    public double useEnergy(double energy, boolean simulate) {
        double toUse = Math.max(0.0, Math.min((double)this._energyStored, energy));
        if (!simulate) {
            this._energyStored = (int)((double)this._energyStored - toUse);
            this._isInputLimited = (this._energyStored != this._energyStoredLast || this._energyStored != this._energyStoredMax) && this._energyStored <= this._energyStoredLast;
            this._energyStoredLast = this._energyStored;
        }
        return toUse;
    }

    public void updateProducerInfo(ForgeDirection dir, int output) {
        this._producerOutputRates.put(dir, Math.max(0, output));
    }

    public void func_145845_h() {
        super.func_145845_h();
        if (!this._initialized) {
            this.onNeighboorChanged();
            this._initialized = true;
        }
        if (!this.field_145850_b.field_72995_K) {
            int energyRemaining = Math.min(this._energyStored, this._energyStoredMax);
            for (Map.Entry<ForgeDirection, TileEntityEnergyProducer<?>> prod : this._producerTiles.entrySet()) {
                if (prod.getValue() instanceof ICustomHandler && ((ICustomHandler)((Object)prod.getValue())).shouldHandle()) {
                    int temp = (int)((ICustomHandler)((Object)prod.getValue())).getOutputRate();
                    this.updateProducerInfo(prod.getKey(), temp);
                    continue;
                }
                if (energyRemaining > 0) {
                    PowerSystem producerPowerSystem;
                    int energyNotProduced = (int)prod.getValue().produceEnergy(energyRemaining);
                    if (energyNotProduced > energyRemaining) {
                        energyNotProduced = energyRemaining;
                    }
                    if ((producerPowerSystem = prod.getValue().getPowerSystem()) != null) {
                        this.updateProducerInfo(prod.getKey(), (int)((float)(energyRemaining - energyNotProduced) / producerPowerSystem.getInternalEnergyPerOutput(prod.getValue().field_145847_g)));
                    }
                    energyRemaining = energyNotProduced;
                    continue;
                }
                prod.getValue().produceEnergy(0.0);
                this.updateProducerInfo(prod.getKey(), 0);
            }
            this._energyStored = Math.max(0, energyRemaining);
            this._isInputLimited = (this._energyStored != this._energyStoredLast || this._energyStored != this._energyStoredMax) && this._energyStored <= this._energyStoredLast;
            this._energyStoredLast = this._energyStored;
        }
    }

    @Override
    public void onNeighboorChanged() {
        HashMap producerTiles = new HashMap();
        for (ForgeDirection d : ForgeDirection.VALID_DIRECTIONS) {
            BlockPosition p = new BlockPosition(this);
            p.orientation = d;
            p.moveForwards(1);
            TileEntity te = this.field_145850_b.func_147438_o(p.x, p.y, p.z);
            if (te == null || !(te instanceof TileEntityEnergyProducer)) continue;
            producerTiles.put(d, (TileEntityEnergyProducer)te);
        }
        this._producerTiles = producerTiles;
    }

    public BridgeSideData getDataForSide(ForgeDirection dir) {
        if (!this.field_145850_b.field_72995_K) {
            BridgeSideData d = new BridgeSideData();
            BlockPosition p = new BlockPosition(this);
            p.orientation = dir;
            p.moveForwards(1);
            TileEntity te = this.field_145850_b.func_147438_o(p.x, p.y, p.z);
            if (te != null && te instanceof TileEntityBridgeComponent) {
                if (te instanceof TileEntityEnergyConsumer) {
                    d.isConsumer = true;
                    d.outputRate = ((TileEntityEnergyConsumer)te).getInputRate();
                }
                if (te instanceof TileEntityEnergyProducer) {
                    d.isProducer = true;
                    d.outputRate = this._producerOutputRates.get(dir).intValue();
                }
                TileEntityBridgeComponent c = (TileEntityBridgeComponent)te;
                d.powerSystem = c.getPowerSystem();
                d.subtype = c.getSubtype();
                d.isConnected = c.isConnected();
                d.side = dir;
                d.voltageNameIndex = c.getVoltageIndex();
            }
            return d;
        }
        return this._clientSideData.get(dir);
    }

    public boolean isInputLimited() {
        return this._isInputLimited;
    }

    @SideOnly(value=Side.CLIENT)
    public void setIsInputLimited(boolean isInputLimited) {
        this._isInputLimited = isInputLimited;
    }

    public int getEnergyScaled() {
        if (this.field_145850_b.field_72995_K) {
            return this._energyScaledClient;
        }
        return (int)(120.0 * ((double)this._energyStored / (double)this._energyStoredMax));
    }

    public void setEnergyScaled(int scaled) {
        this._energyScaledClient = scaled;
    }

    public void setEnergyStored(int stored) {
        this._energyStored = stored;
    }

    public void func_145841_b(NBTTagCompound par1nbtTagCompound) {
        super.func_145841_b(par1nbtTagCompound);
        par1nbtTagCompound.func_74768_a("energyStored", this._energyStored);
    }

    public void func_145839_a(NBTTagCompound par1nbtTagCompound) {
        super.func_145839_a(par1nbtTagCompound);
        this._energyStored = par1nbtTagCompound.func_74762_e("energyStored");
    }
}

