/*
 * Decompiled with CFR 0.152.
 */
package boilerplate.common.utils;

import java.util.ArrayList;
import java.util.UUID;
import net.minecraft.block.Block;
import net.minecraft.block.material.Material;
import net.minecraft.enchantment.EnchantmentHelper;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.item.EntityItem;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.entity.player.InventoryPlayer;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.item.crafting.FurnaceRecipes;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.nbt.NBTTagList;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;

public class ItemStackUtils {
    public static Material getBlockMaterial(IBlockAccess world, int x, int y, int z) {
        if (world.func_147439_a(x, y, z) != null) {
            return world.func_147439_a(x, y, z).func_149688_o();
        }
        return Material.field_151579_a;
    }

    public static ItemStack getDroppedItemStack(World world, EntityPlayer player, Block block, int x, int y, int z, int md) {
        ArrayList items = block.getDrops(world, x, y, z, md, EnchantmentHelper.func_77517_e((EntityLivingBase)player));
        ItemStack drops = null;
        if (items != null && items.size() > 0) {
            for (int size = 0; size < items.size(); ++size) {
                drops = (ItemStack)items.get(size);
            }
        }
        return drops;
    }

    public static boolean isSmeltable(ItemStack is) {
        return is == null || FurnaceRecipes.func_77602_a().func_151395_a(is) != null;
    }

    public static void spawnStackInWorld(World world, int x, int y, int z, ItemStack stack) {
        world.func_147468_f(x, y, z);
        world.func_72838_d((Entity)new EntityItem(world, (double)((float)x + 0.5f), (double)((float)y + 0.5f), (double)((float)z + 0.5f), stack.func_77946_l()));
    }

    public static void addModifier(ItemStack itemStack, String attribute, double amount, int mode) {
        NBTTagList list = new NBTTagList();
        NBTTagCompound attributes = new NBTTagCompound();
        attributes.func_74778_a("Name", "Attribute");
        attributes.func_74778_a("AttributeName", attribute);
        attributes.func_74780_a("Amount", amount);
        attributes.func_74772_a("UUIDMost", UUID.randomUUID().getMostSignificantBits());
        attributes.func_74772_a("UUIDLeast", UUID.randomUUID().getLeastSignificantBits());
        attributes.func_74768_a("Operation", mode);
        list.func_74742_a((NBTBase)attributes);
        NBTTagCompound attributeModifierTag = itemStack.func_77978_p();
        attributeModifierTag.func_74782_a("AttributeModifiers", (NBTBase)list);
        itemStack.func_77982_d(attributeModifierTag);
    }

    public static int getStackPosition(InventoryPlayer inventory, Item item) {
        for (int i = 0; i < inventory.func_70302_i_(); ++i) {
            if (inventory.func_70301_a(i) == null || item != inventory.func_70301_a(i).func_77973_b()) continue;
            return i;
        }
        return -1;
    }

    public static ItemStack copyStackWithAmount(ItemStack stack, int amount) {
        if (stack == null) {
            return null;
        }
        ItemStack s2 = stack.func_77946_l();
        s2.field_77994_a = amount;
        return s2;
    }

    public static boolean isItemNonNull(ItemStack itemStack) {
        return itemStack != null && itemStack.func_77973_b() != null;
    }

    public static boolean isItemInstanceOf(ItemStack itemStack, Class itemClass) {
        return ItemStackUtils.isItemNonNull(itemStack) && itemClass != null && itemClass.isInstance(itemStack.func_77973_b());
    }
}

