/*
 * Decompiled with CFR 0.152.
 */
package boilerplate.common.utils;

import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.inventory.IInventory;
import net.minecraft.inventory.InventoryBasic;
import net.minecraft.inventory.InventoryEnderChest;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;

public class InventoryUtils {
    public static InventoryEnderChest getPlayerEnderChest(EntityPlayer p) {
        return p.func_71005_bN();
    }

    public static boolean addItemStackToInventory(IInventory inv, ItemStack is) {
        if (!is.func_77951_h()) {
            int stackSize;
            do {
                stackSize = is.field_77994_a;
                is.field_77994_a = InventoryUtils.storePartially(inv, is);
            } while (is.field_77994_a > 0 && is.field_77994_a < stackSize);
            return is.field_77994_a < stackSize;
        }
        int slot = InventoryUtils.getFirstEmptySlot(inv, is);
        if (slot >= 0) {
            inv.func_70299_a(slot, ItemStack.func_77944_b((ItemStack)is));
            is.field_77994_a = 0;
            return true;
        }
        return false;
    }

    public static int storePartially(IInventory inv, ItemStack is) {
        int canStore;
        Item item = is.func_77973_b();
        int size = is.field_77994_a;
        if (is.func_77976_d() == 1) {
            int freeSlot = InventoryUtils.getFirstEmptySlot(inv, is);
            if (freeSlot < 0) {
                return size;
            }
            if (inv.func_70301_a(freeSlot) == null) {
                inv.func_70299_a(freeSlot, ItemStack.func_77944_b((ItemStack)is));
            }
            return 0;
        }
        int freeSlot = InventoryUtils.getNonFilledStack(inv, is);
        if (freeSlot < 0) {
            freeSlot = InventoryUtils.getFirstEmptySlot(inv, is);
        }
        if (freeSlot < 0) {
            return size;
        }
        if (inv.func_70301_a(freeSlot) == null) {
            inv.func_70299_a(freeSlot, new ItemStack(item, 0, is.func_77960_j()));
        }
        if ((canStore = size) > inv.func_70301_a(freeSlot).func_77976_d() - inv.func_70301_a((int)freeSlot).field_77994_a) {
            canStore = inv.func_70301_a(freeSlot).func_77976_d() - inv.func_70301_a((int)freeSlot).field_77994_a;
        }
        if (canStore > inv.func_70297_j_() - inv.func_70301_a((int)freeSlot).field_77994_a) {
            canStore = inv.func_70297_j_() - inv.func_70301_a((int)freeSlot).field_77994_a;
        }
        if (canStore == 0) {
            return size;
        }
        inv.func_70301_a((int)freeSlot).field_77994_a += canStore;
        return size -= canStore;
    }

    public static int getNonFilledStack(IInventory inv, ItemStack is) {
        for (int slot = 0; slot < inv.func_70302_i_(); ++slot) {
            ItemStack stackInSlot = inv.func_70301_a(slot);
            if (stackInSlot == null || stackInSlot.func_77973_b() != is.func_77973_b() || !stackInSlot.func_77985_e() || stackInSlot.field_77994_a >= stackInSlot.func_77976_d() || stackInSlot.field_77994_a >= inv.func_70297_j_() || stackInSlot.func_77981_g() && stackInSlot.func_77960_j() != is.func_77960_j()) continue;
            return slot;
        }
        return -1;
    }

    public static int getFirstEmptySlot(IInventory inv, ItemStack is) {
        for (int slot = 0; slot < inv.func_70302_i_(); ++slot) {
            if (inv.func_70301_a(slot) != null) continue;
            return slot;
        }
        return -1;
    }

    public static int isInPlayerInventory(EntityPlayer player, Item item) {
        for (int slot = 0; slot < player.field_71071_by.field_70462_a.length; ++slot) {
            if (player.field_71071_by.field_70462_a[slot] == null || player.field_71071_by.field_70462_a[slot].func_77973_b() != item) continue;
            return slot;
        }
        return -1;
    }

    public static boolean isInvEmpty(IInventory inv, ItemStack is) {
        return InventoryUtils.addItemStackToInventory(inv, is);
    }

    public static int isInInventory(InventoryBasic inventory, ItemStack stack) {
        for (int slot = 0; slot < inventory.func_70302_i_(); ++slot) {
            if (inventory.func_70301_a(slot) == null || inventory.func_70301_a(slot) != stack) continue;
            return slot;
        }
        return -1;
    }

    public static ItemStack getItemStackInInventory(EntityPlayer player, ItemStack stack) {
        for (ItemStack element : player.field_71071_by.field_70462_a) {
            if (element != stack) continue;
            return element;
        }
        return null;
    }
}

