/*
 * Decompiled with CFR 0.152.
 */
package boilerplate.common.utils;

import boilerplate.common.utils.ItemStackUtils;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.entity.player.EntityPlayerMP;
import net.minecraft.item.ItemStack;
import net.minecraft.world.World;
import net.minecraftforge.common.util.ForgeDirection;
import net.minecraftforge.fluids.FluidContainerRegistry;
import net.minecraftforge.fluids.FluidStack;
import net.minecraftforge.fluids.FluidTank;
import net.minecraftforge.fluids.IFluidContainerItem;
import net.minecraftforge.fluids.IFluidHandler;

public class FluidUtils {
    public static ItemStack fillFluidContainer(FluidTank tank, ItemStack containerIn) {
        ItemStack filledContainer;
        if (tank.getFluidAmount() > 0 && FluidContainerRegistry.isEmptyContainer((ItemStack)containerIn) && (filledContainer = FluidContainerRegistry.fillFluidContainer((FluidStack)tank.getFluid(), (ItemStack)containerIn)) != null) {
            FluidStack fs = FluidContainerRegistry.getFluidForFilledItem((ItemStack)filledContainer);
            if (fs.amount <= tank.getFluidAmount()) {
                tank.drain(fs.amount, true);
                return filledContainer;
            }
        }
        return null;
    }

    public static ItemStack drainFluidContainer(FluidTank tank, ItemStack containerIn) {
        ItemStack emptyContainer;
        FluidStack fs;
        if (FluidContainerRegistry.isFilledContainer((ItemStack)containerIn) && (fs = FluidContainerRegistry.getFluidForFilledItem((ItemStack)containerIn)) != null && tank.getFluidAmount() + fs.amount <= tank.getCapacity() && (emptyContainer = FluidContainerRegistry.drainFluidContainer((ItemStack)containerIn)) != null && tank.fill(fs, true) == fs.amount) {
            return emptyContainer;
        }
        return null;
    }

    public static boolean fillFluidHandlerWithPlayerItem(World world, IFluidHandler handler, EntityPlayer player) {
        IFluidContainerItem container;
        ItemStack equipped = player.func_71045_bC();
        if (equipped == null) {
            return false;
        }
        FluidStack fluid = FluidContainerRegistry.getFluidForFilledItem((ItemStack)equipped);
        if (fluid != null) {
            if (handler.fill(ForgeDirection.UNKNOWN, fluid, false) == fluid.amount || player.field_71075_bZ.field_75098_d) {
                if (world.field_72995_K) {
                    return true;
                }
                ItemStack filledStack = FluidContainerRegistry.drainFluidContainer((ItemStack)equipped);
                if (!player.field_71075_bZ.field_75098_d) {
                    if (equipped.field_77994_a == 1) {
                        player.field_71071_by.func_70299_a(player.field_71071_by.field_70461_c, null);
                        player.field_71071_by.func_70441_a(filledStack);
                    } else {
                        --equipped.field_77994_a;
                        if (filledStack != null && !player.field_71071_by.func_70441_a(filledStack)) {
                            player.func_146097_a(filledStack, false, true);
                        }
                    }
                    player.field_71070_bA.func_75142_b();
                    ((EntityPlayerMP)player).func_71110_a(player.field_71070_bA, player.field_71070_bA.func_75138_a());
                }
                handler.fill(ForgeDirection.UNKNOWN, fluid, true);
                return true;
            }
        } else if (equipped.func_77973_b() instanceof IFluidContainerItem && handler.fill(ForgeDirection.UNKNOWN, fluid = (container = (IFluidContainerItem)equipped.func_77973_b()).getFluid(equipped), false) > 0) {
            if (world.field_72995_K) {
                return true;
            }
            int fill = handler.fill(ForgeDirection.UNKNOWN, fluid, true);
            if (equipped.field_77994_a > 1) {
                ItemStack emptied = ItemStackUtils.copyStackWithAmount(equipped, 1);
                --equipped.field_77994_a;
                container.drain(emptied, fill, true);
                if (!player.field_71071_by.func_70441_a(emptied)) {
                    player.func_146097_a(emptied, false, true);
                }
            } else {
                container.drain(equipped, fill, true);
            }
            player.field_71070_bA.func_75142_b();
            ((EntityPlayerMP)player).func_71110_a(player.field_71070_bA, player.field_71070_bA.func_75138_a());
            return true;
        }
        return false;
    }
}

