/*
 * Decompiled with CFR 0.152.
 */
package boilerplate.common.utils;

import cofh.api.energy.IEnergyHandler;
import net.minecraftforge.common.util.ForgeDirection;
import net.minecraftforge.fluids.FluidStack;
import net.minecraftforge.fluids.IFluidHandler;

public class ComparatorUtils {
    public static int scaleStoredEnergyTo(int scale, IEnergyHandler energyHandler) {
        return ComparatorUtils.scaleStoredEnergyTo(scale, energyHandler, ForgeDirection.UNKNOWN);
    }

    public static int scaleStoredEnergyTo(int scale, IEnergyHandler energyHandler, ForgeDirection direction) {
        return ComparatorUtils.scaleTo(scale, energyHandler.getEnergyStored(direction), energyHandler.getMaxEnergyStored(direction));
    }

    public static int scaleSingleFluidLevelTo(int scale, IFluidHandler fluidHandler) {
        return ComparatorUtils.scaleSingleFluidLevelTo(scale, fluidHandler, ForgeDirection.UNKNOWN);
    }

    public static int scaleSingleFluidLevelTo(int scale, IFluidHandler fluidHandler, ForgeDirection direction) {
        FluidStack fluidStack;
        if (fluidHandler.getTankInfo(direction) != null && fluidHandler.getTankInfo(direction)[0] != null && (fluidStack = fluidHandler.getTankInfo((ForgeDirection)direction)[0].fluid) != null) {
            return ComparatorUtils.scaleTo(scale, fluidStack.amount, fluidHandler.getTankInfo((ForgeDirection)direction)[0].capacity);
        }
        return 0;
    }

    public static int scaleTo(int scale, int currentLevel, int topLevel) {
        return (int)((float)(scale * currentLevel) / (float)topLevel);
    }
}

