/*
 * Decompiled with CFR 0.152.
 */
package boilerplate.common.baseclasses.items.electric;

import boilerplate.api.IEnergyItem;
import boilerplate.common.baseclasses.items.tools.BaseTool;
import java.util.List;
import net.minecraft.creativetab.CreativeTabs;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.world.World;

public class ItemElectricTool
extends BaseTool
implements IEnergyItem {
    protected int maxEnergy = 0;
    protected short maxReceive = 0;
    protected int energyPerBlock = 0;

    protected ItemElectricTool(float damage, Item.ToolMaterial toolMat, int maxEnergy, int maxReceive) {
        super(damage, toolMat);
        this.maxEnergy = maxEnergy * 1000;
        this.maxReceive = (short)maxReceive;
        this.func_77625_d(1);
        this.setNoRepair();
    }

    @Override
    public void func_150895_a(Item item, CreativeTabs tab, List list) {
        list.add(this.getUnchargedItem(item));
        list.add(this.getChargedItem(item));
    }

    public ItemStack getUnchargedItem(Item item) {
        ItemStack uncharged = new ItemStack(item);
        if (!uncharged.func_77942_o()) {
            uncharged.func_77982_d(new NBTTagCompound());
        }
        uncharged.func_77978_p().func_74768_a("energy", 0);
        return uncharged.func_77946_l();
    }

    public ItemStack getChargedItem(Item item) {
        ItemStack charged = new ItemStack(item);
        if (!charged.func_77942_o()) {
            charged.func_77982_d(new NBTTagCompound());
        }
        charged.func_77978_p().func_74768_a("energy", this.maxEnergy);
        return charged.func_77946_l();
    }

    @Override
    public void func_77624_a(ItemStack stack, EntityPlayer entityplayer, List list, boolean flag) {
        list.add("Energy: " + this.getEnergyStored(stack) / 1000 + "k / " + this.maxEnergy / 1000 + "k");
        list.add("Transfer(in): " + this.maxReceive);
    }

    public void func_77622_d(ItemStack stack, World par2World, EntityPlayer par3EntityPlayer) {
        this.setEnergy(stack, 0);
    }

    public void setEnergy(ItemStack stack, int energy) {
        if (!stack.func_77942_o()) {
            stack.func_77982_d(new NBTTagCompound());
        }
        NBTTagCompound tag = stack.func_77978_p();
        if (energy < 0) {
            energy = 0;
        }
        if (energy > this.maxEnergy) {
            energy = this.maxEnergy;
        }
        tag.func_74768_a("energy", energy);
        stack.func_77982_d(tag);
    }

    @Override
    public int receiveEnergy(ItemStack itemStack, int maxReceive, boolean simulate) {
        int received = Math.min(this.maxEnergy - this.getEnergyStored(itemStack), maxReceive);
        received = Math.min(received, this.maxReceive);
        if (!simulate) {
            this.setEnergy(itemStack, this.getEnergyStored(itemStack) + received);
        }
        return received;
    }

    @Override
    public int extractEnergy(ItemStack itemStack, int maxExtract, boolean simulate) {
        return 0;
    }

    @Override
    public int getEnergyStored(ItemStack stack) {
        return ItemElectricTool.getOrCreateTagCompound(stack).func_74762_e("energy");
    }

    public static NBTTagCompound getOrCreateTagCompound(ItemStack is) {
        if (!is.func_77942_o()) {
            is.func_77982_d(new NBTTagCompound());
            is.func_77978_p().func_74768_a("energy", 0);
        }
        return is.func_77978_p();
    }

    @Override
    public int getMaxEnergyStored(ItemStack container) {
        return this.maxEnergy;
    }

    @Override
    public short getMaxSend() {
        return 0;
    }

    public double getDurabilityForDisplay(ItemStack stack) {
        return 1.0 - (double)this.getEnergyStored(stack) / (double)this.getMaxEnergyStored(stack);
    }

    public boolean showDurabilityBar(ItemStack stack) {
        return true;
    }

    @Override
    public int func_77619_b() {
        return 0;
    }

    public boolean isBookEnchantable(ItemStack itemstack1, ItemStack itemstack2) {
        return false;
    }
}

