/*
 * Decompiled with CFR 0.152.
 */
package boilerplate.common.baseclasses;

import cpw.mods.fml.relauncher.Side;
import cpw.mods.fml.relauncher.SideOnly;
import java.util.List;
import net.minecraft.block.Block;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.IProjectile;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.util.AxisAlignedBB;
import net.minecraft.util.MathHelper;
import net.minecraft.util.MovingObjectPosition;
import net.minecraft.util.Vec3;
import net.minecraft.world.World;

public abstract class BaseShootableEntity
extends Entity
implements IProjectile {
    protected int xTile = -1;
    protected int yTile = -1;
    protected int zTile = -1;
    protected Block inTile;
    protected Entity shootingEntity;
    protected int timeTillDeath;
    protected int flyTime;
    protected int accuracy;

    public BaseShootableEntity(World world) {
        super(world);
        this.func_70105_a(1.0f, 1.0f);
        this.field_70155_l = 10.0;
    }

    @SideOnly(value=Side.CLIENT)
    public boolean func_70112_a(double distance) {
        double d1 = this.field_70121_D.func_72320_b() * 4.0;
        return distance < (d1 *= 64.0) * d1;
    }

    public BaseShootableEntity(World world, double dx, double dy, double dz) {
        super(world);
        this.func_70105_a(1.0f, 1.0f);
        this.field_70155_l = 10.0;
        this.func_70105_a(0.5f, 0.5f);
        this.func_70107_b(dx, dy, dz);
        this.field_70129_M = 0.0f;
    }

    public BaseShootableEntity(World world, EntityLivingBase shooter, EntityLivingBase target, float frotY, float frotP) {
        super(world);
        this.field_70155_l = 10.0;
        this.shootingEntity = shooter;
        this.field_70163_u = shooter.field_70163_u + (double)shooter.func_70047_e() - (double)0.1f;
        double dx = target.field_70165_t - shooter.field_70165_t;
        double dy = target.field_70121_D.field_72338_b + (double)(target.field_70131_O / 3.0f) - this.field_70163_u;
        double dz = target.field_70161_v - shooter.field_70161_v;
        double magnitude = MathHelper.func_76133_a((double)(dx * dx + dz * dz));
        if (magnitude >= 1.0E-7) {
            float fx = (float)(Math.atan2(dz, dx) * 180.0 / Math.PI) - 90.0f;
            float fy = (float)(-(Math.atan2(dy, magnitude) * 180.0 / Math.PI));
            double dlx = dx / magnitude;
            double dlz = dz / magnitude;
            this.func_70012_b(shooter.field_70165_t + dlx, this.field_70163_u, shooter.field_70161_v + dlz, fx, fy);
            this.field_70129_M = 0.0f;
            float height = (float)magnitude * 0.2f;
            this.func_70186_c(dx, dy + (double)height, dz, frotY, frotP);
        }
    }

    public BaseShootableEntity(World world, EntityLivingBase shooter, int damage, int accuracy) {
        super(world);
        this.field_70155_l = 10.0;
        this.shootingEntity = shooter;
        this.func_70105_a(0.5f, 0.5f);
        this.func_70012_b(shooter.field_70165_t, shooter.field_70163_u + (double)shooter.func_70047_e(), shooter.field_70161_v, shooter.field_70177_z, shooter.field_70125_A);
        this.field_70165_t -= (double)(MathHelper.func_76134_b((float)(this.field_70177_z / 180.0f * (float)Math.PI)) * 0.16f);
        this.field_70163_u -= (double)0.1f;
        this.field_70161_v -= (double)(MathHelper.func_76126_a((float)(this.field_70177_z / 180.0f * (float)Math.PI)) * 0.16f);
        this.func_70107_b(this.field_70165_t, this.field_70163_u, this.field_70161_v);
        this.field_70129_M = 0.0f;
        this.field_70159_w = -MathHelper.func_76126_a((float)(this.field_70177_z / 180.0f * (float)Math.PI)) * MathHelper.func_76134_b((float)(this.field_70125_A / 180.0f * (float)Math.PI));
        this.field_70179_y = MathHelper.func_76134_b((float)(this.field_70177_z / 180.0f * (float)Math.PI)) * MathHelper.func_76134_b((float)(this.field_70125_A / 180.0f * (float)Math.PI));
        this.field_70181_x = -MathHelper.func_76126_a((float)(this.field_70125_A / 180.0f * (float)Math.PI));
        this.func_70186_c(this.field_70159_w, this.field_70181_x, this.field_70179_y, 1.0f, accuracy);
        this.accuracy = accuracy;
    }

    public void func_70186_c(double dx, double dy, double dz, float frotY, float frotP) {
        int accuracy = this.accuracy;
        float f2 = MathHelper.func_76133_a((double)(dx * dx + dy * dy + dz * dz));
        dx /= (double)f2;
        dy /= (double)f2;
        dz /= (double)f2;
        dx += this.field_70146_Z.nextGaussian() * 0.0034999998323619365 * (double)frotP * (double)accuracy / 5.0;
        dy += this.field_70146_Z.nextGaussian() * 0.0034999998323619365 * (double)frotP * (double)accuracy / 5.0;
        dz += this.field_70146_Z.nextGaussian() * 0.0034999998323619365 * (double)frotP * (double)accuracy / 5.0;
        this.field_70159_w = dx *= (double)frotY;
        this.field_70181_x = dy *= (double)frotY;
        this.field_70179_y = dz *= (double)frotY;
        float magnitude = MathHelper.func_76133_a((double)(dx * dx + dz * dz));
        this.field_70126_B = this.field_70177_z = (float)(Math.atan2(dx, dz) * 180.0 / 3.1415927410125732);
        this.field_70127_C = this.field_70125_A = (float)(Math.atan2(dy, magnitude) * 180.0 / 3.1415927410125732);
        this.timeTillDeath = 0;
    }

    @SideOnly(value=Side.CLIENT)
    public void func_70056_a(double dx, double dy, double dz, float frotY, float frotP, int i) {
        this.func_70107_b(dx, dy, dz);
        this.func_70101_b(frotY, frotP);
    }

    @SideOnly(value=Side.CLIENT)
    public void func_70016_h(double dx, double dy, double dz) {
        this.field_70159_w = dx;
        this.field_70181_x = dy;
        this.field_70179_y = dz;
        if (this.field_70127_C == 0.0f && this.field_70126_B == 0.0f) {
            float magnitude = MathHelper.func_76133_a((double)(dx * dx + dz * dz));
            this.field_70126_B = this.field_70177_z = (float)(Math.atan2(dx, dz) * 180.0 / 3.1415927410125732);
            this.field_70127_C = this.field_70125_A = (float)(Math.atan2(dy, magnitude) * 180.0 / 3.1415927410125732);
        }
    }

    public void func_70071_h_() {
        super.func_70071_h_();
        if (this.flyTime > 1000) {
            this.func_70106_y();
        }
        if (this.field_70127_C == 0.0f && this.field_70126_B == 0.0f) {
            float magnitude = MathHelper.func_76133_a((double)(this.field_70159_w * this.field_70159_w + this.field_70179_y * this.field_70179_y));
            this.field_70126_B = this.field_70177_z = (float)(Math.atan2(this.field_70159_w, this.field_70179_y) * 180.0 / 3.1415927410125732);
            this.field_70127_C = this.field_70125_A = (float)(Math.atan2(this.field_70181_x, magnitude) * 180.0 / 3.1415927410125732);
        }
        ++this.flyTime;
        Vec3 posVector = Vec3.func_72443_a((double)this.field_70165_t, (double)this.field_70163_u, (double)this.field_70161_v);
        Vec3 velVector = Vec3.func_72443_a((double)(this.field_70165_t + this.field_70159_w), (double)(this.field_70163_u + this.field_70181_x), (double)(this.field_70161_v + this.field_70179_y));
        MovingObjectPosition mop = this.field_70170_p.func_72901_a(posVector, velVector, false);
        posVector = Vec3.func_72443_a((double)this.field_70165_t, (double)this.field_70163_u, (double)this.field_70161_v);
        velVector = Vec3.func_72443_a((double)(this.field_70165_t + this.field_70159_w), (double)(this.field_70163_u + this.field_70181_x), (double)(this.field_70161_v + this.field_70179_y));
        if (mop != null) {
            velVector = Vec3.func_72443_a((double)mop.field_72307_f.field_72450_a, (double)mop.field_72307_f.field_72448_b, (double)mop.field_72307_f.field_72449_c);
        }
        Entity entity = null;
        List entList = this.field_70170_p.func_72839_b((Entity)this, this.field_70121_D.func_72321_a(this.field_70159_w, this.field_70181_x, this.field_70179_y).func_72314_b(1.0, 1.0, 1.0));
        double distance = 0.0;
        for (Object obj : entList) {
            double distanceToObject;
            float amount;
            AxisAlignedBB aaBB;
            MovingObjectPosition objectInVector;
            Entity collidableEnt = (Entity)obj;
            if (!collidableEnt.func_70067_L() || collidableEnt == this.shootingEntity && this.flyTime < 5 || (objectInVector = (aaBB = collidableEnt.field_70121_D.func_72314_b((double)(amount = 0.3f), (double)amount, (double)amount)).func_72327_a(posVector, velVector)) == null || !((distanceToObject = posVector.func_72438_d(objectInVector.field_72307_f)) < distance) && distance != 0.0) continue;
            entity = collidableEnt;
            distance = distanceToObject;
        }
        if (entity != null) {
            mop = new MovingObjectPosition(entity);
        }
        if (mop != null) {
            if (mop.field_72308_g != null) {
                if (mop.field_72308_g != this.shootingEntity) {
                    this.onHitEntity(mop.field_72308_g);
                    this.field_70159_w *= (double)0.1f;
                    this.field_70181_x *= (double)0.1f;
                    this.field_70179_y *= (double)0.1f;
                    this.flyTime = 0;
                    this.func_70106_y();
                }
            } else {
                this.xTile = mop.field_72311_b;
                this.yTile = mop.field_72312_c;
                this.zTile = mop.field_72309_d;
                this.inTile = this.field_70170_p.func_147439_a(this.xTile, this.yTile, this.zTile);
                this.onHitBlock(this.inTile, mop);
            }
        }
        this.field_70165_t += this.field_70159_w * 3.0;
        this.field_70163_u += this.field_70181_x * 3.0;
        this.field_70161_v += this.field_70179_y * 3.0;
        float magnitude = MathHelper.func_76133_a((double)(this.field_70159_w * this.field_70159_w + this.field_70179_y * this.field_70179_y));
        this.field_70177_z = (float)(Math.atan2(this.field_70159_w, this.field_70179_y) * 180.0 / 3.1415927410125732);
        this.field_70125_A = (float)(Math.atan2(this.field_70181_x, magnitude) * 180.0 / 3.1415927410125732);
        while (this.field_70125_A - this.field_70127_C < -180.0f) {
            this.field_70127_C -= 360.0f;
        }
        while (this.field_70125_A - this.field_70127_C >= 180.0f) {
            this.field_70127_C += 360.0f;
        }
        while (this.field_70177_z - this.field_70126_B < -180.0f) {
            this.field_70126_B -= 360.0f;
        }
        while (this.field_70177_z - this.field_70126_B >= 180.0f) {
            this.field_70126_B += 360.0f;
        }
        this.field_70125_A = this.field_70127_C + (this.field_70125_A - this.field_70127_C) * 0.2f;
        this.field_70177_z = this.field_70126_B + (this.field_70177_z - this.field_70126_B) * 0.2f;
        float speed = 0.99f;
        if (this.func_70072_I()) {
            this.func_70106_y();
        }
        this.field_70159_w *= (double)speed;
        this.field_70181_x *= (double)speed;
        this.field_70179_y *= (double)speed;
        this.func_70107_b(this.field_70165_t, this.field_70163_u, this.field_70161_v);
        if (this.field_70170_p.field_72995_K) {
            this.field_70170_p.func_72869_a("explode", this.field_70165_t, this.field_70163_u, this.field_70161_v, 0.0, 0.0, 0.0);
        }
    }

    public void func_70014_b(NBTTagCompound tagCompound) {
        tagCompound.func_74777_a("xTile", (short)this.xTile);
        tagCompound.func_74777_a("yTile", (short)this.yTile);
        tagCompound.func_74777_a("zTile", (short)this.zTile);
    }

    public void func_70037_a(NBTTagCompound tagCompound) {
        this.xTile = tagCompound.func_74765_d("xTile");
        this.yTile = tagCompound.func_74765_d("yTile");
        this.zTile = tagCompound.func_74765_d("zTile");
    }

    protected boolean func_70041_e_() {
        return false;
    }

    @SideOnly(value=Side.CLIENT)
    public float func_70053_R() {
        return 0.0f;
    }

    public boolean func_70075_an() {
        return false;
    }

    public void func_70088_a() {
    }

    public abstract void onHitEntity(Entity var1);

    public abstract void onHitBlock(Block var1, MovingObjectPosition var2);
}

