/*
 * Decompiled with CFR 0.152.
 */
package boilerplate.client.utils;

import boilerplate.client.ClientHelper;
import java.util.Random;
import net.minecraft.client.particle.EntityFX;
import net.minecraft.client.particle.EntityFlameFX;
import net.minecraft.client.particle.EntitySmokeFX;
import net.minecraft.world.World;
import org.lwjgl.opengl.GL11;

public class EffectUtils {
    private static EntityFX particle;

    public static void sparkle(World world, int x, int y, int z, String particleName) {
        Random random = world.field_73012_v;
        double offset = 0.0625;
        for (int amount = 0; amount < 6; ++amount) {
            double dx = (float)x + random.nextFloat();
            double dy = (float)y + random.nextFloat();
            double dz = (float)z + random.nextFloat();
            if (amount == 0 && !world.func_147445_c(x, y + 1, z, false)) {
                dy = (double)(y + 1) + 0.0625;
            }
            if (amount == 1 && !world.func_147445_c(x, y - 1, z, false)) {
                dy = (double)(y + 0) - 0.0625;
            }
            if (amount == 2 && !world.func_147445_c(x, y, z + 1, false)) {
                dz = (double)(z + 1) + 0.0625;
            }
            if (amount == 3 && !world.func_147445_c(x, y, z - 1, false)) {
                dz = (double)(z + 0) - 0.0625;
            }
            if (amount == 4 && !world.func_147445_c(x + 1, y, z, false)) {
                dx = (double)(x + 1) + 0.0625;
            }
            if (amount == 5 && !world.func_147445_c(x - 1, y, z, false)) {
                dx = (double)(x + 0) - 0.0625;
            }
            if (!(dx < (double)x || dx > (double)(x + 1) || dy < 0.0 || dy > (double)(y + 1) || dz < (double)z) && !(dz > (double)(z + 1))) continue;
            world.func_72869_a(particleName, dx, dy, dz, -1.0, 1.0, -1.0);
        }
    }

    public static void blockSparkle(World world, int x, int y, int z, int count) {
        if (!world.field_72995_K) {
            return;
        }
        while (count < 10) {
            double startX = (float)x + world.field_73012_v.nextFloat();
            double startY = (float)y + world.field_73012_v.nextFloat() * 1.0f;
            double startZ = (float)z + world.field_73012_v.nextFloat();
            double endX = world.field_73012_v.nextGaussian() * 0.02;
            double endY = world.field_73012_v.nextGaussian() * 0.02;
            double endZ = world.field_73012_v.nextGaussian() * 0.02;
            EntityFlameFX ef = new EntityFlameFX(world, startX, startY, startZ, endX, endY, endZ);
            ef.func_70538_b(0.45f, 0.0f, 0.35f);
            ef.func_70536_a(82);
            ClientHelper.effectRenderer().func_78873_a((EntityFX)ef);
            ++count;
        }
    }

    public static void blockFlameFX(World world, int x, int y, int z, int count) {
        while (count < 10) {
            double startX = (float)x + world.field_73012_v.nextFloat();
            double startY = (float)y + world.field_73012_v.nextFloat() * 1.0f;
            double startZ = (float)z + world.field_73012_v.nextFloat();
            double endX = world.field_73012_v.nextGaussian() * 0.02;
            double endY = world.field_73012_v.nextGaussian() * 0.02;
            double endZ = world.field_73012_v.nextGaussian() * 0.02;
            EntityFlameFX ef = new EntityFlameFX(world, startX, startY, startZ, endX, endY, endZ);
            ClientHelper.effectRenderer().func_78873_a((EntityFX)ef);
            ++count;
        }
    }

    public static void displayFX(String name, World world, double dx, double dy, double dz, double velX, double velY, double velZ, float scale) {
        particle = null;
        if (name.equals("smoke")) {
            particle = new EntitySmokeFX(world, dx, dy, dz, velX, velY, velZ, scale);
        }
        double distX = ClientHelper.viewEntity().field_70165_t - EffectUtils.particle.field_70165_t;
        double distY = ClientHelper.viewEntity().field_70163_u - EffectUtils.particle.field_70163_u;
        double distZ = ClientHelper.viewEntity().field_70161_v - EffectUtils.particle.field_70161_v;
        int display = ClientHelper.settings().field_74362_aa;
        if (display == 1 && EffectUtils.particle.field_70170_p.field_73012_v.nextInt(3) == 0) {
            display = 2;
        }
        if (display <= 1 && distX * distX + distY * distY + distZ * distZ <= 4096.0) {
            ClientHelper.effectRenderer().func_78873_a(particle);
        }
    }

    public static void setGLColorFromInt(int color) {
        float red = (float)(color >> 16 & 0xFF) / 255.0f;
        float green = (float)(color >> 8 & 0xFF) / 255.0f;
        float blue = (float)(color & 0xFF) / 255.0f;
        GL11.glColor4f((float)red, (float)green, (float)blue, (float)1.0f);
    }
}

