/*
 * Decompiled with CFR 0.152.
 */
package moarcarts.renderers;

import boilerplate.common.utils.ItemStackUtils;
import cpw.mods.fml.client.FMLClientHandler;
import moarcarts.items.ItemMinecartBase;
import net.minecraft.client.Minecraft;
import net.minecraft.client.model.ModelBase;
import net.minecraft.client.model.ModelMinecart;
import net.minecraft.client.renderer.RenderBlocks;
import net.minecraft.client.renderer.texture.TextureMap;
import net.minecraft.client.renderer.tileentity.TileEntityRendererDispatcher;
import net.minecraft.item.ItemStack;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.ResourceLocation;
import net.minecraft.world.World;
import net.minecraftforge.client.IItemRenderer;
import org.lwjgl.opengl.GL11;

public class RenderItemMinecartBase
implements IItemRenderer {
    public static ResourceLocation TEXTURE = new ResourceLocation("textures/entity/minecart.png");
    public ModelBase model = new ModelMinecart();
    public TileEntity renderTileEntity;

    public boolean handleRenderType(ItemStack item, IItemRenderer.ItemRenderType type) {
        return type != IItemRenderer.ItemRenderType.FIRST_PERSON_MAP;
    }

    public boolean shouldUseRenderHelper(IItemRenderer.ItemRenderType type, ItemStack item, IItemRenderer.ItemRendererHelper helper) {
        return true;
    }

    public void renderItem(IItemRenderer.ItemRenderType type, ItemStack stack, Object ... data) {
        Object renderer = data[0];
        if (renderer instanceof RenderBlocks) {
            switch (type) {
                case ENTITY: {
                    GL11.glScaled((double)0.5, (double)0.5, (double)0.5);
                    this.render(stack, 0.0f, -0.25f, 0.0f, (RenderBlocks)renderer);
                    break;
                }
                case EQUIPPED: {
                    this.render(stack, 0.5f, 0.75f, 0.5f, (RenderBlocks)renderer);
                    break;
                }
                case EQUIPPED_FIRST_PERSON: {
                    this.render(stack, -0.5f, 1.0f, 0.7f, (RenderBlocks)renderer);
                    break;
                }
                case INVENTORY: {
                    GL11.glScaled((double)1.2, (double)1.2, (double)1.2);
                    this.render(stack, -0.5f, -0.45f, -0.5f, (RenderBlocks)renderer);
                    break;
                }
            }
        }
    }

    private void render(ItemStack stack, float x, float y, float z, RenderBlocks renderer) {
        GL11.glPushMatrix();
        GL11.glTranslated((double)x, (double)y, (double)z);
        GL11.glEnable((int)3008);
        FMLClientHandler.instance().getClient().field_71446_o.func_110577_a(TextureMap.field_110575_b);
        GL11.glPushMatrix();
        GL11.glScaled((double)0.5625, (double)0.5625, (double)0.5625);
        GL11.glRotated((double)270.0, (double)0.0, (double)1.0, (double)0.0);
        GL11.glTranslated((double)0.0, (double)0.375, (double)0.0);
        if (ItemStackUtils.isItemInstanceOf((ItemStack)stack, ItemMinecartBase.class)) {
            ItemMinecartBase itemMinecartBase = (ItemMinecartBase)stack.func_77973_b();
            switch (itemMinecartBase.getCartBlockRenderMethod(stack)) {
                case VMC: {
                    this.renderVMCMethod(renderer, stack, itemMinecartBase);
                    break;
                }
                case ISBRH: {
                    this.renderVMCMethod(renderer, stack, itemMinecartBase);
                    break;
                }
                case TESR: {
                    this.renderTESRMethod(stack, itemMinecartBase);
                    break;
                }
                case CUSTOM: {
                    this.renderCustom(stack, itemMinecartBase);
                    break;
                }
            }
        }
        GL11.glColor4f((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        GL11.glPopMatrix();
        GL11.glRotated((double)90.0, (double)0.0, (double)1.0, (double)0.0);
        GL11.glScaled((double)0.75, (double)0.75, (double)0.75);
        GL11.glScaled((double)-1.0, (double)-1.0, (double)1.0);
        FMLClientHandler.instance().getClient().field_71446_o.func_110577_a(TEXTURE);
        this.model.func_78088_a(null, 0.0f, 0.0f, -0.1f, 0.0f, 0.0f, 0.0625f);
        GL11.glPopMatrix();
    }

    protected void renderVMCMethod(RenderBlocks renderer, ItemStack itemStack, ItemMinecartBase itemMinecartBase) {
        renderer.func_147800_a(itemMinecartBase.getCartBlock(itemStack), itemMinecartBase.getCartBlockMetadata(itemStack), 1.0f);
    }

    protected void renderTESRMethod(ItemStack itemStack, ItemMinecartBase itemMinecartBase) {
        if (this.renderTileEntity == null) {
            this.renderTileEntity = itemMinecartBase.getCartBlock(itemStack).createTileEntity((World)Minecraft.func_71410_x().field_71441_e, itemMinecartBase.getCartBlockMetadata(itemStack));
        }
        if (this.renderTileEntity != null) {
            this.rotateTESR();
            GL11.glTranslatef((float)-0.5f, (float)-0.5f, (float)-0.5f);
            TileEntityRendererDispatcher.field_147556_a.func_147549_a(this.renderTileEntity, 0.0, 0.0, 0.0, 0.0f);
            GL11.glEnable((int)32826);
        }
    }

    protected void renderCustom(ItemStack itemStack, ItemMinecartBase itemMinecartBase) {
    }

    protected void rotateTESR() {
        GL11.glRotated((double)90.0, (double)0.0, (double)1.0, (double)0.0);
    }
}

