/*
 * Decompiled with CFR 0.152.
 */
package moarcarts.items;

import boilerplate.common.utils.BlockUtils;
import com.mojang.authlib.GameProfile;
import cpw.mods.fml.common.Optional;
import moarcarts.MoarCarts;
import moarcarts.behaviors.CartDispenserBehavior;
import moarcarts.config.ConfigSettings;
import moarcarts.entities.EntityMinecartBase;
import moarcarts.entities.EntityMinecartTEBase;
import moarcarts.renderers.IRenderBlock;
import mods.railcraft.api.carts.CartTools;
import mods.railcraft.api.core.items.IMinecartItem;
import net.minecraft.block.Block;
import net.minecraft.block.BlockDispenser;
import net.minecraft.creativetab.CreativeTabs;
import net.minecraft.entity.Entity;
import net.minecraft.entity.item.EntityMinecart;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.ItemMinecart;
import net.minecraft.item.ItemStack;
import net.minecraft.world.World;

@Optional.Interface(modid="RailcraftAPI|items", iface="mods.railcraft.api.core.items.IMinecartItem")
public abstract class ItemMinecartBase
extends ItemMinecart
implements IMinecartItem {
    public ItemMinecartBase(String mod, String name) {
        super(0);
        this.func_77655_b(name);
        this.func_111206_d("moarcarts:defaultcart");
        this.func_77637_a((CreativeTabs)MoarCarts.moarcartsTab);
        this.func_77625_d(ConfigSettings.getMinecartStackSize());
        BlockDispenser.field_149943_a.func_82595_a((Object)this, (Object)new CartDispenserBehavior());
    }

    public boolean func_77648_a(ItemStack itemStack, EntityPlayer player, World world, int i, int j, int k, int l, float par8, float par9, float par10) {
        return this.placeCart(itemStack, world, i, j, k, this.getEntityFromItem(world, itemStack));
    }

    @Optional.Method(modid="RailcraftAPI|items")
    public boolean canBePlacedByNonPlayer(ItemStack itemStack) {
        return itemStack != null;
    }

    @Optional.Method(modid="RailcraftAPI|items")
    public EntityMinecart placeCart(GameProfile gameProfile, ItemStack itemStack, World world, int posX, int posY, int posZ) {
        EntityMinecartBase entityMinecart = this.getEntityFromItem(world, itemStack);
        CartTools.setCartOwner((EntityMinecart)entityMinecart, (GameProfile)gameProfile);
        if (this.placeCart(itemStack, world, posX, posY, posZ, entityMinecart)) {
            return entityMinecart;
        }
        return null;
    }

    public boolean placeCart(ItemStack itemStack, World world, int posX, int posY, int posZ, EntityMinecartBase entityMinecart) {
        if (itemStack != null && BlockUtils.isRailBlock((Block)world.func_147439_a(posX, posY, posZ))) {
            if (itemStack.func_82837_s()) {
                entityMinecart.func_96094_a(itemStack.func_82833_r());
            }
            if (!world.field_72995_K) {
                entityMinecart.field_70165_t = (float)posX + 0.5f;
                entityMinecart.field_70163_u = (float)posY + 0.5f;
                entityMinecart.field_70161_v = (float)posZ + 0.5f;
                if (entityMinecart instanceof EntityMinecartTEBase) {
                    EntityMinecartTEBase entityMinecartTEBase = (EntityMinecartTEBase)entityMinecart;
                    entityMinecartTEBase.setTileEntityNBT(itemStack);
                    world.func_72838_d((Entity)entityMinecartTEBase);
                } else {
                    world.func_72838_d((Entity)entityMinecart);
                }
                entityMinecart.afterEntitySpawned();
            }
            --itemStack.field_77994_a;
            return true;
        }
        return false;
    }

    public IRenderBlock.RenderMethod getCartBlockRenderMethod(ItemStack itemStack) {
        return IRenderBlock.RenderMethod.VMC;
    }

    public int getCartBlockMetadata(ItemStack itemStack) {
        return 0;
    }

    public abstract Block getCartBlock(ItemStack var1);

    public abstract EntityMinecartBase getEntityFromItem(World var1, ItemStack var2);
}

